/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundMixer {
    public static final Byte AMR = new Byte(0);
    public static final Byte MIDI = new Byte(1);
    public static final Byte AMR_WB = new Byte(2);
    private static final byte NAME = 0;
    private static final byte PLAYER = 1;
    private static final byte BUFFER = 2;
    private static final byte TYPE = 3;
    private static final byte VOLUME = 4;
    private static final byte LOOP = 5;
    private static final byte TIMEOFFSET = 6;
    boolean mute;
    boolean amr;
    boolean amr_wb;
    boolean midi;
    boolean mixing;
    Object[] sounds;
    int volume = 100;

    public SoundMixer(int n) {
        String string;
        this.sounds = new Object[n];
        String[] stringArray = Manager.getSupportedContentTypes(null);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf("audio/amr") >= 0) {
                    this.amr = true;
                }
                if (stringArray[i].indexOf("audio/amr-wb") >= 0) {
                    this.amr_wb = true;
                }
                if (stringArray[i].indexOf("audio/midi") < 0) continue;
                this.midi = true;
            }
        }
        if ((string = System.getProperty("supports.mixing")) != null && string.equals("true")) {
            this.mixing = true;
        }
    }

    void setSound(int n, String string, int n2, long l) {
        Object[] objectArray = new Object[7];
        objectArray[0] = string;
        objectArray[5] = new Byte((byte)n2);
        if (l > 0L) {
            objectArray[6] = new Long(l);
        }
        this.sounds[n] = objectArray;
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean bl) {
        this.mute = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSound(int n) {
        Object[] objectArray = (Object[])this.sounds[n];
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[0];
        Byte by = null;
        String string2 = "";
        if (string.endsWith(".amr") && this.amr) {
            by = AMR;
            string2 = "audio/amr";
        } else if (string.endsWith(".awb") && this.amr_wb) {
            by = AMR_WB;
            string2 = "audio/amr-wb";
        } else if (string.endsWith(".mid") && this.midi) {
            by = MIDI;
            string2 = "audio/midi";
        } else {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            Player player = Manager.createPlayer((InputStream)inputStream, (String)string2);
            objectArray[1] = player;
            objectArray[3] = by;
            player.prefetch();
            player.setLoopCount((int)((Byte)objectArray[5]).byteValue());
            VolumeControl volumeControl = (VolumeControl)player.getControl("javax.microedition.media.control.VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(this.volume);
                objectArray[4] = volumeControl;
            }
        }
        catch (Exception exception) {
            objectArray[3] = null;
            objectArray[1] = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    boolean isSoundPlaying(int n) {
        Object[] objectArray = (Object[])this.sounds[n];
        if (objectArray == null) {
            return false;
        }
        Player player = (Player)objectArray[1];
        return player != null && player.getState() == 400;
    }

    boolean isAnySoundPlaying() {
        for (int i = 0; i < this.sounds.length; ++i) {
            if (!this.isSoundPlaying(i)) continue;
            return true;
        }
        return false;
    }

    boolean isAnySoundPlaying(Byte by) {
        for (int i = 0; i < this.sounds.length; ++i) {
            Object[] objectArray;
            if (this.sounds[i] == null || (objectArray = (Object[])this.sounds[i])[3] != by || !this.isSoundPlaying(i)) continue;
            return true;
        }
        return false;
    }

    void playSound(int n) {
        this.playSound(n, false);
    }

    void playSound(int n, boolean bl) {
        if (this.mute) {
            return;
        }
        Object[] objectArray = (Object[])this.sounds[n];
        if (objectArray == null) {
            return;
        }
        if (this.isSoundPlaying(n) && !bl) {
            return;
        }
        Byte by = (Byte)objectArray[3];
        if (by == MIDI) {
            if (this.isAnySoundPlaying(MIDI) && !bl) {
                return;
            }
            this.stopAllSounds(MIDI);
        }
        if (!this.mixing && by != MIDI) {
            if (this.isAnySoundPlaying() && !bl) {
                return;
            }
            this.stopAllSounds();
        }
        try {
            Player player = (Player)objectArray[1];
            if (player == null) {
                this.loadSound(n);
                player = (Player)objectArray[1];
            }
            if (player != null) {
                if (player.getState() == 400) {
                    player.stop();
                }
                if (objectArray[6] != null) {
                    player.setMediaTime(((Long)objectArray[6]).longValue());
                }
                player.start();
                VolumeControl volumeControl = (VolumeControl)objectArray[4];
                if (volumeControl != null) {
                    volumeControl.setLevel(this.volume);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void stopAllSounds() {
        for (int i = 0; i < this.sounds.length; ++i) {
            this.stopSound(i);
        }
    }

    void stopAllSounds(Byte by) {
        for (int i = 0; i < this.sounds.length; ++i) {
            Object[] objectArray = (Object[])this.sounds[i];
            if (objectArray == null || objectArray[3] != by) continue;
            this.stopSound(i);
        }
    }

    void stopSound(int n) {
        try {
            Player player;
            Object[] objectArray = (Object[])this.sounds[n];
            if (objectArray != null && (player = (Player)objectArray[1]) != null && player.getState() == 400) {
                player.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void releaseAllSounds() {
        for (int i = 0; i < this.sounds.length; ++i) {
            this.releaseSound(i);
        }
    }

    void releaseSound(int n) {
        this.stopSound(n);
        try {
            Object[] objectArray = (Object[])this.sounds[n];
            if (objectArray != null) {
                Player player = (Player)objectArray[1];
                if (player != null) {
                    player.close();
                }
                objectArray[1] = null;
                objectArray[2] = null;
                objectArray[4] = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

