/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.Event;
import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.Rect;
import javax.microedition.lcdui.Graphics;

public class GameLayer {
    int x;
    int y;
    int width;
    int height;
    boolean visible = true;
    Event event;
    GameLayer clipLayer;
    static Rect clipRegion = new Rect();
    Event pointerPressedEvent;
    Event pointerReleasedEvent;

    void setPosition(int n, int n2) {
        if (this.visible) {
            this.repaint();
            this.x = n;
            this.y = n2;
            this.repaint();
        } else {
            this.x = n;
            this.y = n2;
        }
    }

    void center() {
        this.setPosition(Game.canvasCenterX - this.width / 2, Game.canvasCenterY - this.height / 2);
    }

    void center(GameLayer gameLayer) {
        this.setPosition(gameLayer.getCenterX() - this.width / 2, gameLayer.getCenterY() - this.height / 2);
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getCenterX() {
        return this.x + this.width / 2;
    }

    int getCenterY() {
        return this.y + this.height / 2;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    void setWidth(int n) {
        this.repaint();
        this.width = n;
        this.repaint();
    }

    void setHeight(int n) {
        this.repaint();
        this.height = n;
        this.repaint();
    }

    void paint(Graphics graphics) {
    }

    void animate() {
    }

    void move(int n, int n2) {
        this.setPosition(this.x + n, this.y + n2);
    }

    void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.repaint();
        }
    }

    void repaint() {
        if (this.clipLayer == null) {
            Game.layerManager.redrawRegion(this.x, this.y, this.width, this.height);
        } else {
            GameLayer.clipRegion.x = this.x;
            GameLayer.clipRegion.y = this.y;
            GameLayer.clipRegion.w = this.width;
            GameLayer.clipRegion.h = this.height;
            this.clipLayer.clipRect(clipRegion);
            Game.layerManager.redrawRegion(GameLayer.clipRegion.x, GameLayer.clipRegion.y, GameLayer.clipRegion.w, GameLayer.clipRegion.h);
        }
    }

    void clipRect(Rect rect) {
        rect.clipTo(this.x, this.y, this.width, this.height);
        if (this.clipLayer != null) {
            this.clipLayer.clipRect(rect);
        }
    }

    void setClipLayer(GameLayer gameLayer) {
        this.clipLayer = gameLayer;
    }

    boolean isVisible() {
        return this.visible;
    }

    void setEvent(Event event) {
        this.event = event;
    }

    Event getEvent() {
        return this.event;
    }

    void processEvent(Event event) {
    }

    void keyFire() {
        Game.event(this.event);
    }

    void keySoft1() {
        Game.event(this.event);
    }

    void keySoft2() {
        Game.event(this.event);
    }

    void keyUp() {
        Game.event(this.event);
    }

    void keyDown() {
        Game.event(this.event);
    }

    void keyLeft() {
        Game.event(this.event);
    }

    void keyRight() {
        Game.event(this.event);
    }

    void addNotify() {
    }

    void removeNotify() {
    }

    void doLayout() {
    }

    void gamePaused() {
    }

    void gameResumed() {
    }

    void release() {
        this.event = null;
        this.pointerPressedEvent = null;
        this.pointerReleasedEvent = null;
        this.clipLayer = null;
    }

    void setPointerPressedEvent(Event event) {
        this.pointerPressedEvent = event;
    }

    void setPointerReleasedEvent(Event event) {
        this.pointerReleasedEvent = event;
    }

    boolean pointerPressed(int n, int n2) {
        if (this.pointerPressedEvent != null) {
            Game.event(this.pointerPressedEvent);
            return true;
        }
        return this.pointerReleasedEvent != null;
    }

    void pointerReleased(int n, int n2) {
        Game.event(this.pointerReleasedEvent);
    }

    void pointerDragged(int n, int n2) {
    }
}

