/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.MiniGame;
import de.softgames.pl.mylittlefarm.StaticImage;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Pawn
extends GameLayer {
    public static final byte STATE_NONE = 0;
    public static final byte STATE_ANIMATE = 1;
    public static final byte STATE_MOVE = 2;
    public static final byte STATE_EXPLODE3 = 3;
    public static final byte STATE_EXPLODE4 = 4;
    public static final byte STATE_REMOVED = 5;
    public static final byte SKULL = 0;
    public static final byte FIRE = 1;
    public static final byte HEART = 2;
    public static final byte ZEBRA = 3;
    public static final byte YING = 4;
    public static final byte STAR = 5;
    public static final byte JOCKERX2 = 6;
    public static final byte JOCKERX3 = 7;
    public static byte moveCounter;
    public static byte explodeCounter;
    StaticImage explosion;
    StaticImage explosion2;
    Sprite sprite;
    byte color;
    byte frame;
    byte explosionframe;
    byte state;
    short dstX;
    short dstY;
    static byte[][] pawnFrameSequence;
    static byte[] match3FrameSequence;
    static byte[] match4FrameSequence;
    static int PAWN_SPEED;

    public Pawn(Sprite sprite, int n) {
        this.sprite = sprite;
        this.width = sprite.getWidth();
        this.height = sprite.getHeight();
        this.color = (byte)n;
        if (PAWN_SPEED == 0) {
            PAWN_SPEED = Game.getInteger(5);
        }
    }

    void setState(byte by) {
        if (this.state == by) {
            return;
        }
        this.state = by;
        switch (this.state) {
            case 0: {
                this.frame = 0;
                this.repaint();
                break;
            }
            case 1: {
                this.frame = 0;
                break;
            }
            case 2: {
                this.setVisible(true);
                moveCounter = (byte)(moveCounter + 1);
                this.frame = 0;
                break;
            }
            case 3: {
                this.frame = 0;
                if (this.explosion != null) break;
                explodeCounter = (byte)(explodeCounter + 1);
                this.explosionframe = (byte)(-Game.rand(4) - 1);
                this.explosion = new StaticImage(Game.getSprite(Game.SPRITE_MATCH_EFFECT));
                this.explosion.setPosition(this.x, this.y);
                this.explosion.setVisible(false);
                Game.layerManager.add(this.explosion);
                break;
            }
            case 4: {
                this.frame = 0;
                if (this.explosion != null) break;
                explodeCounter = (byte)(explodeCounter + 1);
                this.explosionframe = (byte)(-Game.rand(4) - 1);
                this.explosion = new StaticImage(Game.getSprite(Game.SPRITE_MATCH_EFFECT));
                this.explosion.setPosition(this.x, this.y);
                this.explosion.setVisible(false);
                Game.layerManager.add(this.explosion);
            }
        }
    }

    void move(int n, int n2) {
        super.move(n, n2);
        if (this.explosion != null) {
            this.explosion.move(n, n2);
        }
        if (this.explosion2 != null) {
            this.explosion2.move(n, n2);
        }
        this.dstX = (short)(this.dstX + n);
        this.dstY = (short)(this.dstY + n2);
    }

    void moveTo(int n, int n2) {
        this.dstX = (short)n;
        this.dstY = (short)n2;
    }

    boolean isSameColor(Pawn pawn) {
        return this.color == pawn.color || this.isJocker() || pawn.isJocker();
    }

    boolean isJocker() {
        return this.color == 6 || this.color == 7;
    }

    boolean isExploding() {
        return this.state == 3 || this.state == 4;
    }

    int multiplyPoints(int n) {
        if (this.color == 6) {
            return n * 2;
        }
        if (this.color == 7) {
            return n * 3;
        }
        return n;
    }

    void animate() {
        if (MiniGame.paused) {
            return;
        }
        if (this.explosion2 != null) {
            if (this.explosion2.frame < 7) {
                this.explosion2.setFrame(this.explosion2.frame + 1);
            } else {
                Game.layerManager.remove(this.explosion2);
                this.explosion2.release();
                this.explosion2 = null;
            }
        }
        if (MiniGame.gameOver) {
            return;
        }
        switch (this.state) {
            case 0: {
                if (!this.isJocker()) break;
                this.state = 1;
                break;
            }
            case 1: {
                this.frame = (byte)(this.frame + 1);
                if (this.frame == pawnFrameSequence[this.color].length) {
                    this.frame = 0;
                }
                this.repaint();
                break;
            }
            case 2: {
                int n = this.x;
                int n2 = this.y;
                int n3 = PAWN_SPEED;
                if (this.x < this.dstX) {
                    if ((n += n3) > this.dstX) {
                        n = this.dstX;
                    }
                } else if (this.x > this.dstX && (n -= n3) < this.dstX) {
                    n = this.dstX;
                }
                if (this.y < this.dstY) {
                    if ((n2 += n3) > this.dstY) {
                        n2 = this.dstY;
                    }
                } else if (this.y > this.dstY && (n2 -= n3) < this.dstY) {
                    n2 = this.dstY;
                }
                if (this.x != n || this.y != n2) {
                    this.setPosition(n, n2);
                    break;
                }
                this.setState((byte)0);
                moveCounter = (byte)(moveCounter - 1);
                break;
            }
            case 3: {
                this.explosionframe = (byte)(this.explosionframe + 1);
                if (this.explosionframe == 0) {
                    this.explosion.setVisible(true);
                }
                if (this.explosionframe > 0 && this.explosionframe < 8) {
                    this.explosion.setFrame(match3FrameSequence[this.explosionframe]);
                }
                if (this.explosionframe == 5) {
                    this.setVisible(false);
                    if (this.explosion2 == null) {
                        this.explosion2 = new StaticImage(Game.getSprite(Game.SPRITE_EXPLOSION));
                        this.explosion2.setPosition(this.x + this.width / 2 - this.explosion2.getWidth() / 2 + Game.rand() % Game.getInteger(10), this.y + this.height / 2 - this.explosion2.getHeight() / 2 + Game.rand() % Game.getInteger(10));
                        Game.layerManager.add(this.explosion2);
                    }
                }
                if (this.explosionframe != 8) break;
                Game.layerManager.remove(this.explosion);
                this.explosion.release();
                this.explosion = null;
                this.setState((byte)5);
                explodeCounter = (byte)(explodeCounter - 1);
                break;
            }
            case 4: {
                this.explosionframe = (byte)(this.explosionframe + 1);
                if (this.explosionframe == 0) {
                    this.explosion.setVisible(true);
                }
                if (this.explosionframe > 0 && this.explosionframe < 8) {
                    this.explosion.setFrame(match4FrameSequence[this.explosionframe]);
                }
                if (this.explosionframe == 5) {
                    this.setVisible(false);
                    if (this.explosion2 == null) {
                        this.explosion2 = new StaticImage(Game.getSprite(Game.SPRITE_EXPLOSION));
                        this.explosion2.setPosition(this.x + this.width / 2 - this.explosion2.getWidth() / 2 + Game.rand() % 10, this.y + this.height / 2 - this.explosion2.getHeight() / 2 + Game.rand() % 10);
                        Game.layerManager.add(this.explosion2);
                    }
                }
                if (this.explosionframe != 8) break;
                Game.layerManager.remove(this.explosion);
                this.explosion.release();
                this.explosion = null;
                this.setState((byte)5);
                explodeCounter = (byte)(explodeCounter - 1);
            }
        }
    }

    void paint(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.clipRect(this.x, this.y, this.width, this.height);
        this.sprite.setFrame((int)pawnFrameSequence[this.color][this.frame]);
        this.sprite.setTransform(0);
        this.sprite.setPosition(this.x, this.y);
        this.sprite.paint(graphics);
        graphics.setClip(n, n2, n3, n4);
    }

    void release() {
        super.release();
        this.sprite = null;
    }

    static {
        pawnFrameSequence = new byte[][]{{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 3, 3, 2, 2, 1, 1, 0, 0, 0, 0, 0, 0}, {5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 8, 8, 7, 7, 6, 6, 5, 5, 5, 5, 5, 5}, {10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 10, 10, 10, 10}, {15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 15, 15, 15}, {20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 23, 23, 22, 22, 21, 21, 20, 20, 20, 20, 20, 20}, {25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 28, 28, 27, 27, 26, 26, 25, 25, 25, 25, 25, 25}, {30, 30, 30, 30, 31, 31, 32, 32, 32, 32, 31, 31}, {30, 30, 30, 30, 33, 33, 34, 34, 34, 34, 33, 33}};
        match3FrameSequence = new byte[]{8, 9, 10, 11, 4, 5, 6, 7};
        match4FrameSequence = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        PAWN_SPEED = 0;
    }
}

