/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class StaticImage
extends GameLayer {
    Image image;
    Sprite sprite;
    int frame;
    int transform;
    int alpha = 100;
    int[] pixels;

    public StaticImage(Image image) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public StaticImage(Sprite sprite) {
        this(sprite, 0, 0, sprite.getWidth(), sprite.getHeight());
    }

    public StaticImage(Sprite sprite, int n, int n2) {
        this.sprite = sprite;
        this.sprite.setFrame(n);
        this.sprite.setTransform(n2);
        this.frame = n;
        this.transform = n2;
        this.width = sprite.getWidth();
        this.height = sprite.getHeight();
    }

    public StaticImage(Sprite sprite, int n, int n2, int n3, int n4) {
        this.sprite = sprite;
        this.frame = n;
        this.transform = n2;
        this.width = n3;
        this.height = n4;
    }

    void setFrame(int n) {
        this.frame = n;
        this.repaint();
    }

    void setFrame(int n, int n2) {
        this.frame = n;
        this.transform = n2;
        this.repaint();
    }

    void setFrame(int n, int n2, boolean bl) {
        if (bl) {
            this.repaint();
            this.sprite.setFrame(n);
            this.sprite.setTransform(n2);
            this.width = this.sprite.getWidth();
            this.height = this.sprite.getHeight();
        }
        this.frame = n;
        this.transform = n2;
        this.repaint();
    }

    void setTransform(int n, boolean bl) {
        if (bl) {
            this.repaint();
            this.sprite.setFrame(this.frame);
            this.sprite.setTransform(n);
            this.width = this.sprite.getWidth();
            this.height = this.sprite.getHeight();
        }
        this.transform = n;
        this.repaint();
    }

    int getFrameCount() {
        return this.sprite != null ? this.sprite.getRawFrameCount() : 1;
    }

    boolean isNextFrame() {
        return this.frame < this.getFrameCount() - 1;
    }

    void nextFrame() {
        ++this.frame;
        if (this.frame == this.getFrameCount()) {
            this.frame = 0;
        }
        this.repaint();
    }

    void setWidth(int n) {
        this.repaint();
        this.width = n;
        this.repaint();
    }

    void setHeight(int n) {
        this.repaint();
        this.height = n;
        this.repaint();
    }

    int getSpriteWidth() {
        return this.sprite.getWidth();
    }

    void paint(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.clipRect(this.x, this.y, this.width, this.height);
        if (this.image != null) {
            if (this.pixels == null) {
                graphics.drawImage(this.image, this.x, this.y, 0);
            } else {
                graphics.drawRGB(this.pixels, 0, this.width, this.x, this.y, this.width, this.height, true);
            }
        } else if (this.sprite != null) {
            this.sprite.setFrame(this.frame);
            this.sprite.setTransform(this.transform);
            int n5 = this.sprite.getWidth();
            int n6 = this.sprite.getHeight();
            if (n5 == this.width && n6 == this.height) {
                this.sprite.setPosition(this.x, this.y);
                this.sprite.paint(graphics);
            } else {
                int n7 = this.x + (graphics.getClipX() - this.x) / n5 * n5;
                int n8 = this.y + (graphics.getClipY() - this.y) / n6 * n6;
                int n9 = graphics.getClipX() + graphics.getClipWidth();
                int n10 = graphics.getClipY() + graphics.getClipHeight();
                for (int i = n8; i < n10; i += n6) {
                    for (int j = n7; j < n9; j += n5) {
                        this.sprite.setPosition(j, i);
                        this.sprite.paint(graphics);
                    }
                }
            }
        }
        graphics.setClip(n, n2, n3, n4);
    }

    int getAlpha() {
        return this.alpha;
    }

    void setAlpha(int n) {
        if (this.pixels == null) {
            this.pixels = new int[this.width * this.height];
        }
        this.image.getRGB(this.pixels, 0, this.width, 0, 0, this.width, this.height);
        int n2 = Game.fixDiv(n << 16, 0x640000);
        for (int i = this.pixels.length - 1; i >= 0; --i) {
            int n3 = this.pixels[i];
            int n4 = n3 >> 24 & 0xFF;
            n4 = Game.fixMul(n2, n4 << 16) >> 16;
            int n5 = (n3 & 0xFF0000) >> 16;
            int n6 = (n3 & 0xFF00) >> 8;
            int n7 = n3 & 0xFF;
            this.pixels[i] = n4 << 24 | n5 << 16 | n6 << 8 | n7;
        }
        this.alpha = n;
        this.repaint();
    }

    void release() {
        super.release();
        this.image = null;
        this.sprite = null;
        this.pixels = null;
    }
}

