/*
 * Decompiled with CFR 0.152.
 */
package Game.System;

import Game.System.SystemValue;
import java.io.IOException;
import java.io.InputStream;

public class FontData {
    public String ENCODE = "GB2312";
    private int diameter;
    byte[] FontData;
    int read_bytePerCNFont;
    byte[] read_CNdata;
    byte[] drawString_data;
    int[] drawString_code;
    int drawString_interval;
    int drawString_i16;
    int drawString_line;
    int drawString_i;
    int drawString_index;
    int read_area;
    int read_offset;
    int read_i;
    int read_pos;
    byte[] getByteCode_data;
    int[] getByteCode_byteCode = new int[2];

    public FontData(String fontFileName, int diameter) {
        this.diameter = diameter;
        this.read_bytePerCNFont = ((diameter - 1) / 8 + 1) * diameter;
        this.read_CNdata = new byte[this.read_bytePerCNFont];
        InputStream in = this.getClass().getResourceAsStream(fontFileName);
        try {
            this.FontData = new byte[196608];
            in.read(this.FontData);
            in.close();
            in = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void drawString(String str, int x, int y) {
        this.drawString_index = 0;
        while (this.drawString_index < str.length()) {
            this.drawString_interval = this.drawString_index * this.diameter;
            this.drawString_code = str.charAt(this.drawString_index) < '\u0080' ? (str.charAt(this.drawString_index) == ' ' ? this.getByteCode(String.valueOf('\u3000')) : this.getByteCode(String.valueOf((char)(str.charAt(this.drawString_index) + 65248)))) : this.getByteCode(str.substring(this.drawString_index, this.drawString_index + 1));
            this.drawString_data = this.read(this.drawString_code[0], this.drawString_code[1]);
            this.drawString_line = 0;
            while (this.drawString_line < this.diameter) {
                this.drawString_i16 = this.drawString_data[this.drawString_line << 1] & 0xFF;
                this.drawString_i16 = this.drawString_i16 << 8 | this.drawString_data[(this.drawString_line << 1) + 1] & 0xFF;
                this.drawString_i = 0;
                while (this.drawString_i < this.diameter) {
                    if ((this.drawString_i16 & 32768 >> this.drawString_i) != 0) {
                        SystemValue.G.drawLine(x + this.drawString_i + this.drawString_interval, y + this.drawString_line, x + this.drawString_i + this.drawString_interval, y + this.drawString_line);
                    }
                    ++this.drawString_i;
                }
                ++this.drawString_line;
            }
            ++this.drawString_index;
        }
    }

    protected byte[] read(int areaCode, int posCode) {
        try {
            this.read_area = areaCode - 160;
            this.read_pos = posCode - 160;
            this.read_i = this.read_offset = this.read_bytePerCNFont * ((this.read_area - 1) * 94 + this.read_pos - 1);
            while (this.read_i < this.read_offset + this.read_bytePerCNFont) {
                this.read_CNdata[this.read_i - this.read_offset] = this.FontData[this.read_i];
                ++this.read_i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.read_CNdata;
    }

    protected int[] getByteCode(String str) {
        try {
            this.getByteCode_data = str.getBytes(this.ENCODE);
            this.getByteCode_byteCode[0] = this.getByteCode_data[0] & 0xFF;
            this.getByteCode_byteCode[1] = this.getByteCode_data[1] & 0xFF;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getByteCode_byteCode;
    }
}

