--       _________ __                 __                               
--      /   _____//  |_____________ _/  |______     ____  __ __  ______
--      \_____  \\   __\_  __ \__  \\   __\__  \   / ___\|  |  \/  ___/
--      /        \|  |  |  | \// __ \|  |  / __ \_/ /_/  >  |  /\___ \ 
--     /_______  /|__|  |__|  (____  /__| (____  /\___  /|____//____  >
--             \/                  \/          \//_____/            \/ 
--  ______________________                           ______________________
--			  T H E   W A R   B E G I N S
--	   Stratagus - A free fantasy real time strategy game engine
--
--	ui.ccl		-	Define the orc user interface
--
--	(c) Copyright 2001-2003 by Lutz Sammer and Jimmy Salmon
--
--      This program is free software; you can redistribute it and/or modify
--      it under the terms of the GNU General Public License as published by
--      the Free Software Foundation; either version 2 of the License, or
--      (at your option) any later version.
--  
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--  
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--
--	$Id: ui.lua,v 1.10 2004/05/31 19:57:49 jsalmon3 Exp $

DefineCursor({
  Name = "cursor-point",
  Race = "orc",
  File = "ui/orc/cursors/orcish_claw.png",
  HotSpot = { 3/2,  2/2},
  Size = {26/2, 32/2}})
DefineCursor({
  Name = "cursor-green-hair",
  Race = "orc",
  File = "ui/orc/cursors/green_crosshairs.png",
  HotSpot = {15/2, 15/2},
  Size = {32/2, 32/2}})
DefineCursor({
  Name = "cursor-yellow-hair",
  Race = "orc",
  File = "ui/orc/cursors/yellow_crosshairs.png",
  HotSpot = {15/2, 15/2},
  Size = {32/2, 32/2}})
DefineCursor({
  Name = "cursor-red-hair",
  Race = "orc",
  File = "ui/orc/cursors/red_crosshairs.png",
  HotSpot = {15/2, 15/2},
  Size = {32/2, 32/2}})

--;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
--	* Race orc.
--;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

function OrcScreen(screen_width, screen_height)
  local info_panel_x = 0
  local info_panel_y = 160/2
  local icon_size = {46/2, 38/2}

  DefineUI("orc", screen_width, screen_height,
    "normal-font-color", "yellow",
    "reverse-font-color", "white",

    "filler", {
      "file", "graphics/ui/orc/" ..
        screen_width .. "x" .. screen_height ..
        "/filler-right.png",
      "pos", { screen_width - 16/2, 0}},

    "resource-line", {
      "graphics/ui/orc/" ..
        screen_width .. "x" .. screen_height ..
        "/resource.png",
      176/2, 0},

    "resources", {
      "gold", { "file", "graphics/ui/gold,wood,oil,mana.png", "frame", 0,
        "pos", { 176/2 + 0, 0}, "size", {14/2, 14/2}, "text-pos", { 176/2 + 0 + 18/2, 1}},
      "wood", { "file", "graphics/ui/gold,wood,oil,mana.png", "frame", 1,
        "pos", { 176/2 + 75/2+10, 0}, "size", {14/2, 14/2}, "text-pos", { 176/2 + 75/2 + 18/2+10, 1}},
      "oil", { "file", "graphics/ui/gold,wood,oil,mana.png", "frame", 2,
        "pos", { 176/2 + 150/2+10, 0}, "size", {14/2, 14/2}, "text-pos", { 176/2 + 150/2 + 18/2+10, 1}},
      "food", { "file", "graphics/ui/food.png", "frame", 0,
        "pos", { screen_width - 16/2 - 138/2 -15, 0}, "size", {14/2, 14/2}, "text-pos", { (screen_width - 16/2 - 138/2) + 18/2-15, 1}},
      "score", { "file", "graphics/ui/score.png", "frame", 0,
        "pos", { screen_width - 16/2 - 68/2 -5, 0}, "size", {14/2, 14/2}, "text-pos", { (screen_width - 16/2 - 68/2) + 18/2-5, 1}}},

    "info-panel", {
      "panel", {
        "file", "graphics/ui/orc/infopanel.png",
        "pos", { info_panel_x, info_panel_y},
        "size", {176/2, 176/2}
      },
      "selected", {
        "single", {
          "icon", {
            "pos", {  6/2, 166/2}, "size", icon_size}},
        "multiple", {
          "icons", {
            { "pos", {  6/2-2, 166/2-2}, "size", icon_size},
            { "pos", { 62/2-2, 166/2-2}, "size", icon_size},
            { "pos", {118/2-2, 166/2-2}, "size", icon_size},
            { "pos", {  6/2-2, 220/2-2}, "size", icon_size},
            { "pos", { 62/2-2, 220/2-2}, "size", icon_size},
            { "pos", {118/2-2, 220/2-2}, "size", icon_size},
            { "pos", {  6/2-2, 274/2-2}, "size", icon_size},
            { "pos", { 62/2-2, 274/2-2}, "size", icon_size},
            { "pos", {118/2-2, 274/2-2}, "size", icon_size}},
          "max-text", {
            "font", "game",
            "pos", { info_panel_x + 10/2, info_panel_y + 10/2}}}
      },
      "training", {
        "single", {
          "text", {
            "text", ":",
            "font", "game",
            "pos", { info_panel_x + 37/2, info_panel_y + 8/2 + 78/2 - 8}},
          "icon", {
            "pos", { info_panel_x + 107/2, info_panel_y + 8/2 + 70/2 + 4},
            "size", icon_size}},
        "multiple", {
          "icons", {
            { "pos", {  6/2-2, 216/2-2}, "size", icon_size},
            { "pos", { 62/2-2, 216/2-2}, "size", icon_size},
            { "pos", {118/2-2, 216/2-2}, "size", icon_size},
            { "pos", {  6/2-2, 263/2-2}, "size", icon_size},
            { "pos", { 62/2-2, 263/2-2}, "size", icon_size},
            { "pos", {118/2-2, 263/2-2}, "size", icon_size}}}
      },
      "upgrading", {
        "text", {
          "text", ":",
          "font", "game",
          "pos", { info_panel_x + 29/2, info_panel_y + 8/2 + 78/2-8}},
        "icon", {
          "pos", { info_panel_x + 107/2, info_panel_y + 8/2 + 70/2+4},
          "size", icon_size}
      },
      "researching", {
        "text", {
          "text", ":",
          "font", "game",
          "pos", { info_panel_x + 16/2, info_panel_y + 8/2 + 78/2-8}},
        "icon", {
          "pos", { info_panel_x + 107/2, info_panel_y + 8/2 + 70/2+4},
          "size", icon_size}
      },
      "transporting", {
        "icons", {
          { "pos", {  6/2-2, 220/2-2}, "size", icon_size},
          { "pos", { 62/2-2, 220/2-2}, "size", icon_size},
          { "pos", {118/2-2, 220/2-2}, "size", icon_size},
          { "pos", {  6/2-2, 274/2-2}, "size", icon_size},
          { "pos", { 62/2-2, 274/2-2}, "size", icon_size},
          { "pos", {118/2-2, 274/2-2}, "size", icon_size}}
      },
      "completed-bar", {
        "color", {48, 100, 4},
        "pos", { 12/2, 313/2},
        "size", {152/2, 14/2},
        "text", {
          "text", "% ",
          "font", "game",
          "pos", { 50/2-7, 313/2}}
      }
    },

    "button-panel", {
      "panel", {
        "file", "graphics/ui/orc/" ..
          screen_width .. "x" .. screen_height ..
          "/buttonpanel.png",
        "pos", {0, 336/2}},
      "icons", {
        { "pos", {  6/2-2, 337/2-2}, "size", icon_size},
        { "pos", { 62/2-2, 337/2-2}, "size", icon_size},
        { "pos", {118/2-2, 337/2-2}, "size", icon_size},
        { "pos", {  6/2-2, 384/2-2}, "size", icon_size},
        { "pos", { 62/2-2, 384/2-2}, "size", icon_size},
        { "pos", {118/2-2, 384/2-2}, "size", icon_size},
        { "pos", {  6/2-2, 431/2-2}, "size", icon_size},
        { "pos", { 62/2-2, 431/2-2}, "size", icon_size},
        { "pos", {118/2-2, 431/2-2}, "size", icon_size}},
      "command-key-font", "game"
    },

    "map-area", {
      "pos", {176/2, 16/2},
      "size", {
        screen_width - 176/2 - 16/2,
        screen_height - 16/2 - 16/2}},

    "menu-panel", {
      "panel", {
        "file", "graphics/ui/orc/menubutton.png",
        "pos", {0, 0}},
      "menu-button", {
        "pos", {24/2, 2},
        "size", {128/2, 19/2},
        "caption", "~!",
        "font", "game",
        "style", "main"},
      "network-menu-button", {
        "pos", {6/2, 2/2},
        "size", {80/2, 19/2},
        "caption", "~!",
        "font", "game",
        "style", "network"},
      "network-diplomacy-button", {
        "pos", {90/2, 2/2},
        "size", {80/2, 19/2},
        "caption", "~!",
        "font", "game",
        "style", "network"}
    },

    "minimap", {
      "file", "graphics/ui/orc/minimap.png",
      "panel-pos", {0, 24/2},
      "pos", {0 + 24/2, 24/2 + 2/2},
      "size", {64, 64}},

    "status-line", {
      "file", "graphics/ui/orc/" ..
        screen_width .. "x" .. screen_height ..
        "/statusline.png",
      "pos", { 176/2, screen_height - 16/2},
      "text-pos", {2/2 + 176/2, 2/2 + screen_height - 16/2},
      "font", "game"},

    "cursors", {
      "point", "cursor-point",
      "glass", "cursor-glass",
      "cross", "cursor-cross",
      "yellow", "cursor-yellow-hair",
      "green", "cursor-green-hair",
      "red", "cursor-red-hair",
      "scroll", "cursor-scroll",
      "arrow-e", "cursor-arrow-e",
      "arrow-ne", "cursor-arrow-ne",
      "arrow-n", "cursor-arrow-n",
      "arrow-nw", "cursor-arrow-nw",
      "arrow-w", "cursor-arrow-w",
      "arrow-sw", "cursor-arrow-sw",
      "arrow-s", "cursor-arrow-s",
      "arrow-se", "cursor-arrow-se"},

    "menu-panels", {
      "panel1", "graphics/ui/orc/panel_1.png",
      "panel2", "graphics/ui/orc/panel_2.png",
      "panel3", "graphics/ui/orc/panel_3.png",
      "panel4", "graphics/ui/orc/panel_4.png",
      "panel5", "graphics/ui/orc/panel_5.png"},

    "victory-background", "graphics/ui/orc/victory.png",
    "defeat-background", "graphics/ui/orc/defeat.png")
end

OrcScreen(320, 240)
