/*
 * Decompiled with CFR 0.152.
 */
package OTPGen;

import OTPGen.OTPGenException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GeneralSettings {
    private static GeneralSettings instance = null;
    public boolean maskPassphrase = true;
    private static final String RSNAME = "GeneralSettings";
    private static final int SETTINGS_RECORD_ID = 1;

    public static GeneralSettings GetInstance() {
        if (instance == null) {
            instance = GeneralSettings.loadGeneralSettings();
        }
        return instance;
    }

    public static void Save() {
        GeneralSettings.saveGeneralSettings(instance);
    }

    private GeneralSettings() {
    }

    private GeneralSettings(byte[] data) {
        if (data.length == 1) {
            this.maskPassphrase = data[0] == 1;
        }
    }

    private byte[] toByteArray() {
        byte[] data = new byte[]{this.maskPassphrase ? (byte)1 : 0};
        return data;
    }

    private static GeneralSettings loadGeneralSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RSNAME, (boolean)false);
            return new GeneralSettings(rs.getRecord(1));
        }
        catch (RecordStoreException e) {
            return new GeneralSettings();
        }
    }

    private static void saveGeneralSettings(GeneralSettings settings) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RSNAME, (boolean)true);
            byte[] data = settings.toByteArray();
            if (rs.getNumRecords() == 0) {
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(1, data, 0, data.length);
            }
        }
        catch (RecordStoreException e) {
            throw new OTPGenException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a", "\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438  \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a " + e.toString());
        }
    }
}

