/*
 * Decompiled with CFR 0.152.
 */
package OTPGen;

import OTPGen.Account;
import OTPGen.AccountComparator;
import OTPGen.OTPGenException;
import OTPGen.doAfterCommand;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ListAccounts
extends List
implements doAfterCommand {
    public static final int OK = 0;
    public static final int EXIT = -1;
    public static final int EDIT = -2;
    public static final int ADD = -3;
    public static final int DEL = -4;
    public static final int COMPUTE = -5;
    public static final int ABOUT = -6;
    public static final int SETTINGS = -7;
    public static final String RSNAME = "\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438";
    protected CommandListener owner;
    Account[] \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438;
    Command cmExit = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 6);
    Command cmCompute = new Command("\u0412\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c", 8, 0);
    Command cmAdd = new Command("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", 1, 1);
    Command cmEdit = new Command("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 8, 2);
    Command cmDel = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 8, 3);
    Command cmAbout = new Command("\u041e \u043f\u0440\u043e\u0433\u0435", 1, 4);
    Command cmSettings = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 1, 5);

    public ListAccounts(String name, int type, CommandListener l) {
        super(name, type);
        this.owner = l;
        this.addCommand(this.cmAdd);
        this.addCommand(this.cmEdit);
        this.addCommand(this.cmDel);
        this.addCommand(this.cmAbout);
        this.addCommand(this.cmCompute);
        this.addCommand(this.cmSettings);
        this.addCommand(this.cmExit);
        this.setCommandListener(this.owner);
        this.\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 = new Account[0];
        this.rebuildList();
    }

    public void reloadAccounts() {
        try {
            this.\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 = this.loadAccounts();
            this.rebuildList();
        }
        catch (Exception e) {
            throw new OTPGenException("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043e\u0448\u0438\u0431\u043a\u0438", "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438:" + e.toString());
        }
    }

    public int doCommand(Command cm) {
        if (cm == this.cmExit) {
            return -1;
        }
        if (cm == this.cmDel) {
            int i = this.getSelectedIndex();
            if (i >= 0) {
                this.\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438[i].delete(RSNAME);
                this.delete(i);
            }
            return -4;
        }
        if (cm == this.cmEdit) {
            return -2;
        }
        if (cm == this.cmAdd) {
            return -3;
        }
        if (cm == this.cmCompute || cm == List.SELECT_COMMAND) {
            return -5;
        }
        if (cm == this.cmAbout) {
            return -6;
        }
        if (cm == this.cmSettings) {
            return -7;
        }
        return 0;
    }

    public Account getCurrentAccount() {
        if (this.getSelectedIndex() >= 0) {
            return this.\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438[this.getSelectedIndex()];
        }
        return null;
    }

    public void refreshAfterEdit() {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            this.set(index, this.\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438[index].getLabel(), null);
        }
    }

    private Account[] loadAccounts() throws RecordStoreException {
        RecordStore rs = RecordStore.openRecordStore((String)RSNAME, (boolean)true);
        RecordEnumeration renum = rs.enumerateRecords(null, (RecordComparator)new AccountComparator(), false);
        byte[] record = new byte[24];
        ByteArrayInputStream stream = new ByteArrayInputStream(record);
        DataInputStream reader = new DataInputStream(stream);
        Account[] accs = new Account[renum.numRecords()];
        int i = 0;
        int id = 0;
        while (renum.hasNextElement()) {
            id = renum.nextRecordId();
            rs.getRecord(id, record, 0);
            try {
                Account a = new Account(id);
                a.setSeed(reader.readUTF());
                a.setSeq(reader.readInt());
                a.setHash(reader.readInt());
                reader.reset();
                stream.reset();
                accs[i++] = a;
            }
            catch (IOException e) {}
        }
        renum.destroy();
        rs.closeRecordStore();
        return accs;
    }

    private void rebuildList() {
        int i;
        for (i = this.size() - 1; i >= 0; --i) {
            this.delete(i);
        }
        for (i = 0; i < this.\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438.length; ++i) {
            if (this.\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438[i] == null) continue;
            this.append(this.\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438[i].getLabel(), null);
        }
    }
}

