/*
 * Decompiled with CFR 0.152.
 */
package OTPGen;

import OTPGen.Account;
import OTPGen.Computer;
import OTPGen.DisplayPassword;
import OTPGen.EditAccount;
import OTPGen.EnterPassword;
import OTPGen.GeneralSettings;
import OTPGen.GeneralSettingsForm;
import OTPGen.ListAccounts;
import OTPGen.OTPGenException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class OTPGen
extends MIDlet
implements CommandListener {
    Display display;
    ListAccounts lsAccounts;
    EditAccount fmEdit;
    EnterPassword fmEnterPassword;
    Form fmAbout;
    DisplayPassword fmDisplayPassword;
    GeneralSettingsForm fmGeneralSettings;
    Computer computer;
    private GeneralSettings generalSettings = null;

    public void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.mkLsAccounts();
        this.mkFmEdit();
        this.mkFmEnterPassword();
        this.mkComputerAndFmDisplayPassword();
        this.mkFmGeneralSettings();
        try {
            this.lsAccounts.reloadAccounts();
            this.display.setCurrent((Displayable)this.lsAccounts);
        }
        catch (OTPGenException e) {
            this.displayExceptionAlert(e, (Displayable)this.lsAccounts);
        }
    }

    public void pauseApp() {
        this.lsAccounts = null;
        this.fmAbout = null;
        this.fmEdit = null;
        this.fmEnterPassword = null;
        this.fmDisplayPassword = null;
        this.computer = null;
        this.generalSettings = null;
    }

    public void commandAction(Command cm, Displayable d) {
        if (d == this.lsAccounts) {
            int rslt = this.lsAccounts.doCommand(cm);
            if (rslt == -1) {
                this.lsAccounts = null;
                this.destroyApp(false);
                this.notifyDestroyed();
            } else if (rslt == -2) {
                Account acc = this.lsAccounts.getCurrentAccount();
                if (acc != null) {
                    this.fmEdit.setAccount(acc);
                    this.display.setCurrent((Displayable)this.fmEdit);
                }
            } else if (rslt == -3) {
                Account acc = new Account();
                if (acc != null) {
                    this.fmEdit.setAccount(acc);
                    this.display.setCurrent((Displayable)this.fmEdit);
                }
            } else if (rslt == -5) {
                Account acc = this.lsAccounts.getCurrentAccount();
                if (acc != null) {
                    this.fmEnterPassword.setAccount(acc);
                    this.display.setCurrent((Displayable)this.fmEnterPassword);
                }
            } else if (rslt == -6) {
                this.display.setCurrent((Displayable)this.getFmAbout());
            } else if (rslt == -7) {
                this.fmGeneralSettings.initialise();
                this.display.setCurrent((Displayable)this.fmGeneralSettings);
            }
        } else if (d == this.fmEdit) {
            try {
                this.fmEdit.doCommand(cm);
                this.lsAccounts.reloadAccounts();
                this.display.setCurrent((Displayable)this.lsAccounts);
            }
            catch (OTPGenException e) {
                this.displayExceptionAlert(e, (Displayable)this.lsAccounts);
            }
        } else if (d == this.fmEnterPassword) {
            int rslt = this.fmEnterPassword.doCommand(cm);
            if (rslt == 4) {
                Account acc = this.fmEnterPassword.getAccount();
                String pass = this.fmEnterPassword.getPassword();
                this.fmEnterPassword.clear();
                this.computer.initialise(acc, pass);
                this.display.setCurrent((Displayable)this.computer);
                Thread tCompute = new Thread(this.computer);
                tCompute.start();
                pass = null;
            } else if (rslt == 3) {
                this.fmEnterPassword.clear();
                this.display.setCurrent((Displayable)this.lsAccounts);
            }
        } else if (d == this.computer) {
            this.display.setCurrent((Displayable)this.lsAccounts);
        } else if (d == this.fmDisplayPassword) {
            int rslt = this.fmDisplayPassword.doCommand(cm);
            if (rslt == 4) {
                Account account = this.computer.getAccount();
                account.decSeq();
                this.lsAccounts.refreshAfterEdit();
                try {
                    account.save("\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438");
                    this.display.setCurrent((Displayable)this.lsAccounts);
                }
                catch (OTPGenException e) {
                    this.displayExceptionAlert(e, (Displayable)this.lsAccounts);
                }
            } else {
                this.display.setCurrent((Displayable)this.lsAccounts);
            }
        } else if (d == this.fmAbout) {
            this.display.setCurrent((Displayable)this.lsAccounts);
        } else if (d == this.fmGeneralSettings) {
            try {
                if (cm.getCommandType() == 4) {
                    this.fmGeneralSettings.commit();
                    this.fmEnterPassword.notifySettingsChanged();
                    GeneralSettings.Save();
                }
                this.display.setCurrent((Displayable)this.lsAccounts);
            }
            catch (OTPGenException e) {
                this.displayExceptionAlert(e, (Displayable)this.lsAccounts);
            }
        }
    }

    public void destroyApp(boolean unconditional) {
    }

    private void mkLsAccounts() {
        this.lsAccounts = new ListAccounts("OTPGen - \u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f", 3, this);
    }

    private void mkFmEdit() {
        this.fmEdit = new EditAccount("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438", this);
    }

    private void mkFmEnterPassword() {
        this.fmEnterPassword = new EnterPassword(this);
    }

    private void mkComputerAndFmDisplayPassword() {
        this.fmDisplayPassword = new DisplayPassword(this);
        this.computer = new Computer(this.display, this, this.fmDisplayPassword);
    }

    private void mkFmGeneralSettings() {
        this.fmGeneralSettings = new GeneralSettingsForm(this);
    }

    private Form getFmAbout() {
        if (this.fmAbout == null) {
            this.mkFmAbout();
        }
        return this.fmAbout;
    }

    private void mkFmAbout() {
        this.fmAbout = new Form("\u041e \u043f\u0440\u043e\u0433\u0435");
        if (this.fmAbout != null) {
            this.fmAbout.append((Item)new StringItem(null, "One-Time Password Generator v1.1\n\n(c) 2004, 2008 by Marcin Simonides\nhttp://marcin.studio4plus.com/en/otpgen/\r\n(translated to rus by Sany4 SF)"));
            Command cmBack = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 1);
            this.fmAbout.addCommand(cmBack);
            this.fmAbout.setCommandListener((CommandListener)this);
        }
    }

    private void displayExceptionAlert(OTPGenException exception, Displayable nextDisplay) {
        Alert alert = new Alert(exception.getAlertTitle(), exception.getMessage(), null, null);
        alert.setTimeout(-2);
        this.display.setCurrent(alert, nextDisplay);
    }
}

