/*
 * Decompiled with CFR 0.152.
 */
package chordy;

import chordy.Chord;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

class AnimationCanvas
extends Canvas {
    short w;
    short h;
    short l;
    short E;
    short A;
    short D;
    short G;
    short H;
    short e;
    short b1;
    short b2;
    short b3;
    short b4;
    short b5;
    short b;
    short b_nr_x;
    short b_nr_y;
    short textline;
    short bund1;
    short bund2;
    short bund3;
    short bund4;
    short diameter;
    byte var;
    private Chord C;
    private byte[][] dots;
    private byte variances;
    private MIDlet myMidlet;
    public Graphics g;

    public AnimationCanvas(MIDlet Mid, Chord C) {
        this.C = C;
        this.myMidlet = Mid;
        this.var = 0;
        this.variances = C.countVariances();
        this.dots = AnimationCanvas.parseChord(C);
        this.w = (short)this.getWidth();
        this.h = (short)this.getHeight();
        this.l = (short)(this.h / 10);
        this.E = (short)(this.w / 4);
        this.A = (short)(this.E + this.l);
        this.D = (short)(this.A + this.l);
        this.G = (short)(this.D + this.l);
        this.H = (short)(this.G + this.l);
        this.e = (short)(this.H + this.l);
        this.b = (short)(this.w / 5);
        this.b1 = (short)(this.b / 3);
        this.b2 = (short)(this.b1 + this.b);
        this.b3 = (short)(this.b2 + this.b);
        this.b4 = (short)(this.b3 + this.b);
        this.b5 = (short)(this.b4 + this.b);
        this.bund1 = (short)((this.b2 - this.b1 + 5) / 2);
        this.bund2 = (short)(this.bund1 + this.b);
        this.bund3 = (short)(this.bund2 + this.b);
        this.bund4 = (short)(this.bund3 + this.b);
        this.diameter = this.l;
        this.b_nr_x = (short)3;
        this.b_nr_y = (short)(this.E - 1);
        this.textline = (short)(this.h / 10 * 8);
    }

    protected void keyPressed(int keyCode) {
        if (keyCode >= 49 && keyCode <= 57) {
            this.changeVariance((byte)(keyCode - 49));
        } else if (keyCode == 42) {
            this.prevVariance();
        } else if (keyCode == 35) {
            this.nextVariance();
        } else if (keyCode == -3) {
            this.prevVariance();
        } else if (keyCode == -4) {
            this.nextVariance();
        }
    }

    protected void paint(Graphics g) {
        this.g = g;
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, (int)this.w, (int)this.h);
        g.setColor(0, 0, 0);
        g.drawRect(0, this.h / 10, (int)this.w, this.h / 9 * 8);
        g.drawLine((int)this.b1, (int)this.E, this.w - 5, (int)this.E);
        g.drawLine((int)this.b1, (int)this.A, this.w - 5, (int)this.A);
        g.drawLine((int)this.b1, (int)this.D, this.w - 5, (int)this.D);
        g.drawLine((int)this.b1, (int)this.G, this.w - 5, (int)this.G);
        g.drawLine((int)this.b1, (int)this.H, this.w - 5, (int)this.H);
        g.drawLine((int)this.b1, (int)this.e, this.w - 5, (int)this.e);
        g.fillRect((int)this.b1, (int)this.E, 2, this.e - this.E);
        g.fillRect((int)this.b2, (int)this.E, 2, this.e - this.E);
        g.fillRect((int)this.b3, (int)this.E, 2, this.e - this.E);
        g.fillRect((int)this.b4, (int)this.E, 2, this.e - this.E);
        g.fillRect((int)this.b5, (int)this.E, 2, this.e - this.E);
        this.drawVariance(this.var, g);
    }

    public void changeVariance(byte v) {
        if (v >= 0 && v < this.C.countVariances()) {
            this.var = v;
            this.repaint();
        }
    }

    public void nextVariance() {
        if (this.var < this.C.countVariances()) {
            this.var = (byte)(this.var + 1);
            this.repaint();
        }
    }

    public void prevVariance() {
        if (this.var > 0) {
            this.var = (byte)(this.var - 1);
            this.repaint();
        }
    }

    private void drawX(byte string, Graphics g) {
        int y;
        int x = this.bund1 - this.diameter;
        switch (string) {
            case 1: {
                y = this.E - this.diameter / 2;
                break;
            }
            case 2: {
                y = this.A - this.diameter / 2;
                break;
            }
            case 3: {
                y = this.D - this.diameter / 2;
                break;
            }
            case 4: {
                y = this.G - this.diameter / 2;
                break;
            }
            case 5: {
                y = this.H - this.diameter / 2;
                break;
            }
            default: {
                y = this.e - this.diameter / 2;
            }
        }
        g.setColor(255, 0, 0);
        g.drawArc(x + 1, y + 1, this.diameter - 2, this.diameter - 2, 0, 360);
        g.setColor(0, 0, 0);
    }

    private void drawDot(byte string, byte bund, Graphics g) {
        int y;
        short x;
        switch (bund) {
            case 1: {
                x = this.bund1;
                break;
            }
            case 2: {
                x = this.bund2;
                break;
            }
            case 3: {
                x = this.bund3;
                break;
            }
            default: {
                x = this.bund4;
            }
        }
        switch (string) {
            case 1: {
                y = this.E - this.diameter / 2;
                break;
            }
            case 2: {
                y = this.A - this.diameter / 2;
                break;
            }
            case 3: {
                y = this.D - this.diameter / 2;
                break;
            }
            case 4: {
                y = this.G - this.diameter / 2;
                break;
            }
            case 5: {
                y = this.H - this.diameter / 2;
                break;
            }
            default: {
                y = this.e - this.diameter / 2;
            }
        }
        g.fillArc((int)x, y, (int)this.diameter, (int)this.diameter, 0, 360);
    }

    private void drawVariance(byte i, Graphics g) {
        byte shift = 0;
        byte max = 1;
        byte min = 26;
        this.var = i >= this.dots[0].length ? (byte)(this.dots[0].length - 1) : i;
        int j = 0;
        while (j < 6) {
            if (this.dots[j][this.var] > max) {
                max = this.dots[j][this.var];
            }
            if (this.dots[j][this.var] < min && this.dots[j][this.var] > 0) {
                min = this.dots[j][this.var];
            }
            j = (byte)(j + 1);
        }
        if (max > 4) {
            shift = (byte)(min - 1);
        }
        byte[] shifted = new byte[6];
        int j2 = 0;
        while (j2 < 6) {
            shifted[j2] = this.dots[j2][this.var] > 0 ? (int)(this.dots[j2][this.var] - shift) : (this.dots[j2][this.var] < 0 ? -1 : 0);
            ++j2;
        }
        g.drawString(String.valueOf(shift), (int)this.b_nr_x, (int)this.b_nr_y, 68);
        g.drawString(this.C.getName() + " (" + (this.var + 1) + "/" + this.C.countVariances() + ")", this.w / 2, (int)this.textline, 17);
        byte str = 6;
        int j3 = 0;
        while (j3 < 6) {
            if (shifted[j3] > 0) {
                this.drawDot(str, shifted[j3], g);
            } else if (shifted[j3] == -1) {
                this.drawX(str, g);
            }
            str = (byte)(str - 1);
            j3 = (byte)(j3 + 1);
        }
    }

    private static byte[][] parseChord(Chord C) {
        byte[][] result = new byte[6][C.countVariances()];
        String[] var = new String[C.countVariances()];
        String tmp = C.getContent();
        int i = 0;
        while (i < var.length) {
            int a = tmp.indexOf("[") + 1;
            int e = tmp.indexOf("]") + 1;
            var[i] = tmp.substring(a, e - 1) + " ";
            StringBuffer sbtmp = new StringBuffer(tmp);
            sbtmp.delete(a - 1, e);
            tmp = sbtmp.toString();
            int c = 0;
            int j = 0;
            while (j < var[i].length() - 1) {
                sbtmp = sbtmp.delete(0, sbtmp.length());
                if (var[i].charAt(j) != ' ') {
                    sbtmp.append(var[i].charAt(j));
                    if (var[i].charAt(j + 1) != ' ') {
                        sbtmp.append(var[i].charAt(j + 1));
                        j = (byte)(j + 1);
                    }
                    result[c++][i] = sbtmp.charAt(0) == 'x' ? -1 : Byte.parseByte(sbtmp.toString());
                }
                j = (byte)(j + 1);
            }
            i = (byte)(i + 1);
        }
        return result;
    }
}

