/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import java.io.IOException;
import java.io.OutputStream;
import ru.untaba.utils.zip.core.Deflater;
import ru.untaba.utils.zip.utils.io.FilterOutputStream;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected Deflater def;

    protected void deflate() {
        int n;
        while (!this.def.needsInput() && (n = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, n);
        }
        if (!this.def.needsInput()) {
            throw new IOException("Can't deflate all input?");
        }
    }

    public DeflaterOutputStream(OutputStream outputStream) {
        this(outputStream, new Deflater(), 4096);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        this(outputStream, deflater, 4096);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n) {
        super(outputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("bufsize <= 0");
        }
        this.buf = new byte[n];
        this.def = deflater;
    }

    public void flush() {
        this.def.flush();
        this.deflate();
        this.out.flush();
    }

    public void finish() {
        int n;
        this.def.finish();
        while (!this.def.finished() && (n = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, n);
        }
        if (!this.def.finished()) {
            throw new IOException("Can't deflate all input?");
        }
        this.out.flush();
    }

    public void close() {
        this.finish();
        this.out.close();
    }

    public void write(int n) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n;
        this.write(byArray2, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.def.setInput(byArray, n, n2);
        this.deflate();
    }
}

