/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import java.util.Calendar;
import java.util.Date;
import ru.untaba.utils.zip.core.ZipConstants;

public class ZipEntry
implements ZipConstants {
    private final String a;
    private int b;
    private long c = -1L;
    private int d;
    private String e = null;
    private byte f = (byte)-1;
    private byte g = 0;
    private int h;
    private long i;
    private byte[] j = null;
    int flags;
    int offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String string) {
        int n = string.length();
        if (n > 65535) {
            throw new IllegalArgumentException("name length is " + n);
        }
        this.a = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this(zipEntry, zipEntry.a);
    }

    ZipEntry(ZipEntry zipEntry, String string) {
        this.a = string;
        this.g = zipEntry.g;
        this.b = zipEntry.b;
        this.c = zipEntry.c;
        this.d = zipEntry.d;
        this.h = zipEntry.h;
        this.i = zipEntry.i;
        this.f = zipEntry.f;
        this.j = zipEntry.j;
        this.e = zipEntry.e;
    }

    final void setDOSTime(int n) {
        this.h = n;
        this.g = (byte)(this.g | 0x10);
        this.g = (byte)(this.g & 0xFFFFFFF7);
    }

    final int getDOSTime() {
        if ((this.g & 0x10) != 0) {
            return this.h;
        }
        if ((this.g & 8) != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(this.i));
            this.h = (calendar.get(1) - 1980 & 0x7F) << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
            this.g = (byte)(this.g | 0x10);
            return this.h;
        }
        return 0;
    }

    public String getName() {
        return this.a;
    }

    public void setTime(long l) {
        this.i = l;
        this.g = (byte)(this.g | 8);
        this.g = (byte)(this.g & 0xFFFFFFEF);
    }

    public long getTime() {
        int n;
        int n2;
        int n3;
        ZipEntry zipEntry = this;
        if ((zipEntry.g & 0x20) == 0) {
            if (zipEntry.j == null) {
                zipEntry.g = (byte)(zipEntry.g | 0x20);
            } else {
                try {
                    for (n2 = 0; n2 < zipEntry.j.length; n2 += n3) {
                        n = zipEntry.j[n2++] & 0xFF | (zipEntry.j[n2++] & 0xFF) << 8;
                        n3 = zipEntry.j[n2++] & 0xFF | (zipEntry.j[n2++] & 0xFF) << 8;
                        if (n != 21589 || ((n = zipEntry.j[n2]) & 1) == 0) continue;
                        long l = zipEntry.j[n2 + 1] & 0xFF | (zipEntry.j[n2 + 2] & 0xFF) << 8 | (zipEntry.j[n2 + 3] & 0xFF) << 16 | (zipEntry.j[n2 + 4] & 0xFF) << 24;
                        zipEntry.setTime(l * 1000L);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                zipEntry.g = (byte)(zipEntry.g | 0x20);
            }
        }
        if ((this.g & 8) != 0) {
            return this.i;
        }
        if ((this.g & 0x10) != 0) {
            int n4 = 2 * (this.h & 0x1F);
            n2 = this.h >> 5 & 0x3F;
            n = this.h >> 11 & 0x1F;
            n3 = this.h >> 16 & 0x1F;
            int n5 = (this.h >> 21 & 0xF) - 1;
            int n6 = (this.h >> 25 & 0x7F) + 1980;
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, n6);
                calendar.set(2, n5);
                calendar.set(5, n3);
                calendar.set(11, n);
                calendar.set(12, n2);
                calendar.set(13, n4);
                this.i = calendar.getTime().getTime();
                this.g = (byte)(this.g | 8);
                return this.i;
            }
            catch (RuntimeException runtimeException) {
                this.g = (byte)(this.g & 0xFFFFFFF7);
                return -1L;
            }
        }
        return -1L;
    }

    public void setSize(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.b = (int)l;
        this.g = (byte)(this.g | 1);
    }

    public long getSize() {
        if ((this.g & 1) != 0) {
            return (long)this.b & 0xFFFFFFFFL;
        }
        return -1L;
    }

    public void setCompressedSize(long l) {
        this.c = l;
    }

    public long getCompressedSize() {
        return this.c;
    }

    public void setCrc(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.d = (int)l;
        this.g = (byte)(this.g | 4);
    }

    public long getCrc() {
        if ((this.g & 4) != 0) {
            return (long)this.d & 0xFFFFFFFFL;
        }
        return -1L;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException();
        }
        this.f = (byte)n;
    }

    public int getMethod() {
        return this.f;
    }

    public void setExtra(byte[] byArray) {
        if (byArray == null) {
            this.j = null;
            return;
        }
        if (byArray.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.j = byArray;
    }

    public byte[] getExtra() {
        return this.j;
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.e = string;
    }

    public String getComment() {
        return this.e;
    }

    public boolean isDirectory() {
        int n = this.a.length();
        return n > 0 && this.a.charAt(n - 1) == '/';
    }

    public String toString() {
        return this.a;
    }

    public int hashCode() {
        return this.a.hashCode();
    }
}

