/*
 * Decompiled with CFR 0.152.
 */
package org.kalmeo.kuix.core;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import org.kalmeo.kuix.core.style.Style;
import org.kalmeo.kuix.core.style.StyleProperty;
import org.kalmeo.kuix.core.style.StyleSelector;
import org.kalmeo.kuix.layout.BorderLayout;
import org.kalmeo.kuix.layout.BorderLayoutData;
import org.kalmeo.kuix.layout.FlowLayout;
import org.kalmeo.kuix.layout.GridLayout;
import org.kalmeo.kuix.layout.InlineLayout;
import org.kalmeo.kuix.layout.Layout;
import org.kalmeo.kuix.layout.StaticLayout;
import org.kalmeo.kuix.layout.StaticLayoutData;
import org.kalmeo.kuix.layout.TableLayout;
import org.kalmeo.kuix.transition.FadeTransition;
import org.kalmeo.kuix.transition.SlideTransition;
import org.kalmeo.kuix.transition.Transition;
import org.kalmeo.kuix.util.Alignment;
import org.kalmeo.kuix.util.Color;
import org.kalmeo.kuix.util.Gap;
import org.kalmeo.kuix.util.Insets;
import org.kalmeo.kuix.util.Metrics;
import org.kalmeo.kuix.util.Repeat;
import org.kalmeo.kuix.util.Span;
import org.kalmeo.kuix.util.Weight;
import org.kalmeo.kuix.widget.Button;
import org.kalmeo.kuix.widget.CheckBox;
import org.kalmeo.kuix.widget.Choice;
import org.kalmeo.kuix.widget.DragAndDropContainer;
import org.kalmeo.kuix.widget.Gauge;
import org.kalmeo.kuix.widget.List;
import org.kalmeo.kuix.widget.ListItem;
import org.kalmeo.kuix.widget.Menu;
import org.kalmeo.kuix.widget.MenuItem;
import org.kalmeo.kuix.widget.Picture;
import org.kalmeo.kuix.widget.PopupBox;
import org.kalmeo.kuix.widget.RadioButton;
import org.kalmeo.kuix.widget.RadioGroup;
import org.kalmeo.kuix.widget.ScrollBar;
import org.kalmeo.kuix.widget.ScrollPane;
import org.kalmeo.kuix.widget.TabFolder;
import org.kalmeo.kuix.widget.TabItem;
import org.kalmeo.kuix.widget.Text;
import org.kalmeo.kuix.widget.TextArea;
import org.kalmeo.kuix.widget.TextField;
import org.kalmeo.kuix.widget.Widget;
import org.kalmeo.util.BooleanUtil;
import org.kalmeo.util.MathFP;
import org.kalmeo.util.StringTokenizer;
import org.kalmeo.util.StringUtil;
import org.kalmeo.util.resource.ImageManager;

public class KuixConverter {
    public Widget convertWidgetTag(String string) {
        if ("text".equals(string)) {
            return new Text();
        }
        if ("textfield".equals(string)) {
            return new TextField();
        }
        if ("textarea".equals(string)) {
            return new TextArea();
        }
        if ("break".equals(string)) {
            return new Widget("break");
        }
        if ("container".equals(string)) {
            return new Widget("container");
        }
        if ("scrollpane".equals(string)) {
            return new ScrollPane();
        }
        if ("dndcontainer".equals(string)) {
            return new DragAndDropContainer();
        }
        if ("picture".equals(string)) {
            return new Picture();
        }
        if ("button".equals(string)) {
            return new Button();
        }
        if ("hyperlink".equals(string)) {
            return new Button("hyperlink");
        }
        if ("checkbox".equals(string)) {
            return new CheckBox();
        }
        if ("radiobutton".equals(string)) {
            return new RadioButton();
        }
        if ("radiogroup".equals(string)) {
            return new RadioGroup();
        }
        if ("gauge".equals(string)) {
            return new Gauge();
        }
        if ("list".equals(string)) {
            return new List();
        }
        if ("listitem".equals(string)) {
            return new ListItem();
        }
        if ("tabfolder".equals(string)) {
            return new TabFolder();
        }
        if ("tabitem".equals(string)) {
            return new TabItem();
        }
        if ("menu".equals(string)) {
            return new Menu();
        }
        if ("menuitem".equals(string)) {
            return new MenuItem();
        }
        if ("scrollbar".equals(string)) {
            return new ScrollBar();
        }
        if ("choice".equals(string)) {
            return new Choice();
        }
        if ("popupbox".equals(string)) {
            return new PopupBox();
        }
        return null;
    }

    public Style[] convertStyleSheets(String string, String string2) {
        Object object;
        StringTokenizer stringTokenizer;
        Object object2;
        Object object3 = new StringTokenizer(string, ",");
        int n = ((StringTokenizer)object3).countTokens();
        Style[] styleArray = new Style[n];
        for (int i = 0; i < n; ++i) {
            object2 = null;
            stringTokenizer = new StringTokenizer(((StringTokenizer)object3).nextToken(), " \t\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                object = new StyleSelector(stringTokenizer.nextToken().toLowerCase());
                if (object2 != null) {
                    ((StyleSelector)object).parent = object2;
                }
                object2 = object;
            }
            styleArray[i] = new Style((StyleSelector)object2);
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ";");
        while (stringTokenizer2.hasMoreTokens()) {
            object2 = stringTokenizer2.nextToken().trim();
            if (((String)object2).length() <= 2 || (stringTokenizer = new StringTokenizer((String)object2, ":")).countTokens() != 2) continue;
            object = stringTokenizer.nextToken().trim();
            object3 = stringTokenizer.nextToken().trim();
            for (n = 0; n < styleArray.length; ++n) {
                styleArray[n].add(new StyleProperty((String)object, (String)object3));
            }
        }
        return styleArray;
    }

    public Object convertStyleProperty(String string, String string2) {
        if ("color".equals(string) || "bg-color".equals(string) || "grayed-color".equals(string)) {
            return this.convertColor(string2);
        }
        if ("border-color".equals(string)) {
            return this.convertBorderColor(string2);
        }
        if ("font-face".equals(string)) {
            return this.convertFontFace(string2);
        }
        if ("font-style".equals(string)) {
            return this.convertFontStyle(string2);
        }
        if ("font-size".equals(string)) {
            return this.convertFontSize(string2);
        }
        if ("border-stroke".equals(string)) {
            return this.convertStroke(string2);
        }
        if ("margin".equals(string) || "border".equals(string) || "padding".equals(string)) {
            return this.convertInset(string2);
        }
        if ("min-size".equals(string)) {
            return this.convertMetrics(string2);
        }
        if ("gap".equals(string)) {
            return this.convertGap(string2);
        }
        if ("span".equals(string)) {
            return this.convertSpan(string2);
        }
        if ("weight".equals(string)) {
            return this.convertWeight(string2);
        }
        if ("align".equals(string)) {
            return this.convertAlignment(string2);
        }
        if ("bg-align".equals(string)) {
            return this.convertAlignmentArray(string2, 1, "|");
        }
        if ("border-align".equals(string)) {
            return this.convertAlignmentArray(string2, 8, " \t\n\r\f");
        }
        if ("bg-image".equals(string)) {
            return this.convertImageArray(string2, 1, "|");
        }
        if ("border-image".equals(string)) {
            return this.convertBorderImage(string2);
        }
        if ("layout".equals(string)) {
            return this.convertLayout(string2);
        }
        if ("layout-data".equals(string)) {
            return this.convertLayoutData(string2);
        }
        if ("bg-repeat".equals(string)) {
            return this.convertRepeatArray(string2, 1, "|");
        }
        if ("transition".equals(string)) {
            return this.convertTransition(string2);
        }
        throw new IllegalArgumentException("Unknow style name " + string);
    }

    public Transition convertTransition(String string) {
        if (((KuixConverter)((Object)alignment)).isNone(string)) {
            return null;
        }
        String string2 = null;
        string2 = StringUtil.extractRawParams("slide", string);
        if (string2 != null) {
            Alignment alignment = ((KuixConverter)((Object)alignment)).convertAlignment(string2);
            return new SlideTransition(alignment);
        }
        string2 = StringUtil.extractRawParams("fade", string);
        if (string2 != null) {
            return new FadeTransition(Integer.parseInt(string2));
        }
        throw new IllegalArgumentException("Bad transition value");
    }

    protected Color convertColor(String string) {
        if (this.isNone(string)) {
            return null;
        }
        if (string != null) {
            if ((string = string.trim()).startsWith("#")) {
                return new Color(string);
            }
            if ("red".equals(string)) {
                return Color.RED;
            }
            if ("green".equals(string)) {
                return Color.GREEN;
            }
            if ("blue".equals(string)) {
                return Color.BLUE;
            }
            if ("white".equals(string)) {
                return Color.WHITE;
            }
            if ("black".equals(string)) {
                return Color.BLACK;
            }
        }
        throw new IllegalArgumentException("Bad color value");
    }

    protected Integer convertFontFace(String string) {
        int n = 0;
        if ("monospace".equals(string)) {
            n = 32;
        } else if ("proportional".equals(string)) {
            n = 64;
        }
        return new Integer(n);
    }

    protected Integer convertFontStyle(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if ("bold".equals(string2)) {
                n |= 1;
                continue;
            }
            if ("italic".equals(string2)) {
                n |= 2;
                continue;
            }
            if (!"underlined".equals(string2)) continue;
            n |= 4;
        }
        return new Integer(n);
    }

    protected Integer convertFontSize(String string) {
        int n;
        if ("large".equals(string)) {
            n = 16;
        } else if ("small".equals(string)) {
            n = 8;
        } else if ("medium".equals(string)) {
            n = 0;
        } else {
            throw new IllegalArgumentException("Invalid font-size value : " + string);
        }
        return new Integer(n);
    }

    protected Integer convertStroke(String string) {
        int n;
        if ("dotted".equals(string)) {
            n = 1;
        } else if ("solid".equals(string)) {
            n = 0;
        } else {
            throw new IllegalArgumentException("Invalid stroke value : " + string);
        }
        return new Integer(n);
    }

    protected Insets convertInset(String string) {
        if (((KuixConverter)object).isNone(string)) {
            return null;
        }
        int[] nArray = ((KuixConverter)object).convertIntArray(string, 1, " \t\n\r\f");
        Object object = nArray;
        if (nArray != null) {
            if (((Object)object).length == 1) {
                return new Insets((int)object[0], (int)object[0], (int)object[0], (int)object[0]);
            }
            if (((Object)object).length >= 4) {
                return new Insets((int)object[0], (int)object[1], (int)object[2], (int)object[3]);
            }
        }
        throw new IllegalArgumentException("Bad inset value");
    }

    protected Metrics convertMetrics(String string) {
        if (((KuixConverter)object).isNone(string)) {
            return null;
        }
        int[] nArray = ((KuixConverter)object).convertIntArray(string, 2, " \t\n\r\f");
        Object object = nArray;
        if (nArray != null) {
            if (((Object)object).length == 2) {
                return new Metrics(null, 0, 0, (int)object[0], (int)object[1]);
            }
            if (((Object)object).length >= 4) {
                return new Metrics(null, (int)object[0], (int)object[1], (int)object[2], (int)object[3]);
            }
        }
        throw new IllegalArgumentException("Bad metrics value");
    }

    protected Gap convertGap(String string) {
        if (((KuixConverter)object).isNone(string)) {
            return null;
        }
        int[] nArray = ((KuixConverter)object).convertIntArray(string, 1, " \t\n\r\f");
        Object object = nArray;
        if (nArray != null) {
            if (((Object)object).length == 1) {
                return new Gap((int)object[0], (int)object[0]);
            }
            if (((Object)object).length >= 1) {
                return new Gap((int)object[0], (int)object[1]);
            }
        }
        throw new IllegalArgumentException("Bad gap value");
    }

    protected Repeat convertRepeat(String string) {
        if (((KuixConverter)object).isNone(string)) {
            return null;
        }
        int[] nArray = ((KuixConverter)object).convertIntArray(string.trim(), 1, " \t\n\r\f");
        Object object = nArray;
        if (nArray != null) {
            if (((Object)object).length == 1) {
                return new Repeat((int)object[0], (int)object[0]);
            }
            if (((Object)object).length >= 2) {
                return new Repeat((int)object[0], (int)object[1]);
            }
        }
        throw new IllegalArgumentException("Bad repeat value");
    }

    protected Repeat[] convertRepeatArray(String object, int n, String string) {
        if (this.isNone((String)object)) {
            return null;
        }
        if (((StringTokenizer)(object = new StringTokenizer((String)object, string))).countTokens() >= n) {
            Repeat[] repeatArray = new Repeat[((StringTokenizer)object).countTokens()];
            int n2 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    repeatArray[n2] = this.convertRepeat(((StringTokenizer)object).nextToken());
                }
                catch (Exception exception) {
                    return null;
                }
                ++n2;
            }
            return repeatArray;
        }
        throw new IllegalArgumentException("Bad repeats value");
    }

    protected Span convertSpan(String string) {
        if (((KuixConverter)object).isNone(string)) {
            return null;
        }
        int[] nArray = ((KuixConverter)object).convertIntArray(string, 2, " \t\n\r\f");
        Object object = nArray;
        if (nArray != null) {
            return new Span((int)object[0], (int)object[1]);
        }
        throw new IllegalArgumentException("Bad span value");
    }

    protected Weight convertWeight(String string) {
        if (((KuixConverter)object).isNone(string)) {
            return null;
        }
        int[] nArray = ((KuixConverter)object).convertFPArray(string, 2, " \t\n\r\f");
        Object object = nArray;
        if (nArray != null) {
            return new Weight((int)object[0], (int)object[1]);
        }
        throw new IllegalArgumentException("Bad weight value");
    }

    protected Alignment convertAlignment(String string) {
        if (((KuixConverter)((Object)stringTokenizer)).isNone(string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim());
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken().toLowerCase();
            if ("top-left".equals(string)) {
                return Alignment.TOP_LEFT;
            }
            if ("top".equals(string)) {
                return Alignment.TOP;
            }
            if ("top-right".equals(string)) {
                return Alignment.TOP_RIGHT;
            }
            if ("left".equals(string)) {
                return Alignment.LEFT;
            }
            if ("center".equals(string)) {
                return Alignment.CENTER;
            }
            if ("right".equals(string)) {
                return Alignment.RIGHT;
            }
            if ("bottom-left".equals(string)) {
                return Alignment.BOTTOM_LEFT;
            }
            if ("bottom".equals(string)) {
                return Alignment.BOTTOM;
            }
            if ("bottom-right".equals(string)) {
                return Alignment.BOTTOM_RIGHT;
            }
            if ("fill".equals(string)) {
                return Alignment.FILL;
            }
            if ("fill-top".equals(string)) {
                return Alignment.FILL_TOP;
            }
            if ("fill-left".equals(string)) {
                return Alignment.FILL_LEFT;
            }
            if ("fill-center".equals(string)) {
                return Alignment.FILL_CENTER;
            }
            if ("fill-right".equals(string)) {
                return Alignment.FILL_RIGHT;
            }
            if (!"fill-bottom".equals(string)) continue;
            return Alignment.FILL_BOTTOM;
        }
        throw new IllegalArgumentException("Bad alignment value");
    }

    protected Alignment[] convertAlignmentArray(String object, int n, String string) {
        if (this.isNone((String)object)) {
            return null;
        }
        if (((StringTokenizer)(object = new StringTokenizer((String)object, string))).countTokens() >= n) {
            Alignment[] alignmentArray = new Alignment[((StringTokenizer)object).countTokens()];
            int n2 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    alignmentArray[n2] = this.convertAlignment(((StringTokenizer)object).nextToken());
                }
                catch (Exception exception) {
                    return null;
                }
                ++n2;
            }
            return alignmentArray;
        }
        throw new IllegalArgumentException("Bad alignments value");
    }

    protected Image convertImage(String string) {
        if (this.isNone(string)) {
            return null;
        }
        String string2 = null;
        string2 = StringUtil.extractRawParams("url", string.trim());
        if (string2 != null && (this = this.convertImageDefinition(string2)) != null) {
            return this;
        }
        throw new IllegalArgumentException("Bad image value : " + "");
    }

    public Image convertImageDefinition(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ","))).countTokens();
        if (n >= 1) {
            Image image = null;
            String string = ((StringTokenizer)object).nextToken();
            if (!string.startsWith("/")) {
                string = "/img/" + string;
            }
            if ((image = ImageManager.instance.getImage(string)) != null) {
                if (n >= 5) {
                    int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    int n5 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    int n6 = 0;
                    if (n == 6) {
                        n6 = this.convertTransform(((StringTokenizer)object).nextToken());
                    }
                    try {
                        return Image.createImage((Image)image, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
                    }
                    catch (Exception exception) {
                        System.err.println("Error loading custom : " + string);
                    }
                } else {
                    return image;
                }
            }
        }
        return null;
    }

    protected Image[] convertImageArray(String object, int n, String string) {
        if (this.isNone((String)object)) {
            return null;
        }
        if (((StringTokenizer)(object = new StringTokenizer((String)object, string))).countTokens() >= n) {
            Image[] imageArray = new Image[((StringTokenizer)object).countTokens()];
            int n2 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    imageArray[n2] = this.convertImage(((StringTokenizer)object).nextToken());
                }
                catch (Exception exception) {
                    return null;
                }
                ++n2;
            }
            return imageArray;
        }
        throw new IllegalArgumentException("Bad images value");
    }

    protected Color[] convertBorderColor(String object) {
        if (((KuixConverter)((Object)color)).isNone((String)object)) {
            return null;
        }
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object))).countTokens();
        if (n == 1) {
            Color color = ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken());
            return new Color[]{color, color, color, color};
        }
        if (n >= 4 && n < 8) {
            return new Color[]{((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken())};
        }
        if (n == 8) {
            return new Color[]{((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken()), ((KuixConverter)((Object)color)).convertColor(((StringTokenizer)object).nextToken())};
        }
        throw new IllegalArgumentException("Bad border-color value");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Image[] convertBorderImage(String string) {
        if (this.isNone(string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            Image[] imageArray = new Image[8];
            if ((string = this.convertImage(string)) == null) return imageArray;
            for (int i = 0; i < 8; ++i) {
                imageArray[i] = string;
            }
            return imageArray;
        }
        if (n == 5) {
            Image[] imageArray = new Image[8];
            string = this.convertImage(stringTokenizer.nextToken());
            if (string == null) throw new IllegalArgumentException("Bad image value");
            try {
                int n2 = string.getWidth();
                int n3 = string.getHeight();
                int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
                int n5 = Integer.parseInt(stringTokenizer.nextToken().trim());
                int n6 = Integer.parseInt(stringTokenizer.nextToken().trim());
                int n7 = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (n4 != 0) {
                    imageArray[0] = Image.createImage((Image)string, (int)n7, (int)0, (int)(n2 - n7 - n5), (int)n4, (int)0);
                    if (n5 != 0) {
                        imageArray[1] = Image.createImage((Image)string, (int)(n2 - n5), (int)0, (int)n5, (int)n4, (int)0);
                    }
                }
                if (n5 != 0) {
                    imageArray[2] = Image.createImage((Image)string, (int)(n2 - n5), (int)n4, (int)n5, (int)(n3 - n4 - n6), (int)0);
                    if (n6 != 0) {
                        imageArray[3] = Image.createImage((Image)string, (int)(n2 - n5), (int)(n3 - n6), (int)n5, (int)n6, (int)0);
                    }
                }
                if (n6 != 0) {
                    imageArray[4] = Image.createImage((Image)string, (int)n7, (int)(n3 - n6), (int)(n2 - n7 - n5), (int)n6, (int)0);
                    if (n7 != 0) {
                        imageArray[5] = Image.createImage((Image)string, (int)0, (int)(n3 - n6), (int)n7, (int)n6, (int)0);
                    }
                }
                if (n7 == 0) return imageArray;
                imageArray[6] = Image.createImage((Image)string, (int)0, (int)n4, (int)n7, (int)(n3 - n4 - n6), (int)0);
                if (n4 == 0) return imageArray;
                imageArray[7] = Image.createImage((Image)string, (int)0, (int)0, (int)n7, (int)n4, (int)0);
                return imageArray;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Bad top, right, bottom or left value");
            }
        }
        if (n != 8) throw new IllegalArgumentException("Bad border-image value");
        Image[] imageArray = new Image[8];
        int n8 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                imageArray[n8] = this.convertImage(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                return null;
            }
            ++n8;
        }
        return imageArray;
    }

    protected Layout convertLayout(String object) {
        if (((KuixConverter)this).isNone((String)object)) {
            return null;
        }
        String string = null;
        string = StringUtil.extractRawParams("inlinelayout", (String)object);
        if (string != null) {
            object = new StringTokenizer(string, ",");
            if (((StringTokenizer)object).countTokens() >= 2) {
                boolean bl = BooleanUtil.parseBoolean(((StringTokenizer)object).nextToken());
                if ((this = ((KuixConverter)this).convertAlignment(((StringTokenizer)object).nextToken())) != null) {
                    return new InlineLayout(bl, (Alignment)this);
                }
                return new InlineLayout(bl);
            }
            return new InlineLayout();
        }
        string = StringUtil.extractRawParams("flowlayout", (String)object);
        if (string != null) {
            object = ((KuixConverter)this).convertAlignment(string);
            if (object != null) {
                return new FlowLayout((Alignment)object);
            }
            return new FlowLayout();
        }
        if (((String)object).startsWith("tablelayout")) {
            return TableLayout.instance;
        }
        if (((String)object).startsWith("borderlayout")) {
            return BorderLayout.instance;
        }
        string = StringUtil.extractRawParams("gridlayout", (String)object);
        if (string != null) {
            object = new StringTokenizer(string, ",");
            if (((StringTokenizer)object).countTokens() >= 2) {
                int n = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
                int n2 = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
                return new GridLayout(n, n2);
            }
        } else if (((String)object).startsWith("staticlayout")) {
            return StaticLayout.instance;
        }
        throw new IllegalArgumentException("Bad layout value");
    }

    protected Object convertLayoutData(String string) {
        if (((KuixConverter)object).isNone(string)) {
            return null;
        }
        String string2 = null;
        string2 = StringUtil.extractRawParams("bld", string);
        if (string2 != null) {
            if ("north".equals(string2)) {
                return BorderLayoutData.instanceNorth;
            }
            if ("west".equals(string2)) {
                return BorderLayoutData.instanceWest;
            }
            if ("east".equals(string2)) {
                return BorderLayoutData.instanceEast;
            }
            if ("south".equals(string2)) {
                return BorderLayoutData.instanceSouth;
            }
            if ("center".equals(string2)) {
                return BorderLayoutData.instanceCenter;
            }
            throw new IllegalArgumentException("Invalid bld value : " + string2);
        }
        string2 = StringUtil.extractRawParams("sld", string);
        if (string2 != null) {
            int n = string2.indexOf(",");
            if (n != -1) {
                try {
                    Alignment alignment = ((KuixConverter)object).convertAlignment(string2.substring(0, n));
                    int[] nArray = ((KuixConverter)object).convertFPArray(string2.substring(n + 1), 2, ",");
                    Object object = nArray;
                    if (nArray != null) {
                        return new StaticLayoutData(alignment, (int)object[0], (int)object[1]);
                    }
                }
                catch (Exception exception) {}
            } else {
                Alignment alignment = ((KuixConverter)object).convertAlignment(string2);
                return new StaticLayoutData(alignment);
            }
            throw new IllegalArgumentException("Invalid sld value : " + string2);
        }
        throw new IllegalArgumentException("Bad layout data value");
    }

    public int convertTransform(String string) {
        if (string != null) {
            if (string.equals("mirror")) {
                return 2;
            }
            if (string.equals("mirror_rot270")) {
                return 4;
            }
            if (string.equals("mirror_rot180")) {
                return 1;
            }
            if (string.equals("mirror_rot90")) {
                return 7;
            }
            if (string.equals("rot270")) {
                return 6;
            }
            if (string.equals("rot180")) {
                return 3;
            }
            if (string.equals("rot90")) {
                return 5;
            }
        }
        return 0;
    }

    public String[] convertStyleClasses(String stringArray) {
        if (((KuixConverter)((Object)stringTokenizer)).isNone((String)stringArray)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)stringArray);
        if (stringTokenizer.hasMoreTokens()) {
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken().toLowerCase();
            }
            return stringArray;
        }
        throw new IllegalArgumentException("Bad class value");
    }

    public int convertKuixKeyCode(String string) {
        String string2 = string.trim();
        int n = 0x40000000;
        if ("0".equals(string2)) {
            n = 524288;
        } else if ("1".equals(string2)) {
            n = 1024;
        } else if ("2".equals(string2)) {
            n = 2048;
        } else if ("3".equals(string2)) {
            n = 4096;
        } else if ("4".equals(string2)) {
            n = 8192;
        } else if ("5".equals(string2)) {
            n = 16384;
        } else if ("6".equals(string2)) {
            n = 32768;
        } else if ("7".equals(string2)) {
            n = 65536;
        } else if ("8".equals(string2)) {
            n = 131072;
        } else if ("9".equals(string2)) {
            n = 262144;
        } else if ("*".equals(string2)) {
            n = 0x200000;
        } else if ("#".equals(string2)) {
            n = 0x100000;
        } else if ("softleft".equals(string2)) {
            n = 32;
        } else if ("softright".equals(string2)) {
            n = 64;
        } else if ("up".equals(string2)) {
            n = 1;
        } else if ("left".equals(string2)) {
            n = 4;
        } else if ("right".equals(string2)) {
            n = 8;
        } else if ("down".equals(string2)) {
            n = 2;
        } else if ("fire".equals(string2)) {
            n = 16;
        } else if ("delete".equals(string2)) {
            n = 128;
        } else if ("back".equals(string2)) {
            n = 256;
        } else if ("pencil".equals(string2)) {
            n = 512;
        }
        return n;
    }

    public byte[] convertShortcuts(String object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = 0;
        object = new StringTokenizer((String)object, "|");
        String string = null;
        while (((StringTokenizer)object).hasMoreTokens()) {
            int n2;
            string = ((StringTokenizer)object).nextToken().trim();
            String string2 = null;
            int n3 = string.indexOf(61);
            if (n3 != -1) {
                string2 = string.substring(n3 + 1);
                string = string.substring(0, n3);
            }
            if ((n2 = this.convertKuixKeyCode(string)) == 0x40000000) continue;
            n |= n2;
            if (string2 == null) continue;
            try {
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(string2);
            }
            catch (IOException iOException) {}
        }
        if (n != 0) {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            try {
                dataOutputStream.writeInt(n);
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public int[] convertIntArray(String object, int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, string);
        if (stringTokenizer.countTokens() >= n) {
            object = new int[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    object[n] = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    return null;
                }
                ++n;
            }
            return object;
        }
        return null;
    }

    public int[] convertFPArray(String object, int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, string);
        if (stringTokenizer.countTokens() >= n) {
            object = new int[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    object[n] = MathFP.toFP(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    return null;
                }
                ++n;
            }
            return object;
        }
        return null;
    }

    protected boolean isNone(String string) {
        return "none".equals(string);
    }
}

