/*
 * Decompiled with CFR 0.152.
 */
package org.kalmeo.kuix.util;

public class Alignment {
    public static final Alignment TOP_LEFT = new Alignment(3);
    public static final Alignment TOP = new Alignment(1);
    public static final Alignment TOP_RIGHT = new Alignment(5);
    public static final Alignment LEFT = new Alignment(2);
    public static final Alignment CENTER = new Alignment(16);
    public static final Alignment RIGHT = new Alignment(4);
    public static final Alignment BOTTOM_LEFT = new Alignment(10);
    public static final Alignment BOTTOM = new Alignment(8);
    public static final Alignment BOTTOM_RIGHT = new Alignment(12);
    public static final Alignment FILL = new Alignment(32);
    public static final Alignment FILL_TOP = new Alignment(33);
    public static final Alignment FILL_LEFT = new Alignment(34);
    public static final Alignment FILL_CENTER = new Alignment(48);
    public static final Alignment FILL_RIGHT = new Alignment(36);
    public static final Alignment FILL_BOTTOM = new Alignment(40);
    public byte value;

    private Alignment(byte by) {
        this.value = by;
    }

    public boolean isTop() {
        return (this.value & 1) == 1;
    }

    public boolean isBottom() {
        return (this.value & 8) == 8;
    }

    public boolean isLeft() {
        return (this.value & 2) == 2;
    }

    public boolean isRight() {
        return (this.value & 4) == 4;
    }

    public boolean isHorizontalCenter() {
        return (this.value & 0x10) == 16 || (this.isTop() || this.isBottom()) && !this.isLeft() && !this.isRight();
    }

    public boolean isVerticalCenter() {
        return (this.value & 0x10) == 16 || (this.isLeft() || this.isRight()) && !this.isTop() && !this.isBottom();
    }

    public boolean isFill() {
        return (this.value & 0x20) == 32;
    }

    public int alignX(int n, int n2) {
        if (this.isHorizontalCenter()) {
            return (n - n2) / 2;
        }
        if (this.isRight()) {
            return n - n2;
        }
        return 0;
    }

    public int alignY(int n, int n2) {
        if (this.isVerticalCenter()) {
            return (n - n2) / 2;
        }
        if (this.isBottom()) {
            return n - n2;
        }
        return 0;
    }

    public static Alignment combine(Alignment alignment, Alignment alignment2) {
        if (alignment != null && alignment2 != null) {
            byte by = (byte)((alignment.isTop() ? 1 : 0) | (alignment.isVerticalCenter() ? 16 : 0) | (alignment.isBottom() ? 8 : 0) | ((alignment2.isLeft() ? 2 : 0) | (alignment2.isHorizontalCenter() ? 16 : 0) | (alignment2.isRight() ? 4 : 0)));
            return new Alignment(by);
        }
        return null;
    }
}

