/*
 * Decompiled with CFR 0.152.
 */
package org.kalmeo.kuix.widget;

import org.kalmeo.kuix.core.Kuix;
import org.kalmeo.kuix.core.focus.FocusManager;
import org.kalmeo.kuix.widget.ScrollPane;
import org.kalmeo.kuix.widget.Widget;
import org.kalmeo.util.BooleanUtil;

public class FocusableWidget
extends Widget {
    public static final String HOVER_PSEUDO_CLASS = "hover";
    public static final String DISABLED_PSEUDO_CLASS = "disabled";
    protected static final String[] PSEUDO_CLASSES = new String[]{"hover", "disabled"};
    protected boolean focusable = true;
    protected boolean focused = false;
    private String a;
    private String b;
    protected boolean enabled = true;
    private boolean c = false;

    public FocusableWidget() {
    }

    public FocusableWidget(String string) {
        super(string);
    }

    public boolean setAttribute(String string, String string2) {
        if ("onfocus".equals(string)) {
            this.setOnFocus(string2);
            return true;
        }
        if ("onlostfocus".equals(string)) {
            this.setOnLostFocus(string2);
            return true;
        }
        if ("enabled".equals(string)) {
            this.setEnabled(BooleanUtil.parseBoolean(string2));
            return true;
        }
        if ("focusable".equals(string)) {
            this.setFocusable(BooleanUtil.parseBoolean(string2));
            return true;
        }
        if ("focused".equals(string)) {
            if (BooleanUtil.parseBoolean(string2)) {
                this.requestFocus();
            }
            return true;
        }
        return super.setAttribute(string, string2);
    }

    public Object getAttribute(String string) {
        if ("focused".equals(string)) {
            return BooleanUtil.toString(this.isFocused());
        }
        return super.getAttribute(string);
    }

    public void setFocusable(boolean bl) {
        this.focusable = bl;
        if (!bl) {
            this.giveFocusToNearestWidget();
        }
    }

    public boolean isFocusable() {
        return this.enabled && this.focusable;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.invalidateStylePropertiesCache(true);
        if (!bl) {
            this.giveFocusToNearestWidget();
        }
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.giveFocusToNearestWidget();
        }
        super.setVisible(bl);
    }

    public String getOnFocus() {
        return this.a;
    }

    public void setOnFocus(String string) {
        this.a = string;
    }

    public String getOnLostFocus() {
        return this.b;
    }

    public void setOnLostFocus(String string) {
        this.b = string;
    }

    public String[] getAvailablePseudoClasses() {
        return PSEUDO_CLASSES;
    }

    public boolean isPseudoClassCompatible(String string) {
        if (HOVER_PSEUDO_CLASS.equals(string)) {
            return this.isFocused();
        }
        if (DISABLED_PSEUDO_CLASS.equals(string)) {
            return !this.isEnabled();
        }
        return false;
    }

    public void giveFocusToNearestWidget() {
        FocusManager focusManager;
        if (this.isFocused() && (focusManager = this.getFocusManager()) != null) {
            focusManager.requestOtherFocus(true, null);
            if (focusManager.getFocusedWidget() == this) {
                focusManager.requestOtherFocus(false, null);
                if (focusManager.getFocusedWidget() == this) {
                    focusManager.requestFocus(null);
                }
            }
        }
    }

    public void remove() {
        this.giveFocusToNearestWidget();
        super.remove();
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            FocusManager focusManager = this.getFocusManager();
            if (focusManager != null) {
                ScrollPane scrollPane = focusManager.findFirstScrollPaneParent(this);
                if (scrollPane != null) {
                    scrollPane.bestScrollToChild(this, false);
                }
                focusManager.requestFocus(this);
                return;
            }
            this.c = true;
        }
    }

    public boolean processFocusEvent(byte by) {
        switch (by) {
            case 30: {
                this.focused = true;
                this.invalidateStylePropertiesCache(true);
                if (this.a != null) {
                    Kuix.callActionMethod(Kuix.parseMethod(this.a, this));
                }
                this.propagateFocusEvent(this, false);
                this.doLayout();
                return true;
            }
            case 31: {
                this.focused = false;
                this.invalidateStylePropertiesCache(true);
                if (this.b != null) {
                    Kuix.callActionMethod(Kuix.parseMethod(this.b, this));
                }
                this.propagateFocusEvent(this, true);
                this.doLayout();
                return true;
            }
        }
        return super.processFocusEvent(by);
    }

    public boolean processPointerEvent(byte by, int n, int n2) {
        if (this.isFocusable() && by == 21) {
            this.requestFocus();
            return true;
        }
        return super.processPointerEvent(by, n, n2);
    }

    protected void onAdded(Widget widget) {
        if (this.c) {
            this.requestFocus();
            this.c = false;
        }
    }
}

