/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import ru.untaba.utils.zip.core.Adler32;
import ru.untaba.utils.zip.core.DataFormatException;
import ru.untaba.utils.zip.core.InflaterDynHeader;
import ru.untaba.utils.zip.core.InflaterHuffmanTree;
import ru.untaba.utils.zip.core.OutputWindow;
import ru.untaba.utils.zip.core.StreamManipulator;

public class Inflater {
    private static final int[] a = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
    private static final int[] b = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
    private static final int[] c = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final int[] d = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private boolean k;
    private long l;
    private long m;
    private boolean n;
    private StreamManipulator o;
    private OutputWindow p;
    private InflaterDynHeader q;
    private InflaterHuffmanTree r;
    private InflaterHuffmanTree s;
    private Adler32 t;

    public Inflater() {
        this(false);
    }

    public Inflater(boolean bl) {
        this.n = bl;
        this.t = new Adler32();
        this.o = new StreamManipulator();
        this.p = new OutputWindow();
        this.e = bl ? 2 : 0;
    }

    public void end() {
        this.p = null;
        this.o = null;
        this.q = null;
        this.r = null;
        this.s = null;
        this.t = null;
    }

    public boolean finished() {
        return this.e == 12 && this.p.getAvailable() == 0;
    }

    public int getAdler() {
        if (this.needsDictionary()) {
            return this.f;
        }
        return (int)this.t.getValue();
    }

    public int getRemaining() {
        return this.o.getAvailableBytes();
    }

    public int getTotalIn() {
        return (int)(this.m - (long)this.getRemaining());
    }

    public long getBytesRead() {
        return this.m - (long)this.getRemaining();
    }

    public int getTotalOut() {
        return (int)this.l;
    }

    public long getBytesWritten() {
        return this.l;
    }

    public int inflate(byte[] byArray) {
        return this.inflate(byArray, 0, byArray.length);
    }

    public int inflate(byte[] byArray, int n, int n2) {
        boolean bl;
        if (n2 == 0) {
            return 0;
        }
        if (0 > n || n > n + n2 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 0;
        do {
            if (this.e != 11) {
                int n4 = this.p.copyOutput(byArray, n, n2);
                this.t.update(byArray, n, n4);
                n += n4;
                n3 += n4;
                this.l += (long)n4;
                if ((n2 -= n4) == 0) {
                    return n3;
                }
            }
            Inflater inflater = this;
            switch (inflater.e) {
                case 0: {
                    int n5 = inflater.o.peekBits(16);
                    if (n5 < 0) {
                        bl = false;
                        break;
                    }
                    inflater.o.dropBits(16);
                    n5 = (n5 << 8 | n5 >> 8) & 0xFFFF;
                    if (n5 % 31 != 0) {
                        throw new DataFormatException("Header checksum illegal");
                    }
                    if ((n5 & 0xF00) != 2048) {
                        throw new DataFormatException("Compression Method unknown");
                    }
                    if ((n5 & 0x20) == 0) {
                        inflater.e = 2;
                    } else {
                        inflater.e = 1;
                        inflater.g = 32;
                    }
                    bl = true;
                    break;
                }
                case 1: {
                    bl = inflater.a();
                    break;
                }
                case 11: {
                    bl = inflater.c();
                    break;
                }
                case 2: {
                    if (inflater.k) {
                        if (inflater.n) {
                            inflater.e = 12;
                            bl = false;
                            break;
                        }
                        inflater.o.skipToByteBoundary();
                        inflater.g = 32;
                        inflater.e = 11;
                        bl = true;
                        break;
                    }
                    int n5 = inflater.o.peekBits(3);
                    if (n5 < 0) {
                        bl = false;
                        break;
                    }
                    inflater.o.dropBits(3);
                    if ((n5 & 1) != 0) {
                        inflater.k = true;
                    }
                    switch (n5 >> 1) {
                        case 0: {
                            inflater.o.skipToByteBoundary();
                            inflater.e = 3;
                            break;
                        }
                        case 1: {
                            inflater.r = InflaterHuffmanTree.defLitLenTree;
                            inflater.s = InflaterHuffmanTree.defDistTree;
                            inflater.e = 7;
                            break;
                        }
                        case 2: {
                            inflater.q = new InflaterDynHeader();
                            inflater.e = 6;
                            break;
                        }
                        default: {
                            throw new DataFormatException("Unknown block type " + n5);
                        }
                    }
                    bl = true;
                    break;
                }
                case 3: {
                    inflater.j = inflater.o.peekBits(16);
                    if (inflater.j < 0) {
                        bl = false;
                        break;
                    }
                    inflater.o.dropBits(16);
                    inflater.e = 4;
                }
                case 4: {
                    int n5 = inflater.o.peekBits(16);
                    if (n5 < 0) {
                        bl = false;
                        break;
                    }
                    inflater.o.dropBits(16);
                    if (n5 != (inflater.j ^ 0xFFFF)) {
                        throw new DataFormatException("broken uncompressed block");
                    }
                    inflater.e = 5;
                }
                case 5: {
                    int n5 = inflater.p.copyStored(inflater.o, inflater.j);
                    inflater.j -= n5;
                    if (inflater.j == 0) {
                        inflater.e = 2;
                        bl = true;
                        break;
                    }
                    if (!inflater.o.needsInput()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 6: {
                    if (!inflater.q.decode(inflater.o)) {
                        bl = false;
                        break;
                    }
                    inflater.r = inflater.q.buildLitLenTree();
                    inflater.s = inflater.q.buildDistTree();
                    inflater.e = 7;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    bl = inflater.b();
                    break;
                }
                case 12: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } while (bl || this.p.getAvailable() > 0 && this.e != 11);
        return n3;
    }

    public boolean needsDictionary() {
        return this.e == 1 && this.g == 0;
    }

    public boolean needsInput() {
        return this.o.needsInput();
    }

    public void reset() {
        this.e = this.n ? 2 : 0;
        this.l = 0L;
        this.m = 0L;
        this.o.reset();
        this.p.reset();
        this.q = null;
        this.r = null;
        this.s = null;
        this.k = false;
        this.t.reset();
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public void setDictionary(byte[] byArray, int n, int n2) {
        if (!this.needsDictionary()) {
            throw new IllegalStateException();
        }
        this.t.update(byArray, n, n2);
        if ((int)this.t.getValue() != this.f) {
            throw new IllegalArgumentException("Wrong adler checksum");
        }
        this.t.reset();
        this.p.copyDict(byArray, n, n2);
        this.e = 2;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public void setInput(byte[] byArray, int n, int n2) {
        this.o.setInput(byArray, n, n2);
        this.m += (long)n2;
    }

    private boolean a() {
        while (this.g > 0) {
            int n = this.o.peekBits(8);
            if (n < 0) {
                return false;
            }
            this.o.dropBits(8);
            this.f = this.f << 8 | n;
            this.g -= 8;
        }
        return false;
    }

    private boolean b() {
        block10: for (int i = this.p.getFreeSpace(); i >= 258; i -= this.h) {
            switch (this.e) {
                case 7: {
                    int n;
                    while (((n = this.r.getSymbol(this.o)) & 0xFFFFFF00) == 0) {
                        this.p.write(n);
                        if (--i >= 258) continue;
                        return true;
                    }
                    if (n < 257) {
                        if (n < 0) {
                            return false;
                        }
                        this.s = null;
                        this.r = null;
                        this.e = 2;
                        return true;
                    }
                    try {
                        this.h = a[n - 257];
                        this.g = b[n - 257];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new DataFormatException("Illegal rep length code");
                    }
                }
                case 8: {
                    int n;
                    if (this.g > 0) {
                        this.e = 8;
                        n = this.o.peekBits(this.g);
                        if (n < 0) {
                            return false;
                        }
                        this.o.dropBits(this.g);
                        this.h += n;
                    }
                    this.e = 9;
                }
                case 9: {
                    int n = this.s.getSymbol(this.o);
                    if (n < 0) {
                        return false;
                    }
                    try {
                        this.i = c[n];
                        this.g = d[n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new DataFormatException("Illegal rep dist code");
                    }
                }
                case 10: {
                    int n;
                    if (this.g > 0) {
                        this.e = 10;
                        n = this.o.peekBits(this.g);
                        if (n < 0) {
                            return false;
                        }
                        this.o.dropBits(this.g);
                        this.i += n;
                    }
                    this.p.repeat(this.h, this.i);
                    this.e = 7;
                    continue block10;
                }
            }
            throw new IllegalStateException();
        }
        return true;
    }

    private boolean c() {
        while (this.g > 0) {
            int n = this.o.peekBits(8);
            if (n < 0) {
                return false;
            }
            this.o.dropBits(8);
            this.f = this.f << 8 | n;
            this.g -= 8;
        }
        if ((int)this.t.getValue() != this.f) {
            throw new DataFormatException("Adler chksum doesn't match: " + Integer.toHexString((int)this.t.getValue()) + " vs. " + Integer.toHexString(this.f));
        }
        this.e = 12;
        return false;
    }
}

