/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import ru.untaba.utils.zip.core.DataFormatException;
import ru.untaba.utils.zip.core.DeflaterHuffman;
import ru.untaba.utils.zip.core.StreamManipulator;
import ru.untaba.utils.zip.utils.io.InternalError;

class InflaterHuffmanTree {
    private short[] a;
    static InflaterHuffmanTree defLitLenTree;
    static InflaterHuffmanTree defDistTree;

    InflaterHuffmanTree(byte[] byArray) {
        this.a(byArray);
    }

    private void a(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        for (n6 = 0; n6 < byArray.length; ++n6) {
            n5 = byArray[n6];
            if (n5 <= 0) continue;
            int n7 = n5;
            nArray[n7] = nArray[n7] + 1;
        }
        n6 = 0;
        n5 = 512;
        for (n4 = 1; n4 <= 15; ++n4) {
            nArray2[n4] = n6;
            n6 += nArray[n4] << 16 - n4;
            if (n4 < 10) continue;
            n3 = nArray2[n4] & 0x1FF80;
            n2 = n6 & 0x1FF80;
            n5 += n2 - n3 >> 16 - n4;
        }
        if (n6 != 65536) {
            throw new DataFormatException("Code lengths don't add up properly.");
        }
        this.a = new short[n5];
        n4 = 512;
        for (n3 = 15; n3 >= 10; --n3) {
            n2 = n6 & 0x1FF80;
            for (n = n5 = (n6 -= nArray[n3] << 16 - n3) & 0x1FF80; n < n2; n += 128) {
                this.a[DeflaterHuffman.bitReverse((int)n)] = (short)(-n4 << 4 | n3);
                n4 += 1 << n3 - 9;
            }
        }
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = byArray[n3];
            if (n2 == 0) continue;
            n6 = nArray2[n2];
            n5 = DeflaterHuffman.bitReverse(n6);
            if (n2 <= 9) {
                do {
                    this.a[n5] = (short)(n3 << 4 | n2);
                } while ((n5 += 1 << n2) < 512);
            } else {
                n = this.a[n5 & 0x1FF];
                int n8 = 1 << (n & 0xF);
                n = -(n >> 4);
                do {
                    this.a[n | n5 >> 9] = (short)(n3 << 4 | n2);
                } while ((n5 += 1 << n2) < n8);
            }
            nArray2[n2] = n6 + (1 << 16 - n2);
        }
    }

    int getSymbol(StreamManipulator streamManipulator) {
        int n = streamManipulator.peekBits(9);
        if (n >= 0) {
            if ((n = this.a[n]) >= 0) {
                streamManipulator.dropBits(n & 0xF);
                return n >> 4;
            }
            int n2 = -(n >> 4);
            n &= 0xF;
            if ((n = streamManipulator.peekBits(n)) >= 0) {
                n = this.a[n2 | n >> 9];
                streamManipulator.dropBits(n & 0xF);
                return n >> 4;
            }
            int n3 = streamManipulator.getAvailableBits();
            n = streamManipulator.peekBits(n3);
            if (((n = this.a[n2 | n >> 9]) & 0xF) <= n3) {
                streamManipulator.dropBits(n & 0xF);
                return n >> 4;
            }
            return -1;
        }
        int n4 = streamManipulator.getAvailableBits();
        n = streamManipulator.peekBits(n4);
        if ((n = this.a[n]) >= 0 && (n & 0xF) <= n4) {
            streamManipulator.dropBits(n & 0xF);
            return n >> 4;
        }
        return -1;
    }

    static {
        try {
            byte[] byArray = new byte[288];
            int n = 0;
            while (n < 144) {
                byArray[n++] = 8;
            }
            while (n < 256) {
                byArray[n++] = 9;
            }
            while (n < 280) {
                byArray[n++] = 7;
            }
            while (n < 288) {
                byArray[n++] = 8;
            }
            defLitLenTree = new InflaterHuffmanTree(byArray);
            byArray = new byte[32];
            n = 0;
            while (n < 32) {
                byArray[n++] = 5;
            }
            defDistTree = new InflaterHuffmanTree(byArray);
            return;
        }
        catch (DataFormatException dataFormatException) {
            throw new InternalError("InflaterHuffmanTree: static tree length illegal");
        }
    }
}

