/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

class PendingBuffer {
    protected byte[] buf;
    int start;
    int end;
    int bits;
    int bitCount;

    public PendingBuffer() {
        this(4096);
    }

    public PendingBuffer(int n) {
        this.buf = new byte[n];
    }

    public final void reset() {
        this.bitCount = 0;
        this.end = 0;
        this.start = 0;
    }

    public final void writeByte(int n) {
        this.buf[this.end++] = (byte)n;
    }

    public final void writeShort(int n) {
        this.buf[this.end++] = (byte)n;
        this.buf[this.end++] = (byte)(n >> 8);
    }

    public final void writeInt(int n) {
        this.buf[this.end++] = (byte)n;
        this.buf[this.end++] = (byte)(n >> 8);
        this.buf[this.end++] = (byte)(n >> 16);
        this.buf[this.end++] = n >> 24;
    }

    public final void writeBlock(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.buf, this.end, n2);
        this.end += n2;
    }

    public final int getBitCount() {
        return this.bitCount;
    }

    public final void alignToByte() {
        if (this.bitCount > 0) {
            this.buf[this.end++] = (byte)this.bits;
            if (this.bitCount > 8) {
                this.buf[this.end++] = (byte)(this.bits >>> 8);
            }
        }
        this.bits = 0;
        this.bitCount = 0;
    }

    public final void writeBits(int n, int n2) {
        this.bits |= n << this.bitCount;
        this.bitCount += n2;
        if (this.bitCount >= 16) {
            this.buf[this.end++] = (byte)this.bits;
            this.buf[this.end++] = (byte)(this.bits >>> 8);
            this.bits >>>= 16;
            this.bitCount -= 16;
        }
    }

    public final void writeShortMSB(int n) {
        this.buf[this.end++] = (byte)(n >> 8);
        this.buf[this.end++] = (byte)n;
    }

    public final boolean isFlushed() {
        return this.end == 0;
    }

    public final int flush(byte[] byArray, int n, int n2) {
        if (this.bitCount >= 8) {
            this.buf[this.end++] = (byte)this.bits;
            this.bits >>>= 8;
            this.bitCount -= 8;
        }
        if (n2 > this.end - this.start) {
            n2 = this.end - this.start;
            System.arraycopy(this.buf, this.start, byArray, n, n2);
            this.start = 0;
            this.end = 0;
        } else {
            System.arraycopy(this.buf, this.start, byArray, n, n2);
            this.start += n2;
        }
        return n2;
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[this.end - this.start];
        System.arraycopy(this.buf, this.start, byArray, 0, byArray.length);
        this.start = 0;
        this.end = 0;
        return byArray;
    }
}

