/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Priere;

import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.Priere.Horaire;
import athan.src.SalaahCalc.TimeFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class PrieresJournee {
    private Calendar mCalendar;
    private Horaire mImsak;
    private Horaire mSobh;
    private Horaire mChourouk;
    private Horaire mDohr;
    private Horaire mAsr;
    private Horaire mMaghreb;
    private Horaire mIshaa;

    public PrieresJournee(Date pDateJour, Horaire pImsak, Horaire pSohb, Horaire pChourouk, Horaire pDohr, Horaire pAsr, Horaire pMaghreb, Horaire pIshaa) {
        this.setDateJour(pDateJour);
        this.mImsak = pImsak;
        this.mSobh = pSohb;
        this.mChourouk = pChourouk;
        this.mDohr = pDohr;
        this.mAsr = pAsr;
        this.mMaghreb = pMaghreb;
        this.mIshaa = pIshaa;
    }

    private String retournerNombre(int pNombre) {
        if (pNombre < 10) {
            return "0" + String.valueOf(pNombre);
        }
        return String.valueOf(pNombre);
    }

    public String getHoraire() {
        int formatHoraire = 0;
        try {
            formatHoraire = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("formatHoraire"));
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (formatHoraire == TimeFormat.H12.getValue()) {
            String prefixe = "";
            prefixe = this.mCalendar.get(9) == 0 ? "AM" : "PM";
            return prefixe + " " + this.retournerNombre(this.mCalendar.get(10)) + ":" + this.retournerNombre(this.mCalendar.get(12)) + ":" + this.retournerNombre(this.mCalendar.get(13));
        }
        if (formatHoraire == TimeFormat.H24.getValue()) {
            return this.retournerNombre(this.mCalendar.get(11)) + ":" + this.retournerNombre(this.mCalendar.get(12)) + ":" + this.retournerNombre(this.mCalendar.get(13));
        }
        return String.valueOf(this.mCalendar.getTime().getTime());
    }

    public String getJour() {
        int j = this.mCalendar.get(5);
        if (j < 10) {
            return "0" + j;
        }
        return "" + j;
    }

    public String getMois() {
        int m = this.mCalendar.get(2) + 1;
        if (m < 10) {
            return "0" + m;
        }
        return "" + m;
    }

    public String getAnnee() {
        int a = this.mCalendar.get(1);
        if (a < 10) {
            return "0" + a;
        }
        return "" + a;
    }

    public String[] getDateFormattee() {
        ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();
        return RESSOURCE.getDateFormattee(this.mCalendar);
    }

    public Horaire getImsak() {
        return this.mImsak;
    }

    public Horaire getSobh() {
        return this.mSobh;
    }

    public Horaire getChourouk() {
        return this.mChourouk;
    }

    public Horaire getDohr() {
        return this.mDohr;
    }

    public Horaire getAsr() {
        return this.mAsr;
    }

    public Horaire getMaghreb() {
        return this.mMaghreb;
    }

    public Horaire getIshaa() {
        return this.mIshaa;
    }

    public void setDateJour(Date pDateJour) {
        this.mCalendar = Calendar.getInstance(TimeZone.getDefault());
        this.mCalendar.setTime(pDateJour);
    }
}

