/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ksoap2.SoapEnvelope;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Transport {
    protected String url;
    public boolean debug;
    public String requestDump;
    public String responseDump;
    private String xmlVersionTag = "";

    public Transport() {
    }

    public Transport(String url) {
        this.url = url;
    }

    protected void parseResponse(SoapEnvelope envelope, InputStream is) throws XmlPullParserException, IOException {
        KXmlParser xp = new KXmlParser();
        xp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        xp.setInput(is, null);
        envelope.parse(xp);
    }

    protected byte[] createRequestData(SoapEnvelope envelope) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.xmlVersionTag.getBytes());
        KXmlSerializer xw = new KXmlSerializer();
        xw.setOutput(bos, null);
        envelope.write(xw);
        xw.flush();
        bos.write(13);
        bos.write(10);
        bos.flush();
        return bos.toByteArray();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setXmlVersionTag(String tag) {
        this.xmlVersionTag = tag;
    }

    public void reset() {
    }

    public abstract void call(String var1, SoapEnvelope var2) throws IOException, XmlPullParserException;
}

