/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Client;

import athan.src.Client.AthanConstantes;
import athan.src.Client.Main;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;

public abstract class Menu
extends AthanConstantes {
    private Form mForm;
    private Command mBackCommand;
    private Command mHelpCommand;

    protected abstract String getName();

    protected abstract String getIconBaseName();

    public final void run(Command backCommand, ActionListener commandListener, boolean showHelp) {
        System.gc();
        final ResourceReader RESOURCE = ServiceFactory.getFactory().getResourceReader();
        this.mForm = new Form(this.getName());
        if (showHelp) {
            this.mHelpCommand = new Command(RESOURCE.get("Menu.Help")){

                public void actionPerformed(ActionEvent evt) {
                    Form helpForm = new Form(RESOURCE.get("Window.Help"));
                    helpForm.setLayout(new BorderLayout());
                    TextArea helpText = new TextArea(Menu.this.getHelp(), 5, 10);
                    helpText.setEditable(false);
                    helpText.setUIID("TextAreaHelp");
                    helpForm.setScrollable(true);
                    helpForm.addComponent("Center", (Component)helpText);
                    Command c = new Command(RESOURCE.get("Menu.Back")){

                        public void actionPerformed(ActionEvent evt) {
                            Menu.this.mForm.show();
                        }
                    };
                    helpForm.addCommand(c);
                    helpForm.setBackCommand(c);
                    helpForm.show();
                }
            };
        }
        int posCmd = 0;
        this.mBackCommand = backCommand;
        this.mForm.addCommandListener(commandListener);
        if (this.mHelpCommand != null) {
            this.mForm.addCommand(this.mHelpCommand, posCmd++);
        }
        this.mForm.addCommand(this.mBackCommand, posCmd++);
        this.mForm.setBackCommand(backCommand);
        this.execute(this.mForm);
        this.mForm.show();
    }

    public void replacerCommandesPrincipales() {
        this.mForm.removeCommand(this.mBackCommand);
        if (this.mHelpCommand != null) {
            this.mForm.removeCommand(this.mHelpCommand);
        }
        int posCmd = this.mForm.getCommandCount();
        if (this.mHelpCommand != null) {
            this.mForm.addCommand(this.mHelpCommand, posCmd++);
        }
        this.mForm.addCommand(this.mBackCommand, posCmd++);
    }

    protected abstract String getHelp();

    protected abstract void execute(Form var1);

    protected Container createPair(String label, Component c, int minWidth) {
        Container pair = new Container(new BorderLayout());
        Label l = new Label(label);
        Dimension d = l.getPreferredSize();
        d.setWidth(Math.max(d.getWidth(), minWidth));
        l.setPreferredSize(d);
        pair.addComponent("West", (Component)l);
        pair.addComponent("Center", c);
        return pair;
    }

    protected Container createPair(String label, Component c) {
        return this.createPair(label, c, 0);
    }

    public void cleanup() {
    }

    public Form getForm() {
        return this.mForm;
    }

    protected void applyTactileSettings(Form pForm) {
        if (Main.isTactile()) {
            pForm.setTactileTouch(true);
            pForm.setSmoothScrolling(true);
        } else {
            pForm.setTactileTouch(false);
            pForm.setSmoothScrolling(false);
            pForm.setFocusScrolling(true);
        }
    }
}

