/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import org.j4me.logging.Log;

class BluetoothDeviceDiscovery
implements DiscoveryListener {
    public static final int INQUIRY_IN_PROGRESS = -1;
    public static final int SERVICE_SEARCH_IN_PROGRESS = -1;
    private DiscoveryAgent discoveryAgent;
    private Vector discoveredDevices = new Vector();
    private Vector services = new Vector();
    private int deviceDiscoveryResult = -1;
    private int serviceSearchResult = -1;

    BluetoothDeviceDiscovery() {
    }

    public String[][] discoverNearbyDeviceNamesAndAddresses() throws IOException, SecurityException {
        this.doDiscoverDevices();
        while (this.getDeviceDiscoveryResult() == -1) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        if (this.getDeviceDiscoveryResult() != 0) {
            throw new IOException("Search for Bluetooth devices failed (code " + this.getDeviceDiscoveryResult() + ").");
        }
        Vector discoveredDevices = this.getDiscoveredDevices();
        Enumeration devices = discoveredDevices.elements();
        String[][] ret = new String[discoveredDevices.size()][2];
        int i = 0;
        while (devices.hasMoreElements()) {
            RemoteDevice device = (RemoteDevice)devices.nextElement();
            String name = device.getFriendlyName(false);
            String address = device.getBluetoothAddress();
            if (name == null) {
                name = address;
            }
            String[] val = new String[]{name, address};
            ret[i] = val;
            ++i;
        }
        return ret;
    }

    public void doDiscoverDevices() throws BluetoothStateException {
        Log.debug("Starting Bluetooth device discovery");
        LocalDevice localDevice = LocalDevice.getLocalDevice();
        this.discoveryAgent = localDevice.getDiscoveryAgent();
        this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
    }

    public void doDiscoverService(RemoteDevice remote) throws BluetoothStateException {
        int[] attr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        this.discoveryAgent.searchServices(attr, new UUID[]{new UUID(256L)}, remote, (DiscoveryListener)this);
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        Log.debug("Discovered device " + remoteDevice.getBluetoothAddress());
        this.discoveredDevices.addElement(remoteDevice);
    }

    public void servicesDiscovered(int arg0, ServiceRecord[] records) {
        if (Log.isInfoEnabled()) {
            Log.info("Found services " + records.length);
        }
        for (int i = 0; i < records.length; ++i) {
            ServiceRecord record = records[i];
            this.services.addElement(record);
        }
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        this.serviceSearchResult = respCode;
    }

    public void inquiryCompleted(int inquiryResult) {
        this.deviceDiscoveryResult = inquiryResult;
    }

    public Vector getDiscoveredDevices() {
        return this.discoveredDevices;
    }

    public RemoteDevice getDeviceByFriendlyName(String friendlyName) throws IOException {
        Enumeration devices = this.discoveredDevices.elements();
        RemoteDevice device = null;
        while (devices.hasMoreElements() && !(device = (RemoteDevice)devices.nextElement()).getFriendlyName(false).equals(friendlyName)) {
        }
        return device;
    }

    public ServiceRecord getFirstDiscoveredService() {
        if (this.services.size() > 0) {
            return (ServiceRecord)this.services.elementAt(0);
        }
        return null;
    }

    public int getDeviceDiscoveryResult() {
        return this.deviceDiscoveryResult;
    }

    public String getDeviceDiscoveryResultAsString() {
        switch (this.deviceDiscoveryResult) {
            case 0: {
                return "Completed";
            }
            case 7: {
                return "Error";
            }
            case 5: {
                return "Terminated";
            }
        }
        return "Unknown Code";
    }

    public int getServiceSearchResult() {
        return this.serviceSearchResult;
    }

    public String getServiceSearchResultAsString() {
        switch (this.serviceSearchResult) {
            case 1: {
                return "Completed";
            }
            case 2: {
                return "Terminated";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "No Records";
            }
            case 6: {
                return "Device Not Reachable";
            }
        }
        return "Unknown Code";
    }

    public static String findChannelId(ServiceRecord serviceRecord) {
        DataElement e1 = serviceRecord.getAttributeValue(4);
        Enumeration enum1 = (Enumeration)e1.getValue();
        while (enum1.hasMoreElements()) {
            DataElement e2 = (DataElement)enum1.nextElement();
            Enumeration enum2 = (Enumeration)e2.getValue();
            DataElement e3 = (DataElement)enum2.nextElement();
            if (!e3.getValue().equals(new UUID(3L))) continue;
            DataElement e4 = (DataElement)enum2.nextElement();
            int id = (int)e4.getLong();
            return Integer.toString(id);
        }
        return null;
    }
}

