/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.CanvasWrapper;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;

public abstract class DeviceScreen {
    public static final int LEFT = -2;
    public static final int RIGHT = -5;
    public static final int UP = -1;
    public static final int DOWN = -6;
    public static final int FIRE = -8;
    public static final int GAME_A = -9;
    public static final int GAME_B = -10;
    public static final int GAME_C = -11;
    public static final int GAME_D = -12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_POUND = 35;
    public static final int KEY_STAR = 42;
    public static final int MENU_LEFT = -21;
    public static final int MENU_RIGHT = -22;
    private final CanvasWrapper slave = new CanvasWrapper(this);
    private boolean fullScreenMode = false;
    private String title;
    private String leftMenu;
    private String rightMenu;

    public Canvas getCanvas() {
        return this.slave;
    }

    public void show() {
        UIManager.setScreen(this, (Displayable)this.slave);
    }

    public boolean isShown() {
        return UIManager.getScreen() == this;
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public void setFullScreenMode(boolean mode) {
        this.fullScreenMode = mode;
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.slave.setTitle(title);
        this.slave.repaint();
    }

    public boolean hasTitleBar() {
        return !this.fullScreenMode && this.title != null && this.slave.supportsTitleBar();
    }

    public String toString() {
        if (this.title == null) {
            return this.getClass().getName();
        }
        return this.title;
    }

    public void setMenuText(String left, String right) {
        this.leftMenu = left;
        this.rightMenu = right;
        this.slave.setMenuText(left, right);
        this.slave.repaint();
    }

    public String getLeftMenuText() {
        return this.leftMenu;
    }

    public String getRightMenuText() {
        return this.rightMenu;
    }

    public boolean hasMenuBar() {
        return !this.fullScreenMode && (this.leftMenu != null || this.rightMenu != null) && this.slave.supportsMenuBar();
    }

    public int getWidth() {
        return this.slave.getWidth();
    }

    public int getHeight() {
        Theme theme = UIManager.getTheme();
        int height = this.getScreenHeight();
        if (this.hasTitleBar()) {
            height -= theme.getTitleHeight();
        }
        if (this.hasMenuBar()) {
            height -= theme.getMenuHeight();
        }
        return height;
    }

    public int getScreenWidth() {
        return this.slave.getWidth();
    }

    public int getScreenHeight() {
        return this.slave.getHeight();
    }

    protected void declineNotify() {
    }

    protected void acceptNotify() {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    public void repaint() {
        this.slave.setFullScreenMode(true);
        this.slave.repaint();
    }

    public void repaint(int x, int y, int width, int height) {
        if (this.hasTitleBar()) {
            Theme theme = UIManager.getTheme();
            int titleHeight = theme.getTitleHeight();
            y += titleHeight;
        }
        this.slave.repaint(x, y, width, height);
    }

    public void serviceRepaints() {
        this.slave.serviceRepaints();
    }

    protected void paintBackground(Graphics g) {
        UIManager.getTheme().paintBackground(g);
    }

    protected abstract void paint(Graphics var1);

    protected void paintTitleBar(Graphics g, String title, int width, int height) {
        UIManager.getTheme().paintTitleBar(g, title, width, height);
    }

    protected void paintMenuBar(Graphics g, String left, boolean highlightLeft, String right, boolean highlightRight, int width, int height) {
        UIManager.getTheme().paintMenuBar(g, left, highlightLeft, right, highlightRight, width, height);
    }

    public static boolean intersects(Graphics g, int x, int y, int w, int h) {
        int gx = g.getClipX();
        int gy = g.getClipY();
        int gw = g.getClipWidth();
        int gh = g.getClipHeight();
        gw += gx;
        gh += gy;
        h += y;
        boolean intersects = !((w += x) >= x && w <= gx || h >= y && h <= gy || gw >= gx && gw <= x || gh >= gy && gh <= y);
        return intersects;
    }
}

