/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;
import org.j4me.ui.components.Component;
import org.j4me.util.MathFunc;

public abstract class Dialog
extends DeviceScreen {
    private Vector components = new Vector();
    private int highlightedComponent = -1;
    private int margin;
    private int spacing = this.margin = 5;
    private int topOfScreen = 0;
    private int[] componentWidths = null;
    private int[] absoluteHeights = null;
    boolean invalidated;

    public Dialog() {
        Theme theme = UIManager.getTheme();
        String cancel = theme.getMenuTextForCancel();
        String ok = theme.getMenuTextForOK();
        this.setMenuText(cancel, ok);
    }

    public void hideNotify() {
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            c.visible(false);
        }
        super.hideNotify();
    }

    public void append(Component component) {
        this.invalidate();
        this.components.addElement(component);
    }

    public void insert(Component component, int index) {
        this.invalidate();
        this.components.insertElementAt(component, index);
    }

    public void set(Component component, int index) {
        this.invalidate();
        this.components.setElementAt(component, index);
    }

    public void delete(Component component) {
        int index = this.components.indexOf(component);
        this.delete(index);
    }

    public void delete(int index) {
        if (index >= 0) {
            this.components.removeElementAt(index);
            if (this.highlightedComponent == index) {
                this.highlightedComponent = -1;
            } else if (this.highlightedComponent > index) {
                --this.highlightedComponent;
            }
            this.invalidate();
        }
    }

    public void deleteAll() {
        this.components.removeAllElements();
        this.highlightedComponent = -1;
        this.invalidate();
    }

    public Enumeration components() {
        return this.components.elements();
    }

    public int size() {
        return this.components.size();
    }

    public Component get(int index) {
        Component c = null;
        if (index >= 0 && index < this.components.size()) {
            c = (Component)this.components.elementAt(index);
        }
        return c;
    }

    public int getSelected() {
        if (this.highlightedComponent < 0) {
            return 0;
        }
        return this.highlightedComponent;
    }

    private int getAt(int x, int y) {
        int matched = -1;
        int absY = this.topOfScreen + y;
        for (int i = 0; i < this.absoluteHeights.length - 1; ++i) {
            int top = this.absoluteHeights[i];
            int topOfNext = this.absoluteHeights[i + 1];
            int bottom = topOfNext - this.spacing;
            int left = this.margin;
            int right = left + this.componentWidths[i];
            if (absY >= top && absY < bottom && x >= left && x < right) {
                matched = i;
            }
            if (absY < topOfNext) break;
        }
        return matched;
    }

    public void setSelected(int index) {
        if (index < 0 || index >= this.components.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.highlightedComponent = index;
        if (this.absoluteHeights == null) {
            this.calculateLayout(UIManager.getTheme(), this.getWidth(), this.getHeight());
        }
        this.topOfScreen = index == 0 ? 0 : this.absoluteHeights[index] - this.spacing;
        int maxScroll = this.absoluteHeights[this.absoluteHeights.length - 1] - this.getHeight();
        if (maxScroll <= 0) {
            this.topOfScreen = 0;
        } else if (this.topOfScreen > maxScroll) {
            this.topOfScreen = maxScroll;
        }
    }

    public void setSelected(Component component) {
        Component c;
        int index = 0;
        Enumeration e = this.components.elements();
        while (e.hasMoreElements() && (c = (Component)e.nextElement()) != component) {
            ++index;
        }
        if (index < this.size()) {
            this.setSelected(index);
        }
    }

    protected synchronized void paint(Graphics g) {
        if (this.invalidated) {
            this.layout();
            this.invalidated = false;
        }
        Theme theme = UIManager.getTheme();
        int height = this.getHeight();
        if (this.hasVerticalScrollbar()) {
            int width = super.getWidth();
            int heightOfAllComponents = this.absoluteHeights[this.absoluteHeights.length - 1];
            this.paintVerticalScrollbar(g, 0, 0, width, height, this.topOfScreen, heightOfAllComponents);
        }
        int formWidth = this.getWidth();
        int bottomOfScreen = this.topOfScreen + height;
        Enumeration list = this.components.elements();
        for (int i = 0; i < this.absoluteHeights.length - 1; ++i) {
            Component c = (Component)list.nextElement();
            int componentTop = this.absoluteHeights[i];
            int componentBottom = this.absoluteHeights[i + 1] - this.spacing;
            if (componentTop >= bottomOfScreen) {
                c.visible(false);
                continue;
            }
            if (componentBottom <= this.topOfScreen) {
                c.visible(false);
                continue;
            }
            c.visible(true);
            int componentX = this.margin;
            int componentY = componentTop - this.topOfScreen;
            int componentWidth = formWidth;
            int componentHeight = componentBottom - componentTop;
            if (!Dialog.intersects(g, componentX, componentY, componentWidth, componentHeight)) continue;
            boolean selected = i == this.highlightedComponent;
            c.paint(g, theme, this, componentX, componentY, componentWidth, componentHeight, selected);
        }
    }

    protected void paintVerticalScrollbar(Graphics g, int x, int y, int width, int height, int offset, int formHeight) {
        UIManager.getTheme().paintVerticalScrollbar(g, x, y, width, height, offset, formHeight);
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        if (margin >= 0 && this.margin != margin) {
            this.margin = margin;
            this.invalidate();
        }
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing >= 0 && this.spacing != spacing) {
            this.spacing = spacing;
            this.invalidate();
        }
    }

    public int getWidth() {
        int canvasWidth = super.getWidth();
        int formWidth = canvasWidth - 2 * this.margin;
        if (this.hasVerticalScrollbar()) {
            int scrollbarWidth = UIManager.getTheme().getVerticalScrollbarWidth();
            formWidth -= scrollbarWidth;
        }
        return formWidth;
    }

    public synchronized boolean hasVerticalScrollbar() {
        int screenHeight = this.getHeight();
        int formWidth = super.getWidth() - 2 * this.margin;
        boolean layoutJustCalculated = false;
        Theme theme = UIManager.getTheme();
        if (this.invalidated || this.absoluteHeights == null) {
            this.calculateLayout(theme, formWidth, screenHeight);
            layoutJustCalculated = true;
        }
        if (this.absoluteHeights[this.absoluteHeights.length - 1] > screenHeight) {
            if (layoutJustCalculated) {
                this.calculateLayout(theme, formWidth -= theme.getVerticalScrollbarWidth(), screenHeight);
            }
            return true;
        }
        return false;
    }

    public void invalidate() {
        this.invalidated = true;
    }

    private synchronized void layout() {
        int component = 0;
        int delta = 0;
        if (this.absoluteHeights != null) {
            if (this.highlightedComponent >= 0) {
                component = this.highlightedComponent;
            }
            delta = this.absoluteHeights[component] - this.topOfScreen;
        }
        this.componentWidths = null;
        this.absoluteHeights = null;
        this.topOfScreen = 0;
        this.hasVerticalScrollbar();
        if (component != 0) {
            this.highlightedComponent = component;
            this.topOfScreen = this.absoluteHeights[component] - delta;
        }
    }

    private synchronized void calculateLayout(Theme theme, int width, int height) {
        this.componentWidths = new int[this.components.size() + 1];
        this.absoluteHeights = new int[this.componentWidths.length];
        int componentY = this.margin;
        Enumeration list = this.components.elements();
        int i = 0;
        while (list.hasMoreElements()) {
            this.absoluteHeights[i] = componentY;
            Component c = (Component)list.nextElement();
            int[] dimensions = c.getPreferredSize(theme, width, height);
            this.componentWidths[i] = dimensions[0];
            componentY += dimensions[1] + this.spacing;
            ++i;
        }
        if (this.highlightedComponent < 0) {
            this.highlightedComponent = 0;
        }
        this.absoluteHeights[this.absoluteHeights.length - 1] = componentY;
    }

    private int nextHighlightableComponent(boolean down, int maxScroll) {
        if (down) {
            int maxBottom = this.highlightedComponent < 0 ? this.topOfScreen : this.topOfScreen + this.getHeight();
            maxBottom += maxScroll;
            int components = this.size();
            for (int next = this.highlightedComponent + 1; next < components; ++next) {
                int nextBottom = this.absoluteHeights[next + 1];
                if (nextBottom > maxBottom) {
                    if (next - 1 == this.highlightedComponent) {
                        return next;
                    }
                    return next - 1;
                }
                Component c = this.get(next);
                if (!c.acceptsInput()) continue;
                return next;
            }
            return components - 1;
        }
        if (this.highlightedComponent > 0) {
            int maxTop = this.topOfScreen - maxScroll;
            for (int next = this.highlightedComponent - 1; next >= 0; --next) {
                int nextTop = this.absoluteHeights[next];
                if (nextTop < maxTop) {
                    if (next + 1 == this.highlightedComponent) {
                        return next;
                    }
                    return next + 1;
                }
                Component c = this.get(next);
                if (!c.acceptsInput()) continue;
                return next;
            }
        }
        return 0;
    }

    private void scroll(boolean down) {
        if (this.absoluteHeights == null) {
            this.hasVerticalScrollbar();
        }
        if (this.components.size() == 0) {
            return;
        }
        int topOfForm = 0;
        int screenHeight = this.getHeight();
        int bottomOfForm = this.absoluteHeights[this.absoluteHeights.length - 1] - screenHeight;
        int bottomOfScreen = this.topOfScreen + screenHeight;
        int max = screenHeight * 9 / 10;
        int current = this.highlightedComponent;
        this.highlightedComponent = this.nextHighlightableComponent(down, max);
        if (this.hasVerticalScrollbar()) {
            int scroll;
            if (down) {
                int currentBottom = this.absoluteHeights[current + 1];
                if (currentBottom > bottomOfScreen) {
                    scroll = max;
                } else {
                    int nextTop = this.absoluteHeights[this.highlightedComponent];
                    int nextBottom = this.absoluteHeights[this.highlightedComponent + 1];
                    scroll = nextTop > this.topOfScreen && nextBottom < bottomOfScreen ? 0 : nextBottom - currentBottom;
                }
            } else {
                int currentTop = this.absoluteHeights[current];
                if (currentTop < this.topOfScreen) {
                    scroll = max;
                } else if (this.highlightedComponent == 0) {
                    scroll = this.topOfScreen;
                } else {
                    int previousBottom = this.absoluteHeights[this.highlightedComponent] - this.spacing;
                    scroll = this.topOfScreen - previousBottom;
                    if (previousBottom >= this.topOfScreen) {
                        scroll = 0;
                    }
                }
            }
            if (scroll > max) {
                scroll = max;
            }
            if (!down) {
                scroll *= -1;
            }
            this.topOfScreen += scroll;
            if (this.topOfScreen < topOfForm) {
                this.topOfScreen = topOfForm;
            } else if (this.topOfScreen > bottomOfForm) {
                this.topOfScreen = bottomOfForm;
            }
        }
        this.repaint();
    }

    public void setFullScreenMode(boolean mode) {
        super.setFullScreenMode(mode);
        this.invalidate();
    }

    public void setMenuText(String left, String right) {
        super.setMenuText(left, right);
        this.invalidate();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.invalidate();
    }

    protected void keyPressed(int keyCode) {
        Component c = this.get(this.highlightedComponent);
        if (c != null) {
            c.keyPressed(keyCode);
        }
        if (keyCode == -1) {
            this.scroll(false);
        } else if (keyCode == -6) {
            this.scroll(true);
        }
        super.keyPressed(keyCode);
    }

    protected void keyRepeated(int keyCode) {
        Component c = this.get(this.highlightedComponent);
        if (c != null) {
            c.keyRepeated(keyCode);
        }
        super.keyRepeated(keyCode);
    }

    protected void keyReleased(int keyCode) {
        Component c = this.get(this.highlightedComponent);
        if (c != null) {
            c.keyReleased(keyCode);
        }
        super.keyReleased(keyCode);
    }

    protected void pointerPressed(int x, int y) {
        int scrollbarWidth;
        int screenWidth;
        int scrollbarX;
        boolean movedScrollbar = false;
        if (this.hasVerticalScrollbar() && x >= (scrollbarX = (screenWidth = this.getScreenWidth()) - (scrollbarWidth = UIManager.getTheme().getVerticalScrollbarWidth()))) {
            int range;
            double offsetPercentage;
            movedScrollbar = true;
            int height = this.getHeight();
            int formHeight = this.absoluteHeights[this.absoluteHeights.length - 1];
            int scrollableHeight = formHeight - height;
            double trackbarPercentage = (double)height / (double)formHeight;
            int trackbarHeight = (int)MathFunc.round((double)height * trackbarPercentage);
            int rangeStart = (trackbarHeight = Math.max(trackbarHeight, 2 * scrollbarWidth)) / 2;
            int center = rangeStart + (int)MathFunc.round((offsetPercentage = (double)this.topOfScreen / (double)scrollableHeight) * (double)(range = height - 2 * rangeStart));
            if (y < center) {
                this.scroll(false);
            } else {
                this.scroll(true);
            }
        }
        if (!movedScrollbar) {
            this.highlightedComponent = this.getAt(x, y);
            Component c = this.get(this.highlightedComponent);
            if (c != null) {
                int px = x - c.getX();
                int py = y - c.getY();
                c.pointerPressed(px, py);
            }
        }
        super.pointerPressed(x, y);
    }

    protected void pointerDragged(int x, int y) {
        Component c = this.get(this.highlightedComponent);
        if (c != null) {
            c.pointerDragged(x, y);
        }
        super.pointerDragged(x, y);
    }

    protected void pointerReleased(int x, int y) {
        Component c = this.get(this.highlightedComponent);
        if (c != null) {
            c.pointerReleased(x, y);
        }
        super.pointerReleased(x, y);
    }
}

