/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;
import org.j4me.ui.Theme;

public abstract class Component {
    protected static final int HIGHLIGHTED_BORDER_WIDTH = 2;
    private int horizontalAlignment = 4;
    private boolean visible;
    private DeviceScreen screen;
    protected Component container;
    private int x;
    private int y;
    private int width;
    private int height;

    public final void paint(Graphics g, Theme theme, DeviceScreen screen, int x, int y, int width, int height, boolean selected) {
        if (this.isShown()) {
            this.screen = screen;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            int originalClipX = g.getClipX();
            int originalClipY = g.getClipY();
            int originalClipWidth = g.getClipWidth();
            int originalClipHeight = g.getClipHeight();
            g.setClip(originalClipX, originalClipY, originalClipWidth, originalClipHeight * 2);
            g.translate(x, y);
            g.clipRect(0, 0, width, height * 2);
            int originalColor = g.getColor();
            g.setColor(theme.getFontColor());
            Font originalFont = g.getFont();
            g.setFont(theme.getFont());
            int originalStroke = g.getStrokeStyle();
            g.setStrokeStyle(0);
            this.paintComponent(g, theme, width, height, selected);
            g.translate(-x, -y);
            g.setClip(originalClipX, originalClipY, originalClipWidth, originalClipHeight);
            g.setColor(originalColor);
            g.setFont(originalFont);
            g.setStrokeStyle(originalStroke);
        }
    }

    protected abstract void paintComponent(Graphics var1, Theme var2, int var3, int var4, boolean var5);

    public final int[] getPreferredSize(Theme theme, int viewportWidth, int viewportHeight) {
        int[] dimensions = this.getPreferredComponentSize(theme, viewportWidth, viewportHeight);
        if (dimensions == null || dimensions.length != 2) {
            throw new RuntimeException(this.getClass().getName() + ".getPreferredComponentSize must return an array of length 2");
        }
        return dimensions;
    }

    protected abstract int[] getPreferredComponentSize(Theme var1, int var2, int var3);

    public boolean acceptsInput() {
        return false;
    }

    public DeviceScreen getScreen() {
        return this.screen;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment != 4 && alignment != 1 && alignment != 8) {
            throw new IllegalArgumentException("setHorizontalAlignment only takes Graphics.LEFT, HCENTER, or RIGHT");
        }
        this.horizontalAlignment = alignment;
    }

    public void visible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (visible) {
                this.showNotify();
            } else {
                this.hideNotify();
            }
        }
    }

    public boolean isShown() {
        return this.visible;
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void invalidate() {
        if (this.screen != null && this.screen instanceof Dialog) {
            Dialog d = (Dialog)this.screen;
            d.invalidate();
        }
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
    }

    public void repaint() {
        if (this.isShown() && this.screen != null) {
            if (this.height != 0) {
                this.screen.repaint(this.x, this.y, this.width, this.height);
            } else {
                this.screen.repaint();
            }
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    protected static int paintRect(Graphics g, Theme theme, int x, int y, int width, int height, boolean selected) {
        int bo;
        int border;
        int rounding = Math.min(height / 4, 5);
        if (selected) {
            border = theme.getHighlightColor();
            g.setColor(border);
            g.drawRoundRect(0, y, width - 1, height - 1, rounding, rounding);
        }
        border = theme.getBorderColor();
        g.setColor(border);
        int bx = bo = 1;
        int by = y + bo;
        int bs = 2 * bo;
        int bw = width - bs;
        int bh = height - bs;
        g.drawRect(bx, by, bw - 1, bh - 1);
        int offset = Math.max(2, rounding / 2);
        return offset;
    }
}

