/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;
import org.j4me.util.MathFunc;

public class ProgressBar
extends Component {
    private static final int ANIMATION_INTERVAL = 166;
    private double widthPercentage = 0.9;
    private double heightPercentage = 0.0;
    private Label label;
    private int value;
    private int max;
    private int spinnerHour;
    private Timer timer;

    public ProgressBar() {
        this.setHorizontalAlignment(1);
    }

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label.getLabel();
    }

    public void setLabel(String label) {
        if (label == null) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new Label();
            }
            this.label.setLabel(label);
        }
        this.invalidate();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value < 0 ? 0 : (value > this.max ? this.max : value);
    }

    public int getMaxValue() {
        return this.max;
    }

    public void setMaxValue(int max) {
        if (max < 0) {
            this.max = 0;
        } else {
            this.stopTimer();
            this.max = max;
        }
        if (this.max < this.value) {
            this.value = this.max;
        }
    }

    public void setRelativeWidth(double percentageOfScreen) {
        if (percentageOfScreen < 0.0 || percentageOfScreen > 1.0) {
            throw new IllegalArgumentException(String.valueOf(percentageOfScreen));
        }
        this.widthPercentage = percentageOfScreen;
    }

    public double getRelativeWidth() {
        return this.widthPercentage;
    }

    public void setRelativeHeight(double percentageOfFontHeight) {
        if (percentageOfFontHeight < 0.0) {
            throw new IllegalArgumentException(String.valueOf(percentageOfFontHeight));
        }
        this.heightPercentage = percentageOfFontHeight;
        this.invalidate();
    }

    public double getRelativeHeight() {
        if (this.heightPercentage == 0.0) {
            if (this.max == 0) {
                return 2.0;
            }
            return 1.2;
        }
        return this.heightPercentage;
    }

    protected void paintComponent(Graphics g, Theme theme, int width, int height, boolean selected) {
        int y = 0;
        if (this.label != null) {
            int labelHeight;
            this.label.setHorizontalAlignment(this.getHorizontalAlignment());
            this.label.paint(g, theme, this.getScreen(), 0, 0, width, height, selected);
            y = labelHeight = this.label.getHeight();
            height -= labelHeight;
        }
        if (this.max == 0) {
            this.startTimer();
            this.paintSpinner(g, theme, 0, y, width, height, selected);
        } else {
            this.paintBar(g, theme, 0, y, width, height, selected);
        }
    }

    protected void paintBar(Graphics g, Theme theme, int x, int y, int width, int height, boolean selected) {
        int barWidth = (int)((double)width * this.getRelativeWidth());
        int horizontalAlignment = this.getHorizontalAlignment();
        if (horizontalAlignment == 1) {
            x += (width - barWidth) / 2;
        } else if (horizontalAlignment == 8) {
            x += width - barWidth;
        }
        width = barWidth;
        double percentageCompleted = (double)this.value / (double)this.max;
        int completedWidth = (int)MathFunc.round((double)width * percentageCompleted);
        int complete = theme.getBorderColor();
        int highlight = theme.getHighlightColor();
        Theme.gradientFill(g, x, y, completedWidth, height, true, complete, highlight, 0.5);
        int incomplete = theme.getBackgroundColor();
        g.setColor(incomplete);
        g.fillRect(x + completedWidth, y, x + width - completedWidth, height);
        int border = theme.getBorderColor();
        g.setColor(border);
        g.drawRect(x, y, width - 1, height - 1);
    }

    protected void paintSpinner(Graphics g, Theme theme, int x, int y, int width, int height, boolean selected) {
        int side = Math.min(width, height);
        int diameter = side / 6;
        int radius = diameter / 2;
        double toCenter = side / 3;
        int temp = side / 2 - radius;
        int left = x + temp;
        int top = y + temp;
        int horizontalAlignment = this.getHorizontalAlignment();
        if (horizontalAlignment == 1) {
            left += (width - side) / 2;
        } else if (horizontalAlignment == 8) {
            left += width - side;
        }
        int background = theme.getBackgroundColor();
        int foreground = theme.getBorderColor();
        int redStart = (background & 0xFF0000) >> 16;
        int greenStart = (background & 0xFF00) >> 8;
        int blueStart = background & 0xFF;
        int redDelta = (foreground & 0xFF0000) >> 16;
        int greenDelta = (foreground & 0xFF00) >> 8;
        int blueDelta = foreground & 0xFF;
        redDelta = (redDelta - redStart) / 12;
        greenDelta = (greenDelta - greenStart) / 12;
        blueDelta = (blueDelta - blueStart) / 12;
        for (int hour = 1; hour <= 12; ++hour) {
            int angle = ((hour - 3) * -30 + 360) % 360;
            double radians = Math.toRadians(angle);
            int cx = (int)MathFunc.round(Math.cos(radians) * toCenter);
            int cy = (int)MathFunc.round(Math.sin(radians) * toCenter) * -1;
            int offset = (hour - this.spinnerHour + 12) % 12;
            int red = redStart + offset * redDelta;
            int green = greenStart + offset * greenDelta;
            int blue = blueStart + offset * blueDelta;
            g.setColor(red, green, blue);
            g.fillRoundRect(left + cx, top + cy, diameter, diameter, diameter, diameter);
        }
    }

    protected int[] getPreferredComponentSize(Theme theme, int viewportWidth, int viewportHeight) {
        int width = (int)((double)viewportWidth * this.getRelativeWidth());
        int fontHeight = theme.getFont().getHeight();
        int height = (int)((double)fontHeight * this.getRelativeHeight());
        if (this.max == 0) {
            height += height % 6;
        }
        if (this.label != null) {
            int[] labelDimensions = this.label.getPreferredComponentSize(theme, viewportWidth, viewportHeight);
            height += labelDimensions[1];
        }
        return new int[]{width, height};
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new SpinnerTask(), 0L, 166L);
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void showNotify() {
        if (this.label != null) {
            this.label.visible(true);
        }
        super.showNotify();
    }

    protected void hideNotify() {
        if (this.label != null) {
            this.label.visible(false);
        }
        this.stopTimer();
        super.hideNotify();
    }

    private final class SpinnerTask
    extends TimerTask {
        private SpinnerTask() {
        }

        public void run() {
            ProgressBar.this.spinnerHour = (ProgressBar.this.spinnerHour + 1) % 12;
            ProgressBar.this.repaint();
        }
    }
}

