/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;

public class TextBox
extends Component {
    private static final int DEFAULT_MAX_CHARS = 128;
    private static final int TEXT_OFFSET = 2;
    private Label label;
    private String contents;
    private int maxSize = 128;
    private int constraints = 0;

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label.getLabel();
    }

    public void setLabel(String label) {
        if (label == null) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new Label();
            }
            this.label.setLabel(label);
        }
        this.invalidate();
    }

    public String getString() {
        if (this.contents == null) {
            return "";
        }
        return this.contents;
    }

    public void setString(String text) {
        this.contents = text;
        this.invalidate();
    }

    public void setForAnyText() {
        this.setRestrictiveConstraint(0);
    }

    public void setForNumericOnly() {
        this.setRestrictiveConstraint(2);
    }

    public void setForPhoneNumber() {
        this.setRestrictiveConstraint(3);
    }

    public boolean isPhoneNumber() {
        boolean phone = (this.constraints & 3) != 0;
        return phone;
    }

    private void setRestrictiveConstraint(int restriction) {
        this.constraints &= 0xFFFF;
        this.constraints |= restriction;
        this.invalidate();
    }

    public void setPassword(boolean password) {
        this.setModifierConstraint(65536, password);
    }

    public boolean isPassword() {
        boolean password = (this.constraints & 0x10000) != 0;
        return password;
    }

    private void setModifierConstraint(int modifier, boolean on) {
        this.constraints = on ? (this.constraints |= modifier) : (this.constraints &= ~modifier);
        this.invalidate();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException(String.valueOf(maxSize));
        }
        if (maxSize < this.size()) {
            this.contents = this.contents.substring(0, maxSize);
            this.repaint();
        }
        this.maxSize = maxSize;
    }

    public int size() {
        int size = 0;
        if (this.contents != null) {
            size = this.contents.length();
        }
        return size;
    }

    protected void paintComponent(Graphics g, Theme theme, int width, int height, boolean selected) {
        int y = 0;
        if (this.label != null) {
            int labelHeight;
            this.label.setHorizontalAlignment(this.getHorizontalAlignment());
            this.label.paint(g, theme, this.getScreen(), 0, 0, width, height, selected);
            y = labelHeight = this.label.getHeight();
            height -= labelHeight;
        }
        int offset = TextBox.paintRect(g, theme, 0, y, width, height, selected);
        if (this.contents != null) {
            int left = offset += 2;
            int top = y + offset;
            int anchor = 20;
            g.clipRect(left, top, width -= 2 * offset, height -= 2 * offset);
            g.setColor(theme.getFontColor());
            String display = this.contents;
            if (this.isPassword()) {
                int length = this.contents.length();
                StringBuffer builder = new StringBuffer(length);
                for (int i = 0; i < length; ++i) {
                    builder.append('*');
                }
                display = builder.toString();
            } else if (this.isPhoneNumber() && display.length() == 10) {
                StringBuffer builder = new StringBuffer(15);
                builder.append("(");
                builder.append(display.substring(0, 3));
                builder.append(") ");
                builder.append(display.substring(3, 6));
                builder.append("-");
                builder.append(display.substring(6, 10));
                display = builder.toString();
            }
            g.drawString(display, left, top, anchor);
        }
    }

    protected int[] getPreferredComponentSize(Theme theme, int viewportWidth, int viewportHeight) {
        int fontHeight = theme.getFont().getHeight();
        int height = fontHeight + 8;
        if (this.label != null) {
            int[] labelDimensions = this.label.getPreferredComponentSize(theme, viewportWidth, viewportHeight);
            height += labelDimensions[1];
        }
        return new int[]{viewportWidth, height};
    }

    protected void showNotify() {
        if (this.label != null) {
            this.label.visible(true);
        }
        super.showNotify();
    }

    protected void hideNotify() {
        if (this.label != null) {
            this.label.visible(false);
        }
        super.hideNotify();
    }

    public boolean acceptsInput() {
        return true;
    }

    public void keyPressed(int keyCode) {
        if (keyCode > 0 || keyCode == -8) {
            this.select();
        }
    }

    public void pointerPressed(int x, int y) {
        this.select();
    }

    protected void select() {
        DeviceScreen current = UIManager.getScreen();
        String label = this.getLabel();
        String contents = this.getString();
        int maxSize = this.getMaxSize();
        TextInput entry = new TextInput(current, this, label, contents, maxSize, this.constraints);
        Display display = UIManager.getDisplay();
        display.setCurrent((Displayable)entry);
    }

    private final class TextInput
    extends javax.microedition.lcdui.TextBox
    implements CommandListener {
        private final Command cancel;
        private final Command ok;
        private final DeviceScreen parent;
        private final TextBox component;

        public TextInput(DeviceScreen parent, TextBox box, String label, String contents, int maxSize, int constraints) {
            super(label, contents, maxSize, constraints);
            this.parent = parent;
            this.component = box;
            Theme theme = UIManager.getTheme();
            String cancelText = theme.getMenuTextForCancel();
            this.cancel = new Command(cancelText, 3, 1);
            this.addCommand(this.cancel);
            String okText = theme.getMenuTextForOK();
            this.ok = new Command(okText, 4, 2);
            this.addCommand(this.ok);
            this.setCommandListener(this);
        }

        public void commandAction(Command c, Displayable d) {
            if (c == this.ok) {
                String input = this.getString();
                this.component.setString(input);
            }
            this.parent.show();
            this.parent.repaint();
        }
    }
}

