/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationImpl;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.collections.CubbyHole;
import org.j4me.logging.Log;

class JSR179LocationProvider
extends LocationProvider
implements Runnable {
    private final javax.microedition.location.LocationProvider original;
    private final CubbyHole update = new CubbyHole();
    private LocationListener locationListener;
    private final Thread worker = new Thread(this);
    private boolean hasBeenAvailable = false;
    private int lastState = 2;
    private int interval;
    private int timeout;
    private int maxAge;

    public static LocationProvider getInstance(Criteria criteria) throws LocationException {
        try {
            javax.microedition.location.Criteria c = JSR179LocationProvider.convertCriteria(criteria);
            javax.microedition.location.LocationProvider jsr179provider = javax.microedition.location.LocationProvider.getInstance((javax.microedition.location.Criteria)c);
            if (jsr179provider != null) {
                return new JSR179LocationProvider(jsr179provider);
            }
        }
        catch (javax.microedition.location.LocationException e) {
            throw JSR179LocationProvider.convertLocationException(e);
        }
        return null;
    }

    private JSR179LocationProvider(javax.microedition.location.LocationProvider provider) {
        this.original = provider;
    }

    public int getState() {
        int status = this.original.getState();
        status = JSR179LocationProvider.convertAvailabilityStatusCode(this.lastState);
        return status;
    }

    public Location getLocation(int timeout) throws LocationException, InterruptedException {
        try {
            javax.microedition.location.Location location = this.original.getLocation(timeout);
            Location j4me = JSR179LocationProvider.convertLocation(location);
            return j4me;
        }
        catch (javax.microedition.location.LocationException e) {
            throw JSR179LocationProvider.convertLocationException(e);
        }
    }

    protected Location getLastKnownLocationToProvider() {
        javax.microedition.location.Location location = javax.microedition.location.LocationProvider.getLastKnownLocation();
        Location j4me = JSR179LocationProvider.convertLocation(location);
        return j4me;
    }

    public void setLocationListener(LocationListener locationListener, int interval, int timeout, int maxAge) {
        this.locationListener = locationListener;
        this.interval = interval;
        this.timeout = timeout;
        this.maxAge = maxAge;
        if (this.original.getState() == 1) {
            this.hasBeenAvailable = true;
        }
        if (this.worker.isAlive()) {
            this.worker.interrupt();
        }
        if (locationListener == null) {
            this.original.setLocationListener(null, interval, timeout, maxAge);
        } else {
            this.lastState = 2;
            this.original.setLocationListener((javax.microedition.location.LocationListener)new JSR179Listener(), interval, timeout, maxAge);
            this.worker.start();
        }
    }

    public void reset() {
        this.original.reset();
        if (this.locationListener != null) {
            this.original.setLocationListener((javax.microedition.location.LocationListener)new JSR179Listener(), this.interval, this.timeout, this.maxAge);
        }
    }

    public void close() {
        this.reset();
        this.setLocationListener(null, -1, -1, -1);
        this.worker.interrupt();
    }

    public void run() {
        try {
            while (true) {
                Object o;
                if ((o = this.update.get()) instanceof Integer) {
                    Integer i = (Integer)o;
                    int newState = i;
                    this.raiseStateChangeEvent(newState);
                    if (!this.hasBeenAvailable || newState != 2) continue;
                    Thread.sleep(this.interval * 1000);
                    if (this.original.getState() != 2) continue;
                    Log.info("Resetting the location provider to get another fix");
                    this.reset();
                    continue;
                }
                javax.microedition.location.Location l = (javax.microedition.location.Location)o;
                if (this.lastState != 1 && l.isValid()) {
                    this.raiseStateChangeEvent(1);
                }
                this.raiseLocationEvent(l);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void raiseStateChangeEvent(int newState) {
        this.lastState = newState;
        if (this.locationListener != null) {
            int state = JSR179LocationProvider.convertAvailabilityStatusCode(newState);
            try {
                this.locationListener.providerStateChanged(this, state);
            }
            catch (Throwable t) {
                Log.warn("Unhandled exception in LocationProvider.providerStateChanged to " + state, t);
            }
        }
    }

    private void raiseLocationEvent(javax.microedition.location.Location location) {
        if (this.locationListener != null) {
            Location l = JSR179LocationProvider.convertLocation(location);
            try {
                this.locationListener.locationUpdated(this, l);
            }
            catch (Throwable t) {
                Log.warn("Unhandled exception in LocationProvider.locationUpdated\n" + l, t);
            }
        }
    }

    protected static LocationException convertLocationException(javax.microedition.location.LocationException jsr179) {
        LocationException j4me = new LocationException(jsr179.getMessage());
        return j4me;
    }

    protected static javax.microedition.location.Criteria convertCriteria(Criteria j4me) {
        javax.microedition.location.Criteria jsr179 = new javax.microedition.location.Criteria();
        jsr179.setAddressInfoRequired(j4me.isAddressInfoRequired());
        jsr179.setAltitudeRequired(j4me.isAltitudeRequired());
        jsr179.setCostAllowed(j4me.isAllowedToCost());
        jsr179.setHorizontalAccuracy(j4me.getHorizontalAccuracy());
        jsr179.setPreferredResponseTime(j4me.getPreferredResponseTime());
        jsr179.setSpeedAndCourseRequired(j4me.isSpeedAndCourseRequired());
        jsr179.setVerticalAccuracy(j4me.getVerticalAccuracy());
        int power = j4me.getPreferredPowerConsumption();
        switch (power) {
            case 0: {
                power = 0;
                break;
            }
            case 1: {
                power = 1;
                break;
            }
            case 2: {
                power = 2;
                break;
            }
            case 3: {
                power = 3;
            }
        }
        jsr179.setPreferredPowerConsumption(power);
        return jsr179;
    }

    protected static QualifiedCoordinates convertQualifiedCoordinates(javax.microedition.location.QualifiedCoordinates jsr179) {
        if (jsr179 == null) {
            return null;
        }
        double latitude = jsr179.getLatitude();
        double longitude = jsr179.getLongitude();
        float altitude = jsr179.getAltitude();
        float horizontalAccuracy = jsr179.getHorizontalAccuracy();
        float verticalAccuracy = jsr179.getVerticalAccuracy();
        QualifiedCoordinates j4me = new QualifiedCoordinates(latitude, longitude, altitude, horizontalAccuracy, verticalAccuracy);
        return j4me;
    }

    protected static Location convertLocation(javax.microedition.location.Location jsr179) {
        LocationImpl j4me = null;
        if (jsr179 != null) {
            if (jsr179.isValid()) {
                QualifiedCoordinates j4meCoordinates = JSR179LocationProvider.convertQualifiedCoordinates(jsr179.getQualifiedCoordinates());
                j4me = new LocationImpl(j4meCoordinates, jsr179.getSpeed(), jsr179.getCourse(), jsr179.getTimestamp());
            } else {
                j4me = new LocationImpl();
            }
        }
        return j4me;
    }

    protected static int convertAvailabilityStatusCode(int jsr179) {
        int j4me = -1;
        switch (jsr179) {
            case 1: {
                j4me = 1;
                break;
            }
            case 3: {
                j4me = 3;
                break;
            }
            case 2: {
                j4me = 2;
            }
        }
        return j4me;
    }

    private final class JSR179Listener
    implements javax.microedition.location.LocationListener {
        private JSR179Listener() {
        }

        public void providerStateChanged(javax.microedition.location.LocationProvider provider, int newState) {
            if (newState != 1) {
                Integer state = new Integer(newState);
                JSR179LocationProvider.this.update.set(state);
            }
        }

        public void locationUpdated(javax.microedition.location.LocationProvider provider, javax.microedition.location.Location location) {
            JSR179LocationProvider.this.hasBeenAvailable = true;
            JSR179LocationProvider.this.update.set(location);
        }
    }
}

