/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.logging;

import org.j4me.logging.Level;
import org.j4me.logging.LogMessage;

public class Log {
    private static final int MAX_LOG_MESSAGES = 25;
    private static LogMessage[] store;
    private static int oldestMessageIndex;
    private static int newestMessageIndex;
    private static Level level;

    public static Level getLogLevel() {
        return level;
    }

    public static void setLevel(int level) {
        if (level == Level.DEBUG.levelInt) {
            Log.level = Level.DEBUG;
        } else if (level == Level.INFO.levelInt) {
            Log.level = Level.INFO;
        } else if (level == Level.WARN.levelInt) {
            Log.level = Level.WARN;
        } else if (level == Level.ERROR.levelInt) {
            Log.level = Level.ERROR;
        } else if (level == Level.OFF.levelInt) {
            Log.level = Level.OFF;
        } else {
            throw new IllegalArgumentException("getLevel(" + level + ") not a valid level");
        }
    }

    public static void setLevel(Level level) {
        Log.level = level;
    }

    public static void debug(String message) {
        if (Log.level.levelInt <= Level.DEBUG.levelInt) {
            Log.addLogMessage(message, Level.DEBUG, null);
        }
    }

    public static void debug(String message, Throwable t) {
        if (Log.level.levelInt <= Level.DEBUG.levelInt) {
            Log.addLogMessage(message, Level.DEBUG, t);
        }
    }

    public static void info(String message) {
        if (Log.level.levelInt <= Level.INFO.levelInt) {
            Log.addLogMessage(message, Level.INFO, null);
        }
    }

    public static void info(String message, Throwable t) {
        if (Log.level.levelInt <= Level.INFO.levelInt) {
            Log.addLogMessage(message, Level.INFO, t);
        }
    }

    public static void warn(String message) {
        if (Log.level.levelInt <= Level.WARN.levelInt) {
            Log.addLogMessage(message, Level.WARN, null);
        }
    }

    public static void warn(String message, Throwable t) {
        if (Log.level.levelInt <= Level.WARN.levelInt) {
            Log.addLogMessage(message, Level.WARN, t);
        }
    }

    public static void error(String message) {
        if (Log.level.levelInt <= Level.ERROR.levelInt) {
            Log.addLogMessage(message, Level.ERROR, null);
        }
    }

    public static void error(String message, Throwable t) {
        if (Log.level.levelInt <= Level.ERROR.levelInt) {
            Log.addLogMessage(message, Level.ERROR, t);
        }
    }

    public static boolean isDebugEnabled() {
        return Log.level.levelInt <= Level.DEBUG.levelInt;
    }

    public static boolean isInfoEnabled() {
        return Log.level.levelInt <= Level.INFO.levelInt;
    }

    private static synchronized void addLogMessage(String message, Level level, Throwable throwable) {
        if (message == null) {
            message = "";
        }
        String text = message;
        if (throwable != null) {
            text = text + "\n" + throwable.toString();
        }
        System.err.print("[");
        System.err.print(level);
        System.err.print("] ");
        System.err.println(message);
        if (throwable != null) {
            throwable.printStackTrace();
        }
        if ((newestMessageIndex = (newestMessageIndex + 1) % 25) == oldestMessageIndex) {
            store[newestMessageIndex].setLogMessage(level, text);
            oldestMessageIndex = (oldestMessageIndex + 1) % 25;
        } else {
            Log.store[Log.newestMessageIndex] = new LogMessage(level, text);
            if (oldestMessageIndex < 0) {
                oldestMessageIndex = 0;
            }
        }
    }

    public static synchronized LogMessage[] getLogMessages() {
        int numberOfMessages = newestMessageIndex < 0 ? 0 : (newestMessageIndex >= oldestMessageIndex ? newestMessageIndex - oldestMessageIndex + 1 : 25);
        LogMessage[] copy = new LogMessage[numberOfMessages];
        for (int i = 0; i < numberOfMessages; ++i) {
            int index = newestMessageIndex - i;
            if (index < 0) {
                index = 25 + index;
            }
            copy[numberOfMessages - i - 1] = store[index];
        }
        return copy;
    }

    public static synchronized void clear() {
        oldestMessageIndex = -1;
        newestMessageIndex = -1;
        store = new LogMessage[25];
    }

    static {
        level = Level.INFO;
        Log.clear();
    }
}

