/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;

public class Label
extends Component {
    private String text;
    private String[] lines;
    private int widthForLines;
    private int height;
    private Font font;
    private int fontColor = -1;

    public Label() {
    }

    public Label(String text) {
        this.setLabel(text);
    }

    protected void invalidate() {
        this.lines = null;
        super.invalidate();
    }

    public String getLabel() {
        return this.text;
    }

    public synchronized void setLabel(String text) {
        this.text = text;
        this.invalidate();
    }

    public Font getFont() {
        return this.font;
    }

    private Font getFont(Theme theme) {
        if (this.font != null) {
            return this.font;
        }
        return theme.getFont();
    }

    public synchronized void setFont(Font font) {
        this.font = font;
        this.invalidate();
    }

    public int getFontColor() {
        return this.fontColor;
    }

    private int getFontColor(Theme theme) {
        if (this.fontColor >= 0) {
            return this.fontColor;
        }
        return theme.getFontColor();
    }

    public void setFontColor(int color) {
        this.fontColor = color;
    }

    protected synchronized void paintComponent(Graphics g, Theme theme, int width, int height, boolean selected) {
        if (this.text != null) {
            Font font = this.getFont(theme);
            g.setFont(font);
            int fontColor = this.getFontColor(theme);
            g.setColor(fontColor);
            int fontHeight = font.getHeight();
            int paragraphSpacing = fontHeight / 2;
            int y = 0;
            int horizontalAlignment = this.getHorizontalAlignment();
            int anchor = horizontalAlignment | 0x10;
            int x = horizontalAlignment == 4 ? 0 : (horizontalAlignment == 1 ? width / 2 : width);
            if (this.lines == null || this.widthForLines != width) {
                this.lines = Label.breakIntoLines(font, this.text, width);
                this.widthForLines = width;
            }
            int clipTop = g.getClipY();
            int clipBottom = clipTop + g.getClipHeight();
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null) {
                    y += paragraphSpacing;
                    continue;
                }
                if (y + fontHeight >= clipTop && y <= clipBottom) {
                    g.drawString(this.lines[i], x, y, anchor);
                }
                y += fontHeight;
            }
            this.height = y;
        }
    }

    protected int[] getPreferredComponentSize(Theme theme, int viewportWidth, int viewportHeight) {
        int width = 0;
        this.height = 0;
        if (this.text != null) {
            Font font = this.getFont(theme);
            if (this.lines == null || this.widthForLines != viewportWidth) {
                this.lines = Label.breakIntoLines(font, this.text, viewportWidth);
                this.widthForLines = viewportWidth;
            }
            int fontHeight = font.getHeight();
            int paragraphSpacing = fontHeight / 2;
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null) {
                    this.height += paragraphSpacing;
                    continue;
                }
                int lineWidth = font.stringWidth(this.lines[i]);
                if (lineWidth > width) {
                    width = lineWidth;
                }
                this.height += fontHeight;
            }
        }
        return new int[]{width, this.height};
    }

    public int getHeight() {
        if (this.lines == null) {
            return super.getHeight();
        }
        return this.height;
    }

    public static String[] breakIntoLines(Font font, String string, int width) {
        String[] lines = null;
        if (string != null) {
            String newLine;
            Vector<String> parsedLines = new Vector<String>();
            int lineStart = 0;
            int lastBreakableSpot = 0;
            int lastNonWhiteSpace = 0;
            int charWidth = font.charWidth('O');
            width -= charWidth;
            char[] chars = string.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                boolean isSeparator = chars[i] == '-' || chars[i] == '/';
                boolean isWhiteSpace = chars[i] == ' ';
                boolean isNewLine = chars[i] == '\n';
                boolean isCarrageReturn = chars[i] == '\r';
                boolean isLineBreak = isNewLine || isCarrageReturn;
                int lineWidth = font.charsWidth(chars, lineStart, i - lineStart);
                if (isLineBreak || lineWidth > width) {
                    int lineEnd = isLineBreak ? i : (lastBreakableSpot > lineStart ? lastBreakableSpot : i - 1);
                    newLine = string.substring(lineStart, lineEnd).trim();
                    parsedLines.addElement(newLine);
                    if (isLineBreak) {
                        lineStart = lineEnd + 1;
                        if (isNewLine) {
                            parsedLines.addElement(null);
                        }
                    } else {
                        lineStart = lineEnd;
                    }
                }
                if (isSeparator) {
                    lastBreakableSpot = i + 1;
                }
                if (isWhiteSpace) {
                    lastBreakableSpot = lastNonWhiteSpace + 1;
                    continue;
                }
                lastNonWhiteSpace = i;
            }
            newLine = string.substring(lineStart).trim();
            parsedLines.addElement(newLine);
            lines = new String[parsedLines.size()];
            Enumeration e = parsedLines.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                lines[i++] = (String)e.nextElement();
            }
        }
        return lines;
    }
}

