/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Menu;
import org.j4me.ui.MenuItem;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;

public class MenuOption
extends Component {
    private static final int HORIZONTAL_MARGIN = 3;
    private static final int VERTICAL_MARGIN = 3;
    private final MenuItem menuItem;
    private final DeviceScreen screen;
    private String screenText;
    private final Label text = new Label();
    private boolean submenu = false;

    public MenuOption(MenuItem choice) {
        if (choice == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        if (choice.getText() == null) {
            throw new IllegalArgumentException("choice text cannot be null");
        }
        this.menuItem = choice;
        this.screen = null;
    }

    public MenuOption(DeviceScreen choice) {
        if (choice == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        this.menuItem = null;
        this.screen = choice;
    }

    public MenuOption(String text, DeviceScreen choice) {
        if (choice == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        this.menuItem = null;
        this.screen = choice;
        this.screenText = text;
    }

    public MenuOption(Menu choice, boolean submenu) {
        this(choice);
        this.submenu = submenu;
    }

    public boolean isSubmenu() {
        return this.submenu;
    }

    public void setLabel(String label) {
        this.screenText = label;
        this.invalidate();
    }

    public String getLabel() {
        if (this.screenText != null) {
            return this.screenText;
        }
        String label = this.menuItem != null ? this.menuItem.getText() : this.screen.getTitle();
        if (label == null) {
            label = "";
        }
        return label;
    }

    public void select() {
        if (this.menuItem != null) {
            this.menuItem.onSelection();
        } else {
            this.screen.show();
        }
    }

    protected void showNotify() {
        this.text.visible(true);
        super.showNotify();
    }

    protected void hideNotify() {
        this.text.visible(false);
        super.hideNotify();
    }

    protected void paintComponent(Graphics g, Theme theme, int width, int height, boolean selected) {
        int backgroundColor = selected ? theme.getHighlightColor() : theme.getBackgroundColor();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, width, height);
        int[] submenuDimensions = this.getSubmenuIndicatorSize(theme, width, height);
        int textWidth = width - 9 - submenuDimensions[0];
        int[] textDimensions = this.getPreferredTextSize(theme, textWidth, height);
        int textHeight = textDimensions[1];
        int textTop = (height - textHeight) / 2;
        int textLeft = 3;
        this.paintText(g, theme, textLeft, textTop, textWidth, textHeight, selected);
        if (this.submenu) {
            int arrowHeight = submenuDimensions[1];
            if (arrowHeight % 2 == 0) {
                --arrowHeight;
            }
            int arrowWidth = submenuDimensions[0];
            int arrowX = width - 3 - arrowWidth;
            int arrowY = (height - arrowHeight) / 2;
            int arrowColor = selected ? theme.getMenuFontColor() : theme.getFontColor();
            g.setColor(arrowColor);
            g.fillTriangle(arrowX, arrowY, arrowX, arrowY + arrowHeight, arrowX + arrowWidth, arrowY + arrowHeight / 2 + 1);
        }
    }

    protected void paintText(Graphics g, Theme theme, int x, int y, int width, int height, boolean selected) {
        int fontColor = selected ? theme.getBackgroundColor() : theme.getFontColor();
        this.text.setFontColor(fontColor);
        this.text.paint(g, theme, this.getScreen(), x, y, width, height, selected);
    }

    protected int[] getPreferredComponentSize(Theme theme, int viewportWidth, int viewportHeight) {
        int[] submenuDimensions = this.getSubmenuIndicatorSize(theme, viewportWidth, viewportHeight);
        int textWidth = viewportWidth - 9 - submenuDimensions[0];
        int[] textDimensions = this.getPreferredTextSize(theme, textWidth, viewportHeight);
        int height = Math.max(textDimensions[1], submenuDimensions[1]);
        return new int[]{viewportWidth, height += 6};
    }

    protected int[] getPreferredTextSize(Theme theme, int viewportWidth, int viewportHeight) {
        this.text.setLabel(this.getLabel());
        return this.text.getPreferredSize(theme, viewportWidth, viewportHeight);
    }

    protected int[] getSubmenuIndicatorSize(Theme theme, int viewportWidth, int viewportHeight) {
        Font textFont = theme.getFont();
        int arrowHeight = textFont.getHeight() * 4 / 5;
        if (arrowHeight % 2 == 0) {
            --arrowHeight;
        }
        int arrowWidth = arrowHeight / 2;
        return new int[]{arrowWidth, arrowHeight};
    }

    public boolean acceptsInput() {
        return true;
    }

    public void keyPressed(int key) {
        if (key == -8) {
            this.select();
        }
        super.keyPressed(key);
    }

    public void pointerPressed(int x, int y) {
        this.select();
        super.pointerPressed(x, y);
    }
}

