/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.util.MathFunc;

public class Theme {
    public static final int BLACK = 0;
    public static final int BROWN = 0x804000;
    public static final int BLUE = 255;
    public static final int NAVY = 128;
    public static final int NEON_BLUE = 0x4DFFFF;
    public static final int LIGHT_BLUE = 33023;
    public static final int RED = 0xFF0000;
    public static final int MAROON = 0x802020;
    public static final int LIGHT_RED = 0xFF5050;
    public static final int MAGENTA = 0xFF28FF;
    public static final int ORANGE = 0xFF8000;
    public static final int BURNT_ORANGE = 0xD07000;
    public static final int YELLOW = 0xFFFF00;
    public static final int GREEN = 0x66FF33;
    public static final int MEDIUM_GREEN = 42752;
    public static final int LIGHT_GREEN = 3194912;
    public static final int DARK_GREEN = 2048813;
    public static final int FOREST_GREEN = 0x33773A;
    public static final int BLUE_GREEN = 32896;
    public static final int CYAN = 0x33FFFF;
    public static final int SILVER = 0xC0C0C0;
    public static final int GRAY = 0x808080;
    public static final int LIGHT_GRAY = 0xC0C0C0;
    public static final int LAVENDAR = 15132410;
    public static final int WHITE = 0xFFFFFF;
    private static final double TITLE_BAR_SECONDARY_COLOR_MAX = 0.6;
    private static final double MENU_BAR_SECONDARY_COLOR_MAX = 0.1;
    private static final double SCROLLBAR_SECONDARY_COLOR_MAX = 0.8;
    private static final int SCROLLBAR_WIDTH = 6;
    private final Font defaultFont;
    private final Font menuFont;
    private final Font titleFont;

    public Theme() {
        Font base = Font.getDefaultFont();
        int face = base.getFace();
        int size = base.getSize();
        this.defaultFont = Font.getFont((int)face, (int)0, (int)size);
        this.menuFont = Font.getFont((int)face, (int)0, (int)size);
        this.titleFont = Font.getFont((int)face, (int)1, (int)size);
    }

    public Font getFont() {
        return this.defaultFont;
    }

    public Font getMenuFont() {
        return this.menuFont;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public int getFontColor() {
        return 128;
    }

    public int getMenuFontColor() {
        return 0xFFFFFF;
    }

    public int getMenuFontHighlightColor() {
        return 0xC0C0C0;
    }

    public int getTitleFontColor() {
        return this.getMenuFontColor();
    }

    public int getBorderColor() {
        return 128;
    }

    public int getBackgroundColor() {
        return 0xFFFFFF;
    }

    public int getHighlightColor() {
        return 33023;
    }

    public int getTitleBarBorderColor() {
        return this.getMenuBarBorderColor();
    }

    public int getTitleBarBackgroundColor() {
        return this.getMenuBarBackgroundColor();
    }

    public int getTitleBarHighlightColor() {
        return this.getMenuBarHighlightColor();
    }

    public int getMenuBarBorderColor() {
        return this.getFontColor();
    }

    public int getMenuBarBackgroundColor() {
        return 128;
    }

    public int getMenuBarHighlightColor() {
        return 33023;
    }

    public int getTitleHeight() {
        return this.getTitleFont().getHeight() + 2;
    }

    public void paintTitleBar(Graphics g, String title, int width, int height) {
        this.paintTitleBarBackground(g, 0, 0, width, height);
        g.setColor(this.getTitleBarBorderColor());
        g.drawLine(0, height - 1, width, height - 1);
        g.setFont(this.getTitleFont());
        g.setColor(this.getTitleFontColor());
        g.drawString(title, width / 2, 1, 17);
    }

    protected void paintTitleBarBackground(Graphics g, int x, int y, int width, int height) {
        int primary = this.getTitleBarBackgroundColor();
        int secondary = this.getTitleBarHighlightColor();
        Theme.gradientFill(g, 0, 0, width, height, true, primary, secondary, 0.6);
    }

    public int getMenuHeight() {
        return this.getMenuFont().getHeight() + 2;
    }

    public void paintMenuBar(Graphics g, String left, boolean highlightLeft, String right, boolean highlightRight, int width, int height) {
        this.paintMenuBarBackground(g, 0, 0, width, height);
        g.setColor(this.getMenuBarBorderColor());
        g.drawLine(0, 0, width, 0);
        int normal = this.getMenuFontColor();
        int highlighted = this.getMenuFontHighlightColor();
        Font font = this.getMenuFont();
        g.setFont(font);
        int offset = font.charWidth(' ') / 2;
        g.setColor(highlightLeft ? highlighted : normal);
        g.drawString(left, offset, height, 36);
        g.setColor(highlightRight ? highlighted : normal);
        g.drawString(right, width - offset, height, 40);
    }

    protected void paintMenuBarBackground(Graphics g, int x, int y, int width, int height) {
        int primary = this.getMenuBarBackgroundColor();
        int secondary = this.getMenuBarHighlightColor();
        Theme.gradientFill(g, x, y, width, height, true, primary, secondary, 0.1);
    }

    public String getMenuTextForOK() {
        return "OK";
    }

    public String getMenuTextForCancel() {
        return "Cancel";
    }

    public void paintBackground(Graphics g) {
        int color = this.getBackgroundColor();
        int x = g.getClipX();
        int y = g.getClipY();
        int w = g.getClipWidth();
        int h = g.getClipHeight();
        g.setColor(color);
        g.fillRect(x, y, w, h);
    }

    public void paintVerticalScrollbar(Graphics g, int x, int y, int width, int height, int offset, int formHeight) {
        int scrollbarWidth = this.getVerticalScrollbarWidth();
        int left = x + width - scrollbarWidth;
        this.paintScrollbarBackground(g, left, y, scrollbarWidth, height);
        int border = this.getBorderColor();
        g.setColor(border);
        g.drawLine(left, y, left, y + height);
        int scrollableHeight = formHeight - height;
        double trackbarPercentage = (double)height / (double)formHeight;
        int trackbarHeight = (int)MathFunc.round((double)height * trackbarPercentage);
        trackbarHeight = Math.max(trackbarHeight, 2 * scrollbarWidth);
        int rangeStart = trackbarHeight / 2;
        int range = height - 2 * rangeStart;
        double offsetPercentage = (double)offset / (double)scrollableHeight;
        int center = y + rangeStart + (int)MathFunc.round(offsetPercentage * (double)range);
        this.paintTrackbar(g, left, center - rangeStart, scrollbarWidth, trackbarHeight);
    }

    protected void paintScrollbarBackground(Graphics g, int x, int y, int width, int height) {
        int primary = this.getScrollbarBackgroundColor();
        int secondary = this.getScrollbarHighlightColor();
        Theme.gradientFill(g, x, y, width, height, false, primary, secondary, 0.8);
    }

    protected void paintTrackbar(Graphics g, int x, int y, int width, int height) {
        int primary = this.getScrollbarTrackbarColor();
        int secondary = this.getScrollbarBorderColor();
        Theme.gradientFill(g, x, y, width, height, false, primary, secondary, 0.8);
    }

    public int getVerticalScrollbarWidth() {
        return 6;
    }

    public int getScrollbarBorderColor() {
        return this.getBorderColor();
    }

    public int getScrollbarBackgroundColor() {
        return this.getMenuBarBackgroundColor();
    }

    public int getScrollbarHighlightColor() {
        return this.getMenuFontHighlightColor();
    }

    public int getScrollbarTrackbarColor() {
        return this.getMenuBarHighlightColor();
    }

    public static void gradientFill(Graphics g, int x, int y, int width, int height, boolean fillVertically, int primaryColor, int secondaryColor, double maxSecondary) {
        int pr = (primaryColor & 0xFF0000) >> 16;
        int pg = (primaryColor & 0xFF00) >> 8;
        int pb = primaryColor & 0xFF;
        int sr = (secondaryColor & 0xFF0000) >> 16;
        int sg = (secondaryColor & 0xFF00) >> 8;
        int sb = secondaryColor & 0xFF;
        int end = fillVertically ? height : width;
        for (int i = 0; i < end; ++i) {
            double p = (double)i / (double)end;
            double v = Math.abs(maxSecondary - p);
            double v2 = 1.0 - v;
            int red = (int)((double)pr * v + (double)sr * v2);
            int green = (int)((double)pg * v + (double)sg * v2);
            int blue = (int)((double)pb * v + (double)sb * v2);
            g.setColor(red, green, blue);
            if (fillVertically) {
                g.drawLine(x, y + i, x + width, y + i);
                continue;
            }
            g.drawLine(x + i, y, x + i, y + height);
        }
    }
}

