/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;

public class ScaleDrawData
extends RangeDrawData {
    public int increment;
    public int pageIncrement;
    static final int TICS_MARGIN = 10;

    public ScaleDrawData() {
        this.state = new int[4];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = this.style;
            int n3 = this.minimum;
            int n4 = this.maximum;
            int n5 = this.selection;
            int n6 = this.pageIncrement;
            int n7 = OS.OpenThemeData(0, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rECT.left + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rECT.top + rectangle.height;
            SIZE sIZE = new SIZE();
            if ((n2 & 0x200) != 0) {
                int n8;
                OS.GetThemePartSize(n7, gC.handle, 2, 0, null, 1, sIZE);
                int n9 = sIZE.cx - 1;
                OS.GetThemePartSize(n7, gC.handle, 6, 0, null, 1, sIZE);
                int n10 = sIZE.cx;
                int n11 = sIZE.cy;
                OS.GetThemePartSize(n7, gC.handle, 9, 0, rECT, 1, sIZE);
                int n12 = sIZE.cx;
                int n13 = n8 = (n10 - n9) / 2;
                rECT.left += (n8 += 10);
                rECT.top += n13;
                rECT.right = rECT.left + n9;
                rECT.bottom -= n13;
                int n14 = rECT.bottom - rECT.top;
                OS.DrawThemeBackground(n7, gC.handle, 2, 0, rECT, null);
                rECT.top += (n14 - n11) * (n5 - n3) / Math.max(1, n4 - n3);
                rECT.left -= (n10 - n9) / 2;
                rECT.right = rECT.left + n10;
                rECT.bottom = rECT.top + n11;
                OS.DrawThemeBackground(n7, gC.handle, 6, 0, rECT, null);
                rECT.top = rectangle.y + n13 + n11 / 2;
                rECT.bottom = rECT.top + 1;
                int n15 = n3;
                while (n15 <= n4) {
                    rECT.left = rectangle.x + 5;
                    rECT.right = rECT.left + n12;
                    if (n15 != n3 && n15 != n4) {
                        ++rECT.left;
                    }
                    rECT.top = rectangle.y + n13 + n11 / 2;
                    rECT.top += (n14 - n11) * (n15 - n3) / Math.max(1, n4 - n3);
                    rECT.bottom = rECT.top + 1;
                    OS.DrawThemeBackground(n7, gC.handle, 10, 1, rECT, null);
                    gC.drawLine(rECT.left, rECT.top, rECT.right, rECT.top);
                    rECT.left = rectangle.x + 10 + n10 + 1;
                    rECT.right = rECT.left + n12;
                    if (n15 != n3 && n15 != n4) {
                        --rECT.right;
                    }
                    OS.DrawThemeBackground(n7, gC.handle, 10, 1, rECT, null);
                    gC.drawLine(rECT.left, rECT.top, rECT.right, rECT.top);
                    n15 += n6;
                }
            }
            OS.CloseThemeData(n7);
        }
    }

    char[] getClassId() {
        return TRACKBAR;
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

