/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.HashSet;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Util;
import org.lwjgl.opengl.a;
import org.lwjgl.opengl.e;
import org.lwjgl.opengl.l;
import org.lwjgl.opengl.m;
import org.lwjgl.opengl.q;
import org.lwjgl.opengl.u;
import org.lwjgl.opengl.y;
import org.lwjgl.opengl.z;

public final class Display {
    private static final Thread shutdown_hook = new e();
    private static final y display_impl;
    private static final DisplayMode initial_mode;
    private static DisplayMode current_mode;
    private static long timeNow;
    private static long timeThen;
    private static int x;
    private static ByteBuffer[] cached_icons;
    private static int y;
    private static String title;
    private static boolean fullscreen;
    private static int swap_interval;
    private static m peer_info;
    private static z context;
    private static boolean window_created;
    private static long timeLate;

    public static Drawable getDrawable() {
        if (context != null) {
            return new l();
        }
        return null;
    }

    private static y createDisplayImplementation() {
        String string;
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                string = "org.lwjgl.opengl.LinuxDisplay";
                break;
            }
            case 3: {
                string = "org.lwjgl.opengl.WindowsDisplay";
                break;
            }
            case 2: {
                string = "org.lwjgl.opengl.MacOSXDisplay";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported platform");
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (y)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    private Display() {
    }

    public static DisplayMode[] getAvailableDisplayModes() throws LWJGLException {
        DisplayMode[] displayModeArray = display_impl.getAvailableDisplayModes();
        if (displayModeArray == null) {
            return new DisplayMode[0];
        }
        HashSet<DisplayMode> hashSet = new HashSet<DisplayMode>(displayModeArray.length);
        hashSet.addAll(Arrays.asList(displayModeArray));
        DisplayMode[] displayModeArray2 = new DisplayMode[hashSet.size()];
        ((AbstractCollection)hashSet).toArray(displayModeArray2);
        LWJGLUtil.log("Removed " + (displayModeArray.length - displayModeArray2.length) + " duplicate displaymodes");
        return displayModeArray2;
    }

    public static DisplayMode getDisplayMode() {
        return current_mode;
    }

    public static void setDisplayMode(DisplayMode displayMode) throws LWJGLException {
        if (displayMode == null) {
            throw new NullPointerException("mode must be non-null");
        }
        current_mode = displayMode;
        if (Display.isCreated()) {
            Display.destroyWindow();
            if (!displayMode.isFullscreen()) {
                Display.resetFullscreen();
            }
            try {
                if (fullscreen) {
                    Display.switchDisplayMode();
                }
                Display.createWindow();
                Display.makeCurrent();
                return;
            }
            catch (LWJGLException lWJGLException) {
                Display.destroyContext();
                Display.destroyPeerInfo();
                display_impl.resetDisplayMode();
                throw lWJGLException;
            }
        }
    }

    private static void createWindow() throws LWJGLException {
        int n2;
        int n3;
        if (window_created) {
            return;
        }
        if (!fullscreen) {
            if (x == -1 && y == -1) {
                n3 = Math.max(0, (initial_mode.getWidth() - current_mode.getWidth()) / 2);
                n2 = Math.max(0, (initial_mode.getHeight() - current_mode.getHeight()) / 2);
            } else {
                n3 = x;
                n2 = y;
            }
        } else {
            n3 = 0;
            n2 = 0;
        }
        int n4 = n2;
        display_impl.createWindow(current_mode, fullscreen, n3, n4);
        window_created = true;
        Display.setTitle(title);
        Display.initControls();
    }

    private static void destroyWindow() {
        if (!window_created) {
            return;
        }
        try {
            if (context.a()) {
                context.b();
                z.a();
            }
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Exception occurred while trying to release context: " + lWJGLException);
        }
        display_impl.destroyWindow();
        window_created = false;
    }

    private static void switchDisplayMode() throws LWJGLException {
        if (!current_mode.isFullscreen()) {
            System.out.println("Switching to " + initial_mode);
            Display.setDisplayMode(initial_mode);
        }
        display_impl.switchDisplayMode(current_mode);
    }

    public static void setDisplayConfiguration(float f2, float f3, float f4) throws LWJGLException {
        if (!Display.isCreated()) {
            throw new LWJGLException("Display not yet created.");
        }
        if (f3 < -1.0f || f3 > 1.0f) {
            throw new IllegalArgumentException("Invalid brightness value");
        }
        if (f4 < 0.0f) {
            throw new IllegalArgumentException("Invalid contrast value");
        }
        int n2 = display_impl.getGammaRampLength();
        if (n2 == 0) {
            throw new LWJGLException("Display configuration not supported");
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            float f5;
            block10: {
                float f6;
                block9: {
                    block8: {
                        float f7;
                        float f8 = (float)i2 / (float)(n2 - 1);
                        f5 = (float)Math.pow(f8, f2);
                        f5 += f3;
                        f5 = (f5 - 0.5f) * f4 + 0.5f;
                        if (!(f7 > 1.0f)) break block8;
                        f6 = 1.0f;
                        break block9;
                    }
                    if (!(f5 < 0.0f)) break block10;
                    f6 = 0.0f;
                }
                f5 = f6;
            }
            floatBuffer.put(i2, f5);
        }
        display_impl.setGammaRamp(floatBuffer);
        LWJGLUtil.log("Gamma set, gamma = " + f2 + ", brightness = " + f3 + ", contrast = " + f4);
    }

    public static void sync3(int n2) {
        float f2 = 1.0f / (float)(n2 > 1 ? n2 - 1 : 1);
        while ((timeNow = Sys.getTime()) > timeThen && (float)(timeNow - timeThen) / (float)Sys.getTimerResolution() < f2) {
            Thread.yield();
        }
        timeThen = timeNow;
    }

    public static void sync2(int n2) {
        long l2 = Sys.getTimerResolution() / (long)n2 + timeThen;
        while (l2 > (timeNow = Sys.getTime()) + timeLate) {
            Thread.yield();
        }
        timeLate = l2 < timeNow ? timeNow - l2 : 0L;
        timeThen = timeNow;
    }

    public static void sync(int n2) {
        long l2 = Sys.getTimerResolution() / (long)n2 + timeThen;
        timeNow = Sys.getTime();
        while (l2 > timeNow + timeLate) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
            timeNow = Sys.getTime();
        }
        timeLate = l2 < timeNow ? timeNow - l2 : 0L;
        timeThen = timeNow;
    }

    public static String getTitle() {
        return title;
    }

    private static void resetFullscreen() {
        if (fullscreen) {
            fullscreen = false;
            display_impl.resetDisplayMode();
        }
    }

    public static void setFullscreen(boolean bl2) throws LWJGLException {
        if (fullscreen != bl2) {
            fullscreen = bl2;
            if (!Display.isCreated()) {
                return;
            }
            Display.destroyWindow();
            try {
                if (bl2) {
                    Display.switchDisplayMode();
                } else {
                    display_impl.resetDisplayMode();
                }
                Display.createWindow();
                Display.makeCurrent();
                return;
            }
            catch (LWJGLException lWJGLException) {
                Display.destroyContext();
                Display.destroyPeerInfo();
                display_impl.resetDisplayMode();
                throw lWJGLException;
            }
        }
    }

    public static boolean isFullscreen() {
        return fullscreen;
    }

    public static void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        title = string;
        if (Display.isCreated()) {
            display_impl.setTitle(title);
        }
    }

    public static boolean isCloseRequested() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine close requested state of uncreated window");
        }
        display_impl.update();
        return display_impl.isCloseRequested();
    }

    public static boolean isVisible() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine minimized state of uncreated window");
        }
        display_impl.update();
        return display_impl.isVisible();
    }

    public static boolean isActive() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine focused state of uncreated window");
        }
        display_impl.update();
        return display_impl.isActive();
    }

    public static boolean isDirty() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine dirty state of uncreated window");
        }
        display_impl.update();
        return display_impl.isDirty();
    }

    public static void processMessages() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display not created");
        }
        display_impl.update();
    }

    public static void swapBuffers() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display not created");
        }
        Util.checkGLError();
        z.d();
    }

    public static void update() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display not created");
        }
        if (Display.isVisible() || Display.isDirty()) {
            try {
                Display.swapBuffers();
            }
            catch (LWJGLException lWJGLException) {
                throw new RuntimeException(lWJGLException);
            }
        }
        Display.processMessages();
        Display.pollDevices();
    }

    static void pollDevices() {
    }

    public static void releaseContext() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display is not created");
        }
        if (context.a()) {
            z.a();
        }
    }

    public static void makeCurrent() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display is not created");
        }
        context.e();
    }

    public static void create() throws LWJGLException {
        Display.create(new PixelFormat());
    }

    public static void create(PixelFormat pixelFormat) throws LWJGLException {
        Display.create(pixelFormat, null);
    }

    public static void create(PixelFormat pixelFormat, Drawable drawable) throws LWJGLException {
        if (Display.isCreated()) {
            throw new IllegalStateException("Only one LWJGL context may be instantiated at any one time.");
        }
        if (pixelFormat == null) {
            throw new NullPointerException("pixel_format cannot be null");
        }
        AccessController.doPrivileged(new q());
        if (fullscreen) {
            Display.switchDisplayMode();
        }
        try {
            peer_info = display_impl.createPeerInfo(pixelFormat);
            try {
                Display.createWindow();
                try {
                    context = new z(peer_info, drawable != null ? drawable.getContext() : null);
                    try {
                        Display.makeCurrent();
                        Display.initContext();
                    }
                    catch (LWJGLException lWJGLException) {
                        Display.destroyContext();
                        throw lWJGLException;
                    }
                }
                catch (LWJGLException lWJGLException) {
                    Display.destroyWindow();
                    throw lWJGLException;
                }
            }
            catch (LWJGLException lWJGLException) {
                Display.destroyPeerInfo();
                throw lWJGLException;
            }
        }
        catch (LWJGLException lWJGLException) {
            display_impl.resetDisplayMode();
            throw lWJGLException;
        }
    }

    private static void initContext() {
        Display.setSwapInterval(swap_interval);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, current_mode.getWidth(), 0.0, current_mode.getHeight(), -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, current_mode.getWidth(), current_mode.getHeight());
    }

    static y getImplementation() {
        return display_impl;
    }

    static boolean getPrivilegedBoolean(String string) {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new u(string));
        return bl2;
    }

    private static void initControls() {
    }

    public static void destroy() {
        if (!Display.isCreated()) {
            return;
        }
        Display.destroyWindow();
        Display.destroyContext();
        Display.destroyPeerInfo();
        y = -1;
        x = -1;
        cached_icons = null;
        Display.reset();
        AccessController.doPrivileged(new a());
    }

    private static void destroyPeerInfo() {
        peer_info.a();
        peer_info = null;
    }

    private static void destroyContext() {
        try {
            context.f();
            return;
        }
        catch (LWJGLException lWJGLException) {
            throw new RuntimeException(lWJGLException);
        }
        finally {
            context = null;
        }
    }

    private static void reset() {
        display_impl.resetDisplayMode();
        current_mode = initial_mode;
    }

    public static z getContext() {
        return context;
    }

    public static boolean isCreated() {
        return window_created;
    }

    public static void setSwapInterval(int n2) {
        swap_interval = n2;
        if (Display.isCreated()) {
            z.a(swap_interval);
        }
    }

    public static void setVSyncEnabled(boolean bl2) {
        Display.setSwapInterval(bl2 ? 1 : 0);
    }

    public static void setLocation(int n2, int n3) {
        if (fullscreen) {
            return;
        }
        if (Display.isCreated()) {
            display_impl.reshape(n2, n3, current_mode.getWidth(), current_mode.getHeight());
        }
        x = n2;
        y = n3;
    }

    public static String getAdapter() {
        return display_impl.getAdapter();
    }

    public static String getVersion() {
        return display_impl.getVersion();
    }

    public static int setIcon(ByteBuffer[] byteBufferArray) {
        if (cached_icons != byteBufferArray) {
            cached_icons = new ByteBuffer[byteBufferArray.length];
            for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
                Display.cached_icons[i2] = BufferUtils.createByteBuffer(byteBufferArray[i2].capacity());
                cached_icons[i2].put(byteBufferArray[i2]);
                ((Buffer)cached_icons[i2]).flip();
            }
        }
        if (Display.isCreated()) {
            return display_impl.setIcon(cached_icons);
        }
        return 0;
    }

    static void access$000() {
        Display.reset();
    }

    static z access$100() {
        return context;
    }

    static Thread access$200() {
        return shutdown_hook;
    }

    static {
        x = -1;
        y = -1;
        title = "Game";
        window_created = false;
        Sys.initialize();
        display_impl = Display.createDisplayImplementation();
        try {
            current_mode = initial_mode = display_impl.init();
            LWJGLUtil.log("Initial mode: " + initial_mode);
            return;
        }
        catch (LWJGLException lWJGLException) {
            throw new RuntimeException(lWJGLException);
        }
    }
}

