/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableTree
extends Composite {
    Table table;
    TableTreeItem[] items = EMPTY_ITEMS;
    Image plusImage;
    Image minusImage;
    Image sizeImage;
    boolean inDispose = false;
    static final TableTreeItem[] EMPTY_ITEMS = new TableTreeItem[0];
    static final String[] EMPTY_TEXTS = new String[0];
    static final Image[] EMPTY_IMAGES = new Image[0];
    static final String ITEMID = "TableTreeItemID";

    public TableTree(Composite composite, int n2) {
        super(composite, TableTree.checkStyle(n2));
        this.table = new Table(this, n2);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        TableTree.this.onMouseDown(event);
                        break;
                    }
                    case 13: {
                        TableTree.this.onSelection(event);
                        break;
                    }
                    case 14: {
                        TableTree.this.onSelection(event);
                        break;
                    }
                    case 1: {
                        TableTree.this.onKeyDown(event);
                    }
                }
            }
        };
        int[] nArray = new int[]{3, 13, 14, 1};
        int n3 = 0;
        while (n3 < nArray.length) {
            this.table.addListener(nArray[n3], listener);
            ++n3;
        }
        Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        TableTree.this.onDispose(event);
                        break;
                    }
                    case 11: {
                        TableTree.this.onResize(event);
                        break;
                    }
                    case 15: {
                        TableTree.this.onFocusIn(event);
                    }
                }
            }
        };
        int[] nArray2 = new int[]{12, 11, 15};
        int n4 = 0;
        while (n4 < nArray2.length) {
            this.addListener(nArray2[n4], listener2);
            ++n4;
        }
    }

    int addItem(TableTreeItem tableTreeItem, int n2) {
        if (n2 < 0 || n2 > this.items.length) {
            SWT.error(5);
        }
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, n2);
        tableTreeItemArray[n2] = tableTreeItem;
        System.arraycopy(this.items, n2, tableTreeItemArray, n2 + 1, this.items.length - n2);
        this.items = tableTreeItemArray;
        if (n2 == this.items.length - 1) {
            return this.table.getItemCount();
        }
        return this.table.indexOf(this.items[n2 + 1].tableItem);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    private static int checkStyle(int n2) {
        int n3 = 0x6000000;
        return n2 &= n3;
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        return this.table.computeSize(n2, n3, bl2);
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        return this.table.computeTrim(n2, n3, n4, n5);
    }

    public void deselectAll() {
        this.checkWidget();
        this.table.deselectAll();
    }

    void expandItem(TableTreeItem tableTreeItem) {
        if (tableTreeItem == null) {
            return;
        }
        this.expandItem(tableTreeItem.parentItem);
        if (!tableTreeItem.getVisible()) {
            tableTreeItem.setVisible(true);
        }
        if (!tableTreeItem.expanded && tableTreeItem.items.length > 0) {
            tableTreeItem.setExpanded(true);
            Event event = new Event();
            event.item = tableTreeItem;
            this.notifyListeners(17, event);
        }
    }

    public Color getBackground() {
        return this.table.getBackground();
    }

    public Rectangle getClientArea() {
        return this.table.getClientArea();
    }

    public Color getForeground() {
        return this.table.getForeground();
    }

    public Font getFont() {
        return this.table.getFont();
    }

    public int getItemCount() {
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.table.getItemHeight();
    }

    public TableTreeItem[] getItems() {
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, this.items.length);
        return tableTreeItemArray;
    }

    public TableTreeItem[] getSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = this.table.getSelection();
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[tableItemArray.length];
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            tableTreeItemArray[n2] = (TableTreeItem)tableItemArray[n2].getData(ITEMID);
            ++n2;
        }
        return tableTreeItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.table.getSelectionCount();
    }

    public int getStyle() {
        this.checkWidget();
        return this.table.getStyle();
    }

    public Table getTable() {
        return this.table;
    }

    void createImages() {
        int n2 = this.sizeImage.getBounds().height;
        int n3 = Math.min(6, (n2 - 9) / 2);
        n3 = Math.max(0, n3);
        int n4 = Math.max(10, n2 - 2 * n3);
        n4 = (n4 + 1) / 2 * 2;
        int n5 = n3 + n4 / 2;
        Color color = this.getForeground();
        Color color2 = this.getDisplay().getSystemColor(18);
        Color color3 = this.getBackground();
        PaletteData paletteData = new PaletteData(new RGB[]{color.getRGB(), color3.getRGB(), color2.getRGB()});
        ImageData imageData = new ImageData(n2, n2, 4, paletteData);
        imageData.transparentPixel = 1;
        this.plusImage = new Image((Device)this.getDisplay(), imageData);
        GC gC = new GC(this.plusImage);
        gC.setBackground(color3);
        gC.fillRectangle(0, 0, n2, n2);
        gC.setForeground(color2);
        gC.drawRectangle(n3, n3, n4, n4);
        gC.setForeground(color);
        gC.drawLine(n5, n3 + 2, n5, n3 + n4 - 2);
        gC.drawLine(n3 + 2, n5, n3 + n4 - 2, n5);
        gC.dispose();
        paletteData = new PaletteData(new RGB[]{color.getRGB(), color3.getRGB(), color2.getRGB()});
        imageData = new ImageData(n2, n2, 4, paletteData);
        imageData.transparentPixel = 1;
        this.minusImage = new Image((Device)this.getDisplay(), imageData);
        gC = new GC(this.minusImage);
        gC.setBackground(color3);
        gC.fillRectangle(0, 0, n2, n2);
        gC.setForeground(color2);
        gC.drawRectangle(n3, n3, n4, n4);
        gC.setForeground(color);
        gC.drawLine(n3 + 2, n5, n3 + n4 - 2, n5);
        gC.dispose();
    }

    Image getPlusImage() {
        if (this.plusImage == null) {
            this.createImages();
        }
        return this.plusImage;
    }

    Image getMinusImage() {
        if (this.minusImage == null) {
            this.createImages();
        }
        return this.minusImage;
    }

    public int indexOf(TableTreeItem tableTreeItem) {
        int n2 = 0;
        while (n2 < this.items.length) {
            if (tableTreeItem == this.items[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void onDispose(Event event) {
        this.inDispose = true;
        int n2 = 0;
        while (n2 < this.items.length) {
            this.items[n2].dispose();
            ++n2;
        }
        this.inDispose = false;
        if (this.plusImage != null) {
            this.plusImage.dispose();
        }
        if (this.minusImage != null) {
            this.minusImage.dispose();
        }
        if (this.sizeImage != null) {
            this.sizeImage.dispose();
        }
        this.sizeImage = null;
        this.minusImage = null;
        this.plusImage = null;
    }

    void onResize(Event event) {
        Point point = this.getSize();
        this.table.setBounds(0, 0, point.x, point.y);
    }

    void onSelection(Event event) {
        Event event2 = new Event();
        TableItem tableItem = (TableItem)event.item;
        TableTreeItem tableTreeItem = this.getItem(tableItem);
        event2.item = tableTreeItem;
        if (event.type == 13 && event.detail == 32 && tableTreeItem != null) {
            event2.detail = 32;
            tableTreeItem.checked = tableItem.getChecked();
        }
        this.notifyListeners(event.type, event2);
    }

    public TableTreeItem getItem(int n2) {
        this.checkWidget();
        int n3 = this.items.length;
        if (n2 < 0 || n2 >= n3) {
            SWT.error(6);
        }
        return this.items[n2];
    }

    public TableTreeItem getItem(Point point) {
        this.checkWidget();
        TableItem tableItem = this.table.getItem(point);
        if (tableItem == null) {
            return null;
        }
        return this.getItem(tableItem);
    }

    TableTreeItem getItem(TableItem tableItem) {
        if (tableItem == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.items.length) {
            TableTreeItem tableTreeItem = this.items[n2].getItem(tableItem);
            if (tableTreeItem != null) {
                return tableTreeItem;
            }
            ++n2;
        }
        return null;
    }

    void onFocusIn(Event event) {
        this.table.setFocus();
    }

    void onKeyDown(Event event) {
        TableTreeItem[] tableTreeItemArray = this.getSelection();
        if (tableTreeItemArray.length == 0) {
            return;
        }
        TableTreeItem tableTreeItem = tableTreeItemArray[0];
        int n2 = 0;
        if (event.keyCode == 0x1000004 || event.keyCode == 0x1000003) {
            int n3;
            int n4 = n3 = (this.getStyle() & 0x8000000) != 0 ? 0x1000003 : 0x1000004;
            if (event.keyCode == n3) {
                if (tableTreeItem.getItemCount() == 0) {
                    return;
                }
                if (tableTreeItem.getExpanded()) {
                    TableTreeItem tableTreeItem2 = tableTreeItem.getItems()[0];
                    this.table.setSelection(new TableItem[]{tableTreeItem2.tableItem});
                    this.showItem(tableTreeItem2);
                    n2 = 13;
                } else {
                    tableTreeItem.setExpanded(true);
                    n2 = 17;
                }
            } else if (tableTreeItem.getExpanded()) {
                tableTreeItem.setExpanded(false);
                n2 = 18;
            } else {
                TableTreeItem tableTreeItem3 = tableTreeItem.getParentItem();
                if (tableTreeItem3 != null) {
                    int n5 = tableTreeItem3.indexOf(tableTreeItem);
                    if (n5 != 0) {
                        return;
                    }
                    this.table.setSelection(new TableItem[]{tableTreeItem3.tableItem});
                    n2 = 13;
                }
            }
        }
        if (event.character == '*') {
            tableTreeItem.expandAll(true);
        }
        if (event.character == '-' && tableTreeItem.getExpanded()) {
            tableTreeItem.setExpanded(false);
            n2 = 18;
        }
        if (event.character == '+' && tableTreeItem.getItemCount() > 0 && !tableTreeItem.getExpanded()) {
            tableTreeItem.setExpanded(true);
            n2 = 17;
        }
        if (n2 == 0) {
            return;
        }
        Event event2 = new Event();
        event2.item = tableTreeItem;
        this.notifyListeners(n2, event2);
    }

    void onMouseDown(Event event) {
        TableItem[] tableItemArray = this.table.getItems();
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            Rectangle rectangle = tableItemArray[n2].getImageBounds(0);
            if (rectangle.contains(event.x, event.y)) {
                TableTreeItem tableTreeItem = (TableTreeItem)tableItemArray[n2].getData(ITEMID);
                event = new Event();
                event.item = tableTreeItem;
                tableTreeItem.setExpanded(!tableTreeItem.getExpanded());
                if (tableTreeItem.getExpanded()) {
                    this.notifyListeners(17, event);
                } else {
                    this.notifyListeners(18, event);
                }
                return;
            }
            ++n2;
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.setRedraw(false);
        int n2 = this.items.length - 1;
        while (n2 >= 0) {
            this.items[n2].dispose();
            --n2;
        }
        this.items = EMPTY_ITEMS;
        this.setRedraw(true);
    }

    void removeItem(TableTreeItem tableTreeItem) {
        int n2 = 0;
        while (n2 < this.items.length && this.items[n2] != tableTreeItem) {
            ++n2;
        }
        if (n2 == this.items.length) {
            return;
        }
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length - 1];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, n2);
        System.arraycopy(this.items, n2 + 1, tableTreeItemArray, n2, this.items.length - n2 - 1);
        this.items = tableTreeItemArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            SWT.error(4);
        }
        this.removeListener(17, treeListener);
        this.removeListener(18, treeListener);
    }

    public void selectAll() {
        this.checkWidget();
        this.table.selectAll();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.table.setBackground(color);
        if (this.sizeImage != null) {
            GC gC = new GC(this.sizeImage);
            gC.setBackground(this.getBackground());
            Rectangle rectangle = this.sizeImage.getBounds();
            gC.fillRectangle(rectangle);
            gC.dispose();
        }
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        this.table.setEnabled(bl2);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.table.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.table.setForeground(color);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.table.setMenu(menu);
    }

    public void setSelection(TableTreeItem[] tableTreeItemArray) {
        int n2;
        this.checkWidget();
        if (tableTreeItemArray == null) {
            SWT.error(4);
        }
        if ((n2 = tableTreeItemArray.length) == 0 || (this.table.getStyle() & 4) != 0 && n2 > 1) {
            this.deselectAll();
            return;
        }
        TableItem[] tableItemArray = new TableItem[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (tableTreeItemArray[n3] == null) {
                SWT.error(4);
            }
            if (!tableTreeItemArray[n3].getVisible()) {
                this.expandItem(tableTreeItemArray[n3]);
            }
            tableItemArray[n3] = tableTreeItemArray[n3].tableItem;
            ++n3;
        }
        this.table.setSelection(tableItemArray);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.table.setToolTipText(string);
    }

    public void showItem(TableTreeItem tableTreeItem) {
        this.checkWidget();
        if (tableTreeItem == null) {
            SWT.error(4);
        }
        if (!tableTreeItem.getVisible()) {
            this.expandItem(tableTreeItem);
        }
        TableItem tableItem = tableTreeItem.tableItem;
        this.table.showItem(tableItem);
    }

    public void showSelection() {
        this.checkWidget();
        this.table.showSelection();
    }
}

