/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.CreateRectRgn(0, 0, 0, 0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    Region(Device device, int n2) {
        this.device = device;
        this.handle = n2;
    }

    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n2 = OS.CreatePolygonRgn(nArray, nArray.length / 2, 1);
        OS.CombineRgn(this.handle, this.handle, n2, 2);
        OS.DeleteObject(n2);
    }

    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void add(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        int n6 = OS.CreateRectRgn(n2, n3, n2 + n4, n3 + n5);
        OS.CombineRgn(this.handle, this.handle, n6, 2);
        OS.DeleteObject(n6);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.CombineRgn(this.handle, this.handle, region.handle, 2);
    }

    public boolean contains(int n2, int n3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.PtInRegion(this.handle, n2, n3);
    }

    public boolean contains(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.DeleteObject(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RECT rECT = new RECT();
        OS.GetRgnBox(this.handle, rECT);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void intersect(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        int n6 = OS.CreateRectRgn(n2, n3, n2 + n4, n3 + n5);
        OS.CombineRgn(this.handle, this.handle, n6, 1);
        OS.DeleteObject(n6);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.CombineRgn(this.handle, this.handle, region.handle, 1);
    }

    public boolean intersects(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        return OS.RectInRegion(this.handle, rECT);
    }

    public boolean intersects(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        RECT rECT;
        int n2;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((n2 = OS.GetRgnBox(this.handle, rECT = new RECT())) == 1) {
            return true;
        }
        return rECT.right - rECT.left <= 0 || rECT.bottom - rECT.top <= 0;
    }

    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n2 = OS.CreatePolygonRgn(nArray, nArray.length / 2, 1);
        OS.CombineRgn(this.handle, this.handle, n2, 4);
        OS.DeleteObject(n2);
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void subtract(int n2, int n3, int n4, int n5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n4 < 0 || n5 < 0) {
            SWT.error(5);
        }
        int n6 = OS.CreateRectRgn(n2, n3, n2 + n4, n3 + n5);
        OS.CombineRgn(this.handle, this.handle, n6, 4);
        OS.DeleteObject(n6);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.CombineRgn(this.handle, this.handle, region.handle, 4);
    }

    public void translate(int n2, int n3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.OffsetRgn(this.handle, n2, n3);
    }

    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        this.translate(point.x, point.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }

    public static Region win32_new(Device device, int n2) {
        return new Region(device, n2);
    }
}

