/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferChecks {
    private BufferChecks() {
    }

    public static void checkFunctionAddress(long l2) {
        if (l2 == 0L) {
            throw new IllegalStateException("Function is not supported");
        }
    }

    public static void checkNullTerminated(ByteBuffer byteBuffer) {
        if (byteBuffer.get(byteBuffer.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null argument");
        }
    }

    public static void checkDirect(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("ByteBuffer is not direct");
        }
    }

    public static void checkDirect(ShortBuffer shortBuffer) {
        if (!shortBuffer.isDirect()) {
            throw new IllegalArgumentException("ShortBuffer is not direct");
        }
    }

    public static void checkDirect(IntBuffer intBuffer) {
        if (!intBuffer.isDirect()) {
            throw new IllegalArgumentException("IntBuffer is not direct");
        }
    }

    public static void checkDirect(LongBuffer longBuffer) {
        if (!longBuffer.isDirect()) {
            throw new IllegalArgumentException("LongBuffer is not direct");
        }
    }

    public static void checkDirect(FloatBuffer floatBuffer) {
        if (!floatBuffer.isDirect()) {
            throw new IllegalArgumentException("FloatBuffer is not direct");
        }
    }

    public static void checkDirect(DoubleBuffer doubleBuffer) {
        if (!doubleBuffer.isDirect()) {
            throw new IllegalArgumentException("DoubleBuffer is not direct");
        }
    }

    private static void throwBufferSizeException(Buffer buffer, int n2) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buffer.remaining() + ", must be at least " + n2);
    }

    public static void checkBufferSize(Buffer buffer, int n2) {
        if (buffer.remaining() < n2) {
            BufferChecks.throwBufferSizeException(buffer, n2);
        }
    }

    public static void checkBuffer(ByteBuffer byteBuffer, int n2) {
        BufferChecks.checkBufferSize(byteBuffer, n2);
        BufferChecks.checkDirect(byteBuffer);
    }

    public static void checkBuffer(ShortBuffer shortBuffer, int n2) {
        BufferChecks.checkBufferSize(shortBuffer, n2);
        BufferChecks.checkDirect(shortBuffer);
    }

    public static void checkBuffer(IntBuffer intBuffer, int n2) {
        BufferChecks.checkBufferSize(intBuffer, n2);
        BufferChecks.checkDirect(intBuffer);
    }

    public static void checkBuffer(LongBuffer longBuffer, int n2) {
        BufferChecks.checkBufferSize(longBuffer, n2);
        BufferChecks.checkDirect(longBuffer);
    }

    public static void checkBuffer(FloatBuffer floatBuffer, int n2) {
        BufferChecks.checkBufferSize(floatBuffer, n2);
        BufferChecks.checkDirect(floatBuffer);
    }

    public static void checkBuffer(DoubleBuffer doubleBuffer, int n2) {
        BufferChecks.checkBufferSize(doubleBuffer, n2);
        BufferChecks.checkDirect(doubleBuffer);
    }
}

