/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.openintents.tools.sensorsimulator.SensorSimulator;
import org.openintents.tools.sensorsimulator.Vector;

public class MobilePanel
extends JPanel {
    SensorSimulator mSensorSimulator;
    double read_accelx;
    double read_accely;
    double read_accelz;
    double read_compassx;
    double read_compassy;
    double read_compassz;
    double read_yaw;
    double read_pitch;
    double read_roll;
    double read_temperature;
    long accel_update_duration;
    long accel_next_update;
    long compass_update_duration;
    long compass_next_update;
    long orientation_update_duration;
    long orientation_next_update;
    long temperature_update_duration;
    long temperature_next_update;
    long user_settings_duration;
    long user_settings_next_update;
    double partial_accelx;
    double partial_accely;
    double partial_accelz;
    int partial_accel_n;
    boolean average_accel;
    double partial_compassx;
    double partial_compassy;
    double partial_compassz;
    int partial_compass_n;
    boolean average_compass;
    double partial_yaw;
    double partial_pitch;
    double partial_roll;
    int partial_orientation_n;
    boolean average_orientation;
    double partial_temperature;
    int partial_temperature_n;
    boolean average_temperature;
    double accelx;
    double accely;
    double accelz;
    double compassx;
    double compassy;
    double compassz;
    double yaw;
    double pitch;
    double roll;
    double temperature;
    double yawDegree;
    double pitchDegree;
    double rollDegree;
    int movex;
    int movez;
    int oldx;
    int oldz;
    double vx;
    double vz;
    double oldvx;
    double oldvz;
    double ax;
    double az;
    double Fx;
    double Fz;
    double accx;
    double accz;
    double k;
    double m;
    double gamma;
    double dt;
    double meterperpixel;
    double g;
    double ginverse;
    int mousedownx;
    int mousedowny;
    int mousedownyaw;
    int mousedownpitch;
    int mousedownroll;
    int mousedownmovex;
    int mousedownmovez;
    JSlider yawSlider;
    JSlider pitchSlider;
    JSlider rollSlider;
    Random r;
    final double sx = 15.0;
    final double sy = 40.0;
    final double sz = 5.0;
    final double dx = 12.0;
    final double dy1 = 33.0;
    final double dy2 = -15.0;
    double[][] phone = new double[][]{{15.0, 40.0, -5.0}, {-15.0, 40.0, -5.0}, {-15.0, 40.0, -5.0}, {-15.0, -40.0, -5.0}, {-15.0, -40.0, -5.0}, {15.0, -40.0, -5.0}, {15.0, -40.0, -5.0}, {15.0, 40.0, -5.0}, {15.0, 40.0, 5.0}, {-15.0, 40.0, 5.0}, {-15.0, 40.0, 5.0}, {-15.0, -40.0, 5.0}, {-15.0, -40.0, 5.0}, {15.0, -40.0, 5.0}, {15.0, -40.0, 5.0}, {15.0, 40.0, 5.0}, {15.0, 40.0, -5.0}, {15.0, 40.0, 5.0}, {-15.0, 40.0, -5.0}, {-15.0, 40.0, 5.0}, {-15.0, -40.0, -5.0}, {-15.0, -40.0, 5.0}, {15.0, -40.0, -5.0}, {15.0, -40.0, 5.0}, {12.0, 33.0, 5.0}, {-12.0, 33.0, 5.0}, {-12.0, 33.0, 5.0}, {-12.0, -15.0, 5.0}, {-12.0, -15.0, 5.0}, {12.0, -15.0, 5.0}, {12.0, -15.0, 5.0}, {12.0, 33.0, 5.0}};

    public MobilePanel(SensorSimulator newSensorSimulator) {
        this.mSensorSimulator = newSensorSimulator;
        this.yawDegree = 0.0;
        this.pitchDegree = 0.0;
        this.rollDegree = 0.0;
        this.movex = 0;
        this.movez = 0;
        this.oldx = 0;
        this.oldz = 0;
        this.oldvx = 0.0;
        this.oldvz = 0.0;
        this.Fx = 0.0;
        this.Fz = 0.0;
        this.accx = 0.0;
        this.accz = 0.0;
        this.k = 500.0;
        this.m = 1.0;
        this.gamma = 50.0;
        this.dt = 0.1;
        this.meterperpixel = 3.333333333333333E-4;
        this.g = 9.80665;
        this.ginverse = 1.0 / this.g;
        this.user_settings_duration = 500L;
        this.user_settings_next_update = System.currentTimeMillis();
        this.r = new Random();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                MobilePanel.this.mousedownx = e.getX();
                MobilePanel.this.mousedowny = e.getY();
                MobilePanel.this.mousedownyaw = MobilePanel.this.yawSlider.getValue();
                MobilePanel.this.mousedownpitch = MobilePanel.this.pitchSlider.getValue();
                MobilePanel.this.mousedownroll = MobilePanel.this.rollSlider.getValue();
                MobilePanel.this.mousedownmovex = MobilePanel.this.movex;
                MobilePanel.this.mousedownmovez = MobilePanel.this.movez;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (MobilePanel.this.mSensorSimulator.mouseMode == SensorSimulator.mouseYawPitch) {
                    int newpitch;
                    int newyaw;
                    for (newyaw = MobilePanel.this.mousedownyaw - (e.getX() - MobilePanel.this.mousedownx); newyaw > 180; newyaw -= 360) {
                    }
                    while (newyaw < -180) {
                        newyaw += 360;
                    }
                    MobilePanel.this.yawSlider.setValue(newyaw);
                    MobilePanel.this.yawDegree = newyaw;
                    for (newpitch = MobilePanel.this.mousedownpitch - (e.getY() - MobilePanel.this.mousedowny); newpitch > 180; newpitch -= 360) {
                    }
                    while (newpitch < -180) {
                        newpitch += 360;
                    }
                    MobilePanel.this.pitchSlider.setValue(newpitch);
                    MobilePanel.this.pitchDegree = newpitch;
                } else if (MobilePanel.this.mSensorSimulator.mouseMode == SensorSimulator.mouseRollPitch) {
                    int newpitch;
                    int newroll;
                    for (newroll = MobilePanel.this.mousedownroll + (e.getX() - MobilePanel.this.mousedownx); newroll > 180; newroll -= 360) {
                    }
                    while (newroll < -180) {
                        newroll += 360;
                    }
                    MobilePanel.this.rollSlider.setValue(newroll);
                    MobilePanel.this.rollDegree = newroll;
                    for (newpitch = MobilePanel.this.mousedownpitch - (e.getY() - MobilePanel.this.mousedowny); newpitch > 180; newpitch -= 360) {
                    }
                    while (newpitch < -180) {
                        newpitch += 360;
                    }
                    MobilePanel.this.pitchSlider.setValue(newpitch);
                    MobilePanel.this.pitchDegree = newpitch;
                } else if (MobilePanel.this.mSensorSimulator.mouseMode == SensorSimulator.mouseMove) {
                    int newmovez;
                    int newmovex;
                    MobilePanel.this.movex = newmovex = MobilePanel.this.mousedownmovex + (e.getX() - MobilePanel.this.mousedownx);
                    MobilePanel.this.movez = newmovez = MobilePanel.this.mousedownmovez - (e.getY() - MobilePanel.this.mousedowny);
                }
                MobilePanel.this.repaint();
            }

            public void mouseMoved(MouseEvent evt) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSensorPhysics() {
        double random;
        double newdelay = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mUpdateText);
        if (newdelay > 0.0) {
            this.mSensorSimulator.delay = (int)newdelay;
            this.mSensorSimulator.timer.setDelay(this.mSensorSimulator.delay);
        }
        this.dt = 0.001 * (double)this.mSensorSimulator.delay;
        this.g = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mGravityConstantText, 9.80665);
        if (this.g != 0.0) {
            this.ginverse = 1.0 / this.g;
        }
        this.meterperpixel = 1.0 / this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mPixelPerMeterText, 3000.0);
        this.k = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mSpringConstantText, 500.0);
        this.gamma = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mDampingConstantText, 50.0);
        this.Fx = this.k * ((double)this.movex - this.accx);
        this.Fz = this.k * ((double)this.movez - this.accz);
        this.ax = this.Fx / this.m;
        this.az = this.Fz / this.m;
        this.vx += this.ax * this.dt;
        this.vz += this.az * this.dt;
        this.accx += this.vx * this.dt;
        this.accz += this.vz * this.dt;
        this.accx += this.gamma * ((double)this.movex - this.accx) * this.dt;
        this.accz += this.gamma * ((double)this.movez - this.accz) * this.dt;
        double gravityax = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mGravityXText);
        double gravityay = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mGravityYText);
        double gravityaz = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mGravityZText);
        Vector vec = new Vector(-this.ax * this.meterperpixel + gravityax, gravityay, -this.az * this.meterperpixel + gravityaz);
        vec.reverserollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
        if (this.mSensorSimulator.mEnabledAccelerometer.isSelected()) {
            if (this.mSensorSimulator.mRealDeviceWiimote.isSelected()) {
                this.accelx = this.mSensorSimulator.wiiMoteData.getX() * this.g;
                this.accely = this.mSensorSimulator.wiiMoteData.getY() * this.g;
                this.accelz = this.mSensorSimulator.wiiMoteData.getZ() * this.g;
            } else {
                double limit;
                this.accelx = vec.x;
                this.accely = vec.y;
                this.accelz = vec.z;
                if (this.mSensorSimulator.mRealDeviceThinkpad.isSelected()) {
                    String line = "";
                    try {
                        BufferedReader input = new BufferedReader(new FileReader(this.mSensorSimulator.mRealDevicePath.getText()));
                        try {
                            line = input.readLine();
                        }
                        finally {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        line = "Error reading file!";
                    }
                    this.mSensorSimulator.mRealDeviceOutputLabel.setText(line);
                }
                if ((random = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mRandomAccelerometerText)) > 0.0) {
                    this.accelx += this.getRandom(random);
                    this.accely += this.getRandom(random);
                    this.accelz += this.getRandom(random);
                }
                if ((limit = this.g * this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mAccelerometerLimitText)) > 0.0) {
                    if (this.accelx > limit) {
                        this.accelx = limit;
                    }
                    if (this.accelx < -limit) {
                        this.accelx = -limit;
                    }
                    if (this.accely > limit) {
                        this.accely = limit;
                    }
                    if (this.accely < -limit) {
                        this.accely = -limit;
                    }
                    if (this.accelz > limit) {
                        this.accelz = limit;
                    }
                    if (this.accelz < -limit) {
                        this.accelz = -limit;
                    }
                }
            }
        } else {
            this.accelx = 0.0;
            this.accely = 0.0;
            this.accelz = 0.0;
        }
        if (this.mSensorSimulator.mEnabledMagneticField.isSelected()) {
            double magneticnorth = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mMagneticFieldNorthText);
            double magneticeast = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mMagneticFieldEastText);
            double magneticvertical = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mMagneticFieldVerticalText);
            random = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mRandomMagneticFieldText);
            if (random > 0.0) {
                magneticnorth += this.getRandom(random);
                magneticeast += this.getRandom(random);
                magneticvertical += this.getRandom(random);
            }
            vec = new Vector(magneticeast, magneticnorth, -magneticvertical);
            vec.scale(0.001);
            vec.reverserollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            this.compassx = vec.x;
            this.compassy = vec.y;
            this.compassz = vec.z;
        } else {
            this.compassx = 0.0;
            this.compassy = 0.0;
            this.compassz = 0.0;
        }
        if (this.mSensorSimulator.mEnabledOrientation.isSelected()) {
            this.yaw = this.yawDegree;
            this.pitch = this.pitchDegree;
            this.roll = this.rollDegree;
            random = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mRandomOrientationText);
            if (random > 0.0) {
                this.yaw += this.getRandom(random);
                this.pitch += this.getRandom(random);
                this.roll += this.getRandom(random);
            }
        } else {
            this.yaw = 0.0;
            this.pitch = 0.0;
            this.roll = 0.0;
        }
        if (this.mSensorSimulator.mEnabledTemperature.isSelected()) {
            this.temperature = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mTemperatureText);
            random = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mRandomTemperatureText);
            if (random > 0.0) {
                this.temperature += this.getRandom(random);
            }
        } else {
            this.temperature = 0.0;
        }
        if (this.mSensorSimulator.mShowAcceleration.isSelected()) {
            this.repaint();
        }
    }

    public void updateSensorReadoutValues() {
        long currentTime = System.currentTimeMillis();
        if (this.average_accel) {
            this.partial_accelx += this.accelx;
            this.partial_accely += this.accely;
            this.partial_accelz += this.accelz;
            ++this.partial_accel_n;
        }
        if (this.average_compass) {
            this.partial_compassx += this.compassx;
            this.partial_compassy += this.compassy;
            this.partial_compassz += this.compassz;
            ++this.partial_compass_n;
        }
        if (this.average_orientation) {
            this.partial_yaw += this.yaw;
            this.partial_pitch += this.pitch;
            this.partial_roll += this.roll;
            ++this.partial_orientation_n;
        }
        if (this.average_temperature) {
            this.partial_temperature += this.temperature;
            ++this.partial_temperature_n;
        }
        if (currentTime >= this.accel_next_update) {
            this.accel_next_update += this.accel_update_duration;
            if (this.accel_next_update < currentTime) {
                this.accel_next_update = currentTime;
            }
            if (this.average_accel) {
                this.read_accelx = this.partial_accelx / (double)this.partial_accel_n;
                this.read_accely = this.partial_accely / (double)this.partial_accel_n;
                this.read_accelz = this.partial_accelz / (double)this.partial_accel_n;
                this.partial_accelx = 0.0;
                this.partial_accely = 0.0;
                this.partial_accelz = 0.0;
                this.partial_accel_n = 0;
            } else {
                this.read_accelx = this.accelx;
                this.read_accely = this.accely;
                this.read_accelz = this.accelz;
            }
        }
        if (currentTime >= this.compass_next_update) {
            this.compass_next_update += this.compass_update_duration;
            if (this.compass_next_update < currentTime) {
                this.compass_next_update = currentTime;
            }
            if (this.average_compass) {
                this.read_compassx = this.partial_compassx / (double)this.partial_compass_n;
                this.read_compassy = this.partial_compassy / (double)this.partial_compass_n;
                this.read_compassz = this.partial_compassz / (double)this.partial_compass_n;
                this.partial_compassx = 0.0;
                this.partial_compassy = 0.0;
                this.partial_compassz = 0.0;
                this.partial_compass_n = 0;
            } else {
                this.read_compassx = this.compassx;
                this.read_compassy = this.compassy;
                this.read_compassz = this.compassz;
            }
        }
        if (currentTime >= this.orientation_next_update) {
            this.orientation_next_update += this.orientation_update_duration;
            if (this.orientation_next_update < currentTime) {
                this.orientation_next_update = currentTime;
            }
            if (this.average_orientation) {
                this.read_yaw = this.partial_yaw / (double)this.partial_orientation_n;
                this.read_pitch = this.partial_pitch / (double)this.partial_orientation_n;
                this.read_roll = this.partial_roll / (double)this.partial_orientation_n;
                this.partial_yaw = 0.0;
                this.partial_pitch = 0.0;
                this.partial_roll = 0.0;
                this.partial_orientation_n = 0;
            } else {
                this.read_yaw = this.yaw;
                this.read_pitch = this.pitch;
                this.read_roll = this.roll;
            }
            if (this.read_pitch < -90.0) {
                this.read_pitch = -180.0 - this.read_pitch;
                this.read_yaw += 180.0;
                this.read_roll += 180.0;
            } else if (this.read_pitch > 90.0) {
                this.read_pitch = 180.0 - this.read_pitch;
                this.read_yaw += 180.0;
                this.read_roll += 180.0;
            }
            if (this.read_yaw < 0.0) {
                this.read_yaw += 360.0;
            }
            if (this.read_yaw >= 360.0) {
                this.read_yaw -= 360.0;
            }
            if (this.read_roll >= 180.0) {
                this.read_roll -= 360.0;
            }
        }
        if (currentTime >= this.temperature_next_update) {
            this.temperature_next_update += this.temperature_update_duration;
            if (this.temperature_next_update < currentTime) {
                this.temperature_next_update = currentTime;
            }
            if (this.average_temperature) {
                this.read_temperature = this.partial_temperature / (double)this.partial_temperature_n;
                this.partial_temperature = 0.0;
                this.partial_temperature_n = 0;
            } else {
                this.read_temperature = this.temperature;
            }
        }
    }

    public void updateUserSettings() {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.user_settings_next_update) {
            this.user_settings_next_update += this.user_settings_duration;
            if (this.user_settings_next_update < currentTime) {
                this.user_settings_next_update = System.currentTimeMillis();
            }
            this.average_accel = this.mSensorSimulator.mUpdateAverageAccelerometer.isSelected();
            double rate = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mCurrentUpdateRateAccelerometerText, 0.0);
            this.accel_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
            this.average_compass = this.mSensorSimulator.mUpdateAverageCompass.isSelected();
            rate = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mCurrentUpdateRateCompassText, 0.0);
            this.compass_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
            this.average_orientation = this.mSensorSimulator.mUpdateAverageOrientation.isSelected();
            rate = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mCurrentUpdateRateOrientationText, 0.0);
            this.orientation_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
            this.average_temperature = this.mSensorSimulator.mUpdateAverageThermometer.isSelected();
            rate = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mCurrentUpdateRateThermometerText, 0.0);
            this.temperature_update_duration = rate != 0.0 ? (long)(1000.0 / rate) : 0L;
        }
    }

    public double getRandom(double random) {
        double val = this.r.nextDouble();
        return (2.0 * val - 1.0) * random;
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 200);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g2 = (Graphics2D)graphics;
        double centerx = 100.0;
        double centery = 100.0;
        double centerz = -150.0;
        for (int i = 0; i < this.phone.length; i += 2) {
            if (i == 0) {
                g2.setColor(Color.RED);
            }
            if (i == 24) {
                g2.setColor(Color.BLUE);
            }
            Vector v1 = new Vector(this.phone[i]);
            Vector v2 = new Vector(this.phone[i + 1]);
            v1.rollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            v2.rollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            g2.draw(new Line2D.Double(centerx + (v1.x + (double)this.movex) * centerz / (centerz - v1.y), centery - (v1.z + (double)this.movez) * centerz / (centerz - v1.y), centerx + (v2.x + (double)this.movex) * centerz / (centerz - v2.y), centery - (v2.z + (double)this.movez) * centerz / (centerz - v2.y)));
        }
        if (this.mSensorSimulator.mShowAcceleration.isSelected()) {
            g2.setColor(Color.GREEN);
            Vector v1 = new Vector(0.0, 0.0, 0.0);
            Vector v2 = new Vector(this.accelx, this.accely, this.accelz);
            v2.scale(20.0 * this.ginverse);
            v1.rollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            v2.rollpitchyaw(this.rollDegree, this.pitchDegree, this.yawDegree);
            g2.draw(new Line2D.Double(centerx + (v1.x + (double)this.movex) * centerz / (centerz - v1.y), centery - (v1.z + (double)this.movez) * centerz / (centerz - v1.y), centerx + (v2.x + (double)this.movex) * centerz / (centerz - v2.y), centery - (v2.z + (double)this.movez) * centerz / (centerz - v2.y)));
        }
    }
}

