/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.Surrogate;

public class SingleByte {
    private static final CoderResult withResult(CoderResult coderResult, Buffer buffer, int n, Buffer buffer2, int n2) {
        buffer.position(n - buffer.arrayOffset());
        buffer2.position(n2 - buffer2.arrayOffset());
        return coderResult;
    }

    public static void initC2B(char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        int n;
        char c;
        int n2;
        int n3;
        for (n3 = 0; n3 < cArray4.length; ++n3) {
            cArray4[n3] = 65533;
        }
        for (n3 = 0; n3 < cArray3.length; ++n3) {
            cArray3[n3] = 65533;
        }
        n3 = 0;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            c = cArray[n2];
            if (c == '\ufffd') continue;
            n = c >> 8;
            if (cArray4[n] == '\ufffd') {
                cArray4[n] = (char)n3;
                n3 += 256;
            }
            n = cArray4[n] + (c & 0xFF);
            cArray3[n] = (char)(n2 >= 128 ? n2 - 128 : n2 + 128);
        }
        if (cArray2 != null) {
            n2 = 0;
            while (n2 < cArray2.length) {
                int n4;
                c = cArray2[n2++];
                if (cArray4[n4 = (n = cArray2[n2++]) >> 8] == '\ufffd') {
                    cArray4[n4] = (char)n3;
                    n3 += 256;
                }
                n4 = cArray4[n4] + (n & 0xFF);
                cArray3[n4] = c;
            }
        }
    }

    public static final class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private final char[] b2c;
        private char repl = (char)65533;

        public Decoder(Charset charset, char[] cArray) {
            super(charset, 1.0f, 1.0f);
            this.b2c = cArray;
        }

        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            CoderResult coderResult = CoderResult.UNDERFLOW;
            if (n4 - n3 < n2 - n) {
                n2 = n + (n4 - n3);
                coderResult = CoderResult.OVERFLOW;
            }
            while (n < n2) {
                char c = this.decode(byArray[n]);
                if (c == '\ufffd') {
                    return SingleByte.withResult(CoderResult.unmappableForLength(1), byteBuffer, n, charBuffer, n3);
                }
                cArray[n3++] = c;
                ++n;
            }
            return SingleByte.withResult(coderResult, byteBuffer, n, charBuffer, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    char c = this.decode(byteBuffer.get());
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c);
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        public final char decode(int n) {
            return this.b2c[n + 128];
        }

        @Override
        protected void implReplaceWith(String string) {
            this.repl = string.charAt(0);
        }

        @Override
        public int decode(byte[] byArray, int n, int n2, char[] cArray) {
            int n3;
            if (n2 > cArray.length) {
                n2 = cArray.length;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                cArray[n3] = this.decode(byArray[n++]);
                if (cArray[n3] != '\ufffd') continue;
                cArray[n3] = this.repl;
            }
            return n3;
        }
    }

    public static final class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private Surrogate.Parser sgp;
        private final char[] c2b;
        private final char[] c2bIndex;
        private byte repl = (byte)63;

        public Encoder(Charset charset, char[] cArray, char[] cArray2) {
            super(charset, 1.0f, 1.0f);
            this.c2b = cArray;
            this.c2bIndex = cArray2;
        }

        @Override
        public boolean canEncode(char c) {
            return this.encode(c) != 65533;
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] == 63 || super.isLegalReplacement(byArray);
        }

        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            CoderResult coderResult = CoderResult.UNDERFLOW;
            if (n4 - n3 < n2 - n) {
                n2 = n + (n4 - n3);
                coderResult = CoderResult.OVERFLOW;
            }
            while (n < n2) {
                char c = cArray[n];
                int n5 = this.encode(c);
                if (n5 == 65533) {
                    if (Character.isSurrogate(c)) {
                        if (this.sgp == null) {
                            this.sgp = new Surrogate.Parser();
                        }
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            return SingleByte.withResult(this.sgp.error(), charBuffer, n, byteBuffer, n3);
                        }
                        return SingleByte.withResult(this.sgp.unmappableResult(), charBuffer, n, byteBuffer, n3);
                    }
                    return SingleByte.withResult(CoderResult.unmappableForLength(1), charBuffer, n, byteBuffer, n3);
                }
                byArray[n3++] = (byte)n5;
                ++n;
            }
            return SingleByte.withResult(coderResult, charBuffer, n, byteBuffer, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    int n2 = this.encode(c);
                    if (n2 == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp == null) {
                                this.sgp = new Surrogate.Parser();
                            }
                            if (this.sgp.parse(c, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (!byteBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)n2);
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        public final int encode(char c) {
            char c2 = this.c2bIndex[c >> 8];
            if (c2 == '\ufffd') {
                return 65533;
            }
            return this.c2b[c2 + (c & 0xFF)];
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            this.repl = byArray[0];
        }

        @Override
        public int encode(char[] cArray, int n, int n2, byte[] byArray) {
            int n3 = 0;
            int n4 = n + Math.min(n2, byArray.length);
            while (n < n4) {
                char c;
                int n5;
                if ((n5 = this.encode(c = cArray[n++])) != 65533) {
                    byArray[n3++] = (byte)n5;
                    continue;
                }
                if (Character.isHighSurrogate(c) && n < n4 && Character.isLowSurrogate(cArray[n])) {
                    if (n2 > byArray.length) {
                        ++n4;
                        --n2;
                    }
                    ++n;
                }
                byArray[n3++] = this.repl;
            }
            return n3;
        }
    }
}

