/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.SynthComboBoxUI;
import com.sun.java.swing.plaf.gtk.SynthFileChooserUI;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

class GTKFileChooserUI
extends SynthFileChooserUI {
    private JPanel accessoryPanel = null;
    private String newFolderButtonText = null;
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String newFolderDialogText = null;
    private String deleteFileButtonText = null;
    private String renameFileButtonText = null;
    private String newFolderButtonToolTipText = null;
    private String deleteFileButtonToolTipText = null;
    private String renameFileButtonToolTipText = null;
    private int newFolderButtonMnemonic = 0;
    private int deleteFileButtonMnemonic = 0;
    private int renameFileButtonMnemonic = 0;
    private String renameFileDialogText = null;
    private String renameFileErrorTitle = null;
    private String renameFileErrorText = null;
    private JPanel rightPanel;
    private JList directoryList;
    private JList fileList;
    private JLabel pathField;
    private JTextField fileNameTextField;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Insets insets = new Insets(10, 10, 10, 10);
    private static Dimension prefListSize = new Dimension(75, 150);
    private static Dimension PREF_SIZE = new Dimension(435, 360);
    private static Dimension MIN_SIZE = new Dimension(200, 300);
    private static Dimension PREF_ACC_SIZE = new Dimension(10, 10);
    private static Dimension ZERO_ACC_SIZE = new Dimension(1, 1);
    private static Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    private static final Insets buttonMargin = new Insets(3, 3, 3, 3);
    private String filesLabelText = null;
    private String foldersLabelText = null;
    private String pathLabelText = null;
    private int pathLabelMnemonic = 0;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private JPanel bottomButtonPanel;
    private GTKDirectoryModel model = null;
    private Action newFolderAction;
    private boolean readOnly;
    private Action approveSelectionAction = new GTKApproveSelectionAction();

    GTKFileChooserUI() {
    }

    protected void createModel() {
        this.model = new GTKDirectoryModel();
    }

    private void updateDefaultButton() {
        JFileChooser jFileChooser = this.getFileChooser();
        JRootPane jRootPane = SwingUtilities.getRootPane(jFileChooser);
        if (jRootPane == null) {
            return;
        }
        if (jFileChooser.getControlButtonsAreShown()) {
            if (jRootPane.getDefaultButton() == null) {
                jRootPane.setDefaultButton(this.getApproveButton(jFileChooser));
                this.getCancelButton(jFileChooser).setDefaultCapable(false);
            }
        } else if (jRootPane.getDefaultButton() == this.getApproveButton(jFileChooser)) {
            jRootPane.setDefaultButton(null);
        }
    }

    protected void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
                this.getAccessoryPanel().setPreferredSize(jComponent.getPreferredSize());
                this.getAccessoryPanel().setMaximumSize(MAX_SIZE);
            } else {
                this.getAccessoryPanel().setPreferredSize(ZERO_ACC_SIZE);
                this.getAccessoryPanel().setMaximumSize(ZERO_ACC_SIZE);
            }
        }
    }

    protected void doAncestorChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
            this.fileNameTextField.selectAll();
            this.fileNameTextField.requestFocus();
            this.updateDefaultButton();
        }
        super.doAncestorChanged(propertyChangeEvent);
    }

    protected void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doControlButtonsChanged(propertyChangeEvent);
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.getControlButtonsAreShown()) {
            jFileChooser.add((Component)this.bottomButtonPanel, "South");
        } else {
            jFileChooser.remove(this.bottomButtonPanel);
        }
        this.updateDefaultButton();
    }

    protected void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        this.directoryList.clearSelection();
        this.fileList.clearSelection();
        File file = this.getFileChooser().getCurrentDirectory();
        if (file != null) {
            try {
                this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getCanonicalPath());
            }
            catch (IOException iOException) {
                this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getAbsolutePath());
            }
            if (this.getFileChooser().getFileSelectionMode() == 1 && !this.getFileChooser().isMultiSelectionEnabled()) {
                this.setFileName(this.pathField.getText());
            }
            this.directoryComboBoxModel.addItem(file);
        }
        super.doDirectoryChanged(propertyChangeEvent);
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.directoryList.clearSelection();
        this.rightPanel.setVisible((Integer)propertyChangeEvent.getNewValue() != 1);
        super.doFileSelectionModeChanged(propertyChangeEvent);
    }

    protected void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
            this.fileList.clearSelection();
        }
        super.doMultiSelectionChanged(propertyChangeEvent);
    }

    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doSelectedFileChanged(propertyChangeEvent);
        File file = (File)propertyChangeEvent.getNewValue();
        if (file != null) {
            this.setFileName(this.getFileChooser().getName(file));
        }
    }

    public String getFileName() {
        String string;
        JFileChooser jFileChooser = this.getFileChooser();
        String string2 = string = this.fileNameTextField != null ? this.fileNameTextField.getText() : null;
        if (!jFileChooser.isMultiSelectionEnabled()) {
            return string;
        }
        int n2 = jFileChooser.getFileSelectionMode();
        JList jList = n2 == 1 ? this.directoryList : this.fileList;
        Object[] objectArray = jList.getSelectedValues();
        int n3 = objectArray.length;
        Vector vector = new Vector(n3 + 1);
        for (int i2 = 0; i2 < n3; ++i2) {
            File file = (File)objectArray[i2];
            vector.add(file.getName());
        }
        if (string != null && !vector.contains(string)) {
            vector.add(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        n3 = vector.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            if (n3 > 1) {
                stringBuffer.append(" \"");
            }
            stringBuffer.append(vector.get(i3));
            if (n3 <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public void setDirectoryName(String string) {
        this.pathField.setText(string);
    }

    public void setFileName(String string) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(string);
        }
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction();
            this.newFolderAction.setEnabled(!this.readOnly);
        }
        return this.newFolderAction;
    }

    protected void align(JComponent jComponent) {
        jComponent.setAlignmentX(0.0f);
        jComponent.setAlignmentY(0.0f);
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout(10, 10));
        this.accessoryPanel.setName("GTKFileChooser.accessoryPanel");
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    public void installComponents(JFileChooser jFileChooser) {
        super.installComponents(jFileChooser);
        boolean bl2 = jFileChooser.getComponentOrientation().isLeftToRight();
        jFileChooser.setLayout(new BorderLayout());
        jFileChooser.setAlignmentX(0.5f);
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0));
        jPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        jPanel.setName("GTKFileChooser.topButtonPanel");
        JButton jButton = new JButton(this.getNewFolderAction());
        jButton.setName("GTKFileChooser.newFolderButton");
        jButton.setMnemonic(this.newFolderButtonMnemonic);
        jButton.setToolTipText(this.newFolderButtonToolTipText);
        jButton.setText(this.newFolderButtonText);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(this.deleteFileButtonText);
        jButton2.setName("GTKFileChooser.deleteFileButton");
        jButton2.setMnemonic(this.deleteFileButtonMnemonic);
        jButton2.setToolTipText(this.deleteFileButtonToolTipText);
        jButton2.setEnabled(false);
        jPanel.add(jButton2);
        RenameFileAction renameFileAction = new RenameFileAction();
        JButton jButton3 = new JButton(renameFileAction);
        jButton3.setText(this.renameFileButtonText);
        jButton3.setName("GTKFileChooser.renameFileButton");
        jButton3.setMnemonic(this.renameFileButtonMnemonic);
        jButton3.setToolTipText(this.renameFileButtonToolTipText);
        jPanel.add(jButton3);
        jFileChooser.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.setName("GTKFileChooser.interiorPanel");
        this.align(jPanel2);
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jFileChooser.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 0, 0){

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                JComboBox jComboBox = GTKFileChooserUI.this.directoryComboBox;
                if (jComboBox.getWidth() > container.getWidth()) {
                    jComboBox.setBounds(0, jComboBox.getY(), container.getWidth(), jComboBox.getHeight());
                }
            }
        });
        jPanel3.setBorder(new EmptyBorder(0, 0, 4, 0));
        jPanel3.setName("GTKFileChooser.directoryComboBoxPanel");
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox = new JComboBox(this.directoryComboBoxModel);
        this.directoryComboBox.setName("GTKFileChooser.directoryComboBox");
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel3.add(this.directoryComboBox);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setName("GTKFileChooser.centerPanel");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setName("GTKFileChooser.splitPanel");
        jSplitPane.setDividerLocation((GTKFileChooserUI.PREF_SIZE.width - 8) / 2);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setName("GTKFileChooser.directoryListPanel");
        TableCellRenderer tableCellRenderer = new JTableHeader().getDefaultRenderer();
        JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(null, this.foldersLabelText, false, false, 0, 0);
        jComponent.setName("GTKFileChooser.directoryListLabel");
        jPanel5.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS, 0, 0));
        jPanel5.add((Component)this.createDirectoryList(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS, 0, 0));
        this.rightPanel = new JPanel(new GridBagLayout());
        this.rightPanel.setName("GTKFileChooser.fileListPanel");
        tableCellRenderer = new JTableHeader().getDefaultRenderer();
        JComponent jComponent2 = (JComponent)tableCellRenderer.getTableCellRendererComponent(null, this.filesLabelText, false, false, 0, 0);
        jComponent2.setName("GTKFileChooser.fileListLabel");
        this.rightPanel.add((Component)jComponent2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS, 0, 0));
        this.rightPanel.add((Component)this.createFilesList(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS, 0, 0));
        jSplitPane.add((Component)jPanel5, bl2 ? "left" : "right");
        jSplitPane.add((Component)this.rightPanel, bl2 ? "right" : "left");
        jPanel4.add((Component)jSplitPane, "Center");
        JPanel jPanel6 = this.getAccessoryPanel();
        JComponent jComponent3 = jFileChooser.getAccessory();
        if (jPanel6 != null) {
            if (jComponent3 == null) {
                jPanel6.setPreferredSize(ZERO_ACC_SIZE);
                jPanel6.setMaximumSize(ZERO_ACC_SIZE);
            } else {
                this.getAccessoryPanel().add((Component)jComponent3, "Center");
                jPanel6.setPreferredSize(jComponent3.getPreferredSize());
                jPanel6.setMaximumSize(MAX_SIZE);
            }
            this.align(jPanel6);
            jPanel4.add((Component)jPanel6, "After");
        }
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(vstrut10));
        JPanel jPanel7 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel7.setBorder(new EmptyBorder(0, 0, 4, 0));
        JLabel jLabel = new JLabel(this.pathLabelText);
        jLabel.setName("GTKFileChooser.pathFieldLabel");
        jLabel.setDisplayedMnemonic(this.pathLabelMnemonic);
        this.align(jLabel);
        jPanel7.add(jLabel);
        File file = jFileChooser.getCurrentDirectory();
        String string = null;
        if (file != null) {
            string = file.getPath();
        }
        this.pathField = new JLabel(string){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        this.pathField.setName("GTKFileChooser.pathField");
        jLabel.setLabelFor(this.pathField);
        this.align(this.pathField);
        jPanel7.add(this.pathField);
        jPanel2.add(jPanel7);
        this.fileNameTextField = new JTextField(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        Set set = this.fileNameTextField.getFocusTraversalKeys(0);
        set = new HashSet(set);
        set.remove(KeyStroke.getKeyStroke(9, 0));
        this.fileNameTextField.setFocusTraversalKeys(0, set);
        this.fileNameTextField.setName("GTKFileChooser.fileNameTextField");
        this.fileNameTextField.getActionMap().put("fileNameCompletionAction", this.getFileNameCompletionAction());
        this.fileNameTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "fileNameCompletionAction");
        jPanel2.add(this.fileNameTextField);
        this.bottomButtonPanel = new JPanel(new FlowLayout(4));
        this.bottomButtonPanel.setName("GTKFileChooser.bottomButtonPanel");
        this.align(this.bottomButtonPanel);
        JButton jButton4 = this.getCancelButton(jFileChooser);
        this.align(jButton4);
        jButton4.setMargin(buttonMargin);
        this.bottomButtonPanel.add(jButton4);
        JButton jButton5 = this.getApproveButton(jFileChooser);
        this.align(jButton5);
        jButton5.setMargin(buttonMargin);
        this.bottomButtonPanel.add(jButton5);
        jFileChooser.add((Component)this.bottomButtonPanel, "South");
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        super.installDefaults(jFileChooser);
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.newFolderDialogText = UIManager.getString((Object)"FileChooser.newFolderDialogText", locale);
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", locale);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", locale);
        this.newFolderButtonText = UIManager.getString((Object)"FileChooser.newFolderButtonText", locale);
        this.deleteFileButtonText = UIManager.getString((Object)"FileChooser.deleteFileButtonText", locale);
        this.renameFileButtonText = UIManager.getString((Object)"FileChooser.renameFileButtonText", locale);
        this.newFolderButtonMnemonic = UIManager.getInt((Object)"FileChooser.newFolderButtonMnemonic", locale);
        this.deleteFileButtonMnemonic = UIManager.getInt((Object)"FileChooser.deleteFileButtonMnemonic", locale);
        this.renameFileButtonMnemonic = UIManager.getInt((Object)"FileChooser.renameFileButtonMnemonic", locale);
        this.newFolderButtonToolTipText = UIManager.getString((Object)"FileChooser.newFolderButtonToolTipText", locale);
        this.deleteFileButtonToolTipText = UIManager.getString((Object)"FileChooser.deleteFileButtonToolTipText", locale);
        this.renameFileButtonToolTipText = UIManager.getString((Object)"FileChooser.renameFileButtonToolTipText", locale);
        this.renameFileDialogText = UIManager.getString((Object)"FileChooser.renameFileDialogText", locale);
        this.renameFileErrorTitle = UIManager.getString((Object)"FileChooser.renameFileErrorTitle", locale);
        this.renameFileErrorText = UIManager.getString((Object)"FileChooser.renameFileErrorText", locale);
        this.foldersLabelText = UIManager.getString((Object)"FileChooser.foldersLabelText", locale);
        this.filesLabelText = UIManager.getString((Object)"FileChooser.filesLabelText", locale);
        this.pathLabelText = UIManager.getString((Object)"FileChooser.pathLabelText", locale);
        this.pathLabelMnemonic = UIManager.getInt("FileChooser.pathLabelMnemonic");
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        super.uninstallStrings(jFileChooser);
        this.newFolderButtonText = null;
        this.deleteFileButtonText = null;
        this.renameFileButtonText = null;
        this.newFolderButtonToolTipText = null;
        this.deleteFileButtonToolTipText = null;
        this.renameFileButtonToolTipText = null;
        this.renameFileDialogText = null;
        this.renameFileErrorTitle = null;
        this.renameFileErrorText = null;
        this.foldersLabelText = null;
        this.filesLabelText = null;
        this.pathLabelText = null;
    }

    protected JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JScrollPane createDirectoryList() {
        this.directoryList = new JList();
        this.directoryList.setName("GTKFileChooser.directoryList");
        this.align(this.directoryList);
        this.directoryList.setCellRenderer(new DirectoryCellRenderer());
        this.directoryList.setModel(new GTKDirectoryListModel());
        this.directoryList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.directoryList));
        this.directoryList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        JScrollPane jScrollPane = new JScrollPane(this.directoryList);
        jScrollPane.setName("GTKFileChooser.directoryListScrollPane");
        jScrollPane.setMaximumSize(MAX_SIZE);
        jScrollPane.setPreferredSize(prefListSize);
        this.align(jScrollPane);
        return jScrollPane;
    }

    protected JScrollPane createFilesList() {
        this.fileList = new JList();
        this.fileList.setName("GTKFileChooser.fileList");
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
        }
        this.fileList.setModel(new GTKFileListModel());
        this.fileList.setCellRenderer(new FileCellRenderer());
        this.fileList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        this.fileList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.fileList));
        this.align(this.fileList);
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jScrollPane.setName("GTKFileChooser.fileListScrollPane");
        jScrollPane.setPreferredSize(prefListSize);
        jScrollPane.setMaximumSize(MAX_SIZE);
        this.align(jScrollPane);
        return jScrollPane;
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(MIN_SIZE);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        Dimension dimension2 = new Dimension(PREF_SIZE);
        JComponent jComponent2 = this.getFileChooser().getAccessory();
        if (jComponent2 != null) {
            dimension2.width += jComponent2.getPreferredSize().width + 20;
        }
        if ((dimension = jComponent.getLayout().preferredLayoutSize(jComponent)) != null) {
            return new Dimension(dimension.width < dimension2.width ? dimension2.width : dimension.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
        }
        return dimension2;
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new GTKFileChooserUI();
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(jList);
    }

    protected class DirectoryCellRenderer
    extends DefaultListCellRenderer {
        public boolean isOpaque() {
            Color color = this.getBackground();
            Container container = this.getParent();
            if (container != null) {
                container = container.getParent();
            }
            boolean bl2 = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
            return !bl2 && super.isOpaque();
        }

        protected DirectoryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            this.setText(GTKFileChooserUI.this.getFileChooser().getName((File)object) + "/");
            return this;
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)GTKFileChooserUI.this.directoryComboBox.getSelectedItem();
            GTKFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        File selectedDirectory = null;
        JFileChooser chooser = GTKFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public int getSize() {
            return this.directories.size();
        }

        public DirectoryComboBoxModel() {
            File file = GTKFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            int n2 = this.directories.size();
            this.directories.clear();
            if (n2 > 0) {
                this.fireIntervalRemoved(this, 0, n2);
            }
            File file2 = null;
            try {
                file2 = this.fsv.createFileObject(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                file2 = file;
            }
            File file3 = file2;
            do {
                this.directories.add(file3);
            } while ((file3 = file3.getParentFile()) != null);
            int n3 = this.directories.size();
            if (n3 > 0) {
                this.fireIntervalAdded(this, 0, n3);
            }
            this.setSelectedItem(file2);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public Object getElementAt(int n2) {
            return this.directories.elementAt(n2);
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    class DirectoryComboBoxRenderer
    extends SynthComboBoxUI.SynthComboBoxRenderer {
        DirectoryComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object == null) {
                this.setText("");
                return this;
            }
            this.setText(((File)object).getAbsolutePath());
            return this;
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public void mouseClicked(MouseEvent mouseEvent) {
            int n2;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n2 = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n2);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (GTKFileChooserUI.this.getFileChooser().isTraversable(file)) {
                    this.list.clearSelection();
                    if (GTKFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(file)) {
                        GTKFileChooserUI.this.rescanCurrentDirectory(GTKFileChooserUI.this.getFileChooser());
                    } else {
                        GTKFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                    }
                } else {
                    GTKFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }

        public DoubleClickListener(JList jList) {
            this.list = jList;
        }
    }

    protected class FileCellRenderer
    extends DefaultListCellRenderer {
        public boolean isOpaque() {
            Color color = this.getBackground();
            Container container = this.getParent();
            if (container != null) {
                container = container.getParent();
            }
            boolean bl2 = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
            return !bl2 && super.isOpaque();
        }

        protected FileCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            this.setText(GTKFileChooserUI.this.getFileChooser().getName((File)object));
            return this;
        }
    }

    private class GTKApproveSelectionAction
    extends SynthFileChooserUI.ApproveSelectionAction {
        private GTKApproveSelectionAction() {
            super(GTKFileChooserUI.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GTKFileChooserUI.this.isDirectorySelected()) {
                File file = GTKFileChooserUI.this.getDirectory();
                try {
                    if (file != null) {
                        file = file.getCanonicalFile();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (GTKFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(file)) {
                    GTKFileChooserUI.this.directoryList.clearSelection();
                    GTKFileChooserUI.this.rescanCurrentDirectory(GTKFileChooserUI.this.getFileChooser());
                    return;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }

    protected class GTKDirectoryListModel
    extends AbstractListModel
    implements ListDataListener {
        File curDir;

        public int getSize() {
            return GTKFileChooserUI.this.getModel().getDirectories().size() + 1;
        }

        public void fireContentsChanged() {
            this.curDir = GTKFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(GTKFileChooserUI.this.getFileChooser().getCurrentDirectory(), ".");
            this.fireContentsChanged(this, 0, GTKFileChooserUI.this.getModel().getDirectories().size() - 1);
        }

        public GTKDirectoryListModel() {
            GTKFileChooserUI.this.getModel().addListDataListener(this);
        }

        public Object getElementAt(int n2) {
            return n2 > 0 ? GTKFileChooserUI.this.getModel().getDirectories().elementAt(n2 - 1) : this.curDir;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }
    }

    private class GTKDirectoryModel
    extends BasicDirectoryModel {
        FileSystemView fsv;
        private Comparator fileComparator;

        public GTKDirectoryModel() {
            super(GTKFileChooserUI.this.getFileChooser());
            this.fileComparator = new Comparator(this){
                private final /* synthetic */ GTKDirectoryModel this$1;
                {
                    this.this$1 = gTKDirectoryModel;
                }

                public int compare(Object object, Object object2) {
                    return this.this$1.fsv.getSystemDisplayName((File)object).compareTo(this.this$1.fsv.getSystemDisplayName((File)object2));
                }
            };
        }

        protected void sort(Vector vector) {
            this.fsv = GTKFileChooserUI.this.getFileChooser().getFileSystemView();
            Collections.sort(vector, this.fileComparator);
        }
    }

    protected class GTKFileListModel
    extends AbstractListModel
    implements ListDataListener {
        public int getSize() {
            return GTKFileChooserUI.this.getModel().getFiles().size();
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, GTKFileChooserUI.this.getModel().getFiles().size() - 1);
        }

        public GTKFileListModel() {
            GTKFileChooserUI.this.getModel().addListDataListener(this);
        }

        public Object getElementAt(int n2) {
            return GTKFileChooserUI.this.getModel().getFiles().elementAt(n2);
        }

        public int indexOf(Object object) {
            return GTKFileChooserUI.this.getModel().getFiles().indexOf(object);
        }

        public boolean contains(Object object) {
            return GTKFileChooserUI.this.getModel().getFiles().contains(object);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GTKFileChooserUI.this.readOnly) {
                return;
            }
            JFileChooser jFileChooser = GTKFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            String string = JOptionPane.showInputDialog(jFileChooser, GTKFileChooserUI.this.newFolderDialogText, GTKFileChooserUI.this.newFolderButtonText, -1);
            if (string != null) {
                File file2 = jFileChooser.getFileSystemView().createFileObject(file, string);
                if (file2 == null || !file2.mkdir()) {
                    JOptionPane.showMessageDialog(jFileChooser, GTKFileChooserUI.this.newFolderErrorText + GTKFileChooserUI.this.newFolderErrorSeparator + " \"" + string + "\"", GTKFileChooserUI.this.newFolderErrorText, 0);
                }
                jFileChooser.rescanCurrentDirectory();
            }
        }
    }

    private class RenameFileAction
    extends AbstractAction {
        protected RenameFileAction() {
            super("editFileName");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GTKFileChooserUI.this.getFileName().equals("") || GTKFileChooserUI.this.readOnly) {
                return;
            }
            JFileChooser jFileChooser = GTKFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            String string = (String)JOptionPane.showInputDialog(jFileChooser, new MessageFormat(GTKFileChooserUI.this.renameFileDialogText).format(new Object[]{GTKFileChooserUI.this.getFileName()}), GTKFileChooserUI.this.renameFileButtonText, -1, null, null, GTKFileChooserUI.this.getFileName());
            if (string != null) {
                File file2 = jFileChooser.getFileSystemView().createFileObject(file, GTKFileChooserUI.this.getFileName());
                File file3 = jFileChooser.getFileSystemView().createFileObject(file, string);
                if (file2 == null || file3 == null || !GTKFileChooserUI.this.getModel().renameFile(file2, file3)) {
                    JOptionPane.showMessageDialog(jFileChooser, new MessageFormat(GTKFileChooserUI.this.renameFileErrorText).format(new Object[]{GTKFileChooserUI.this.getFileName(), string}), GTKFileChooserUI.this.renameFileErrorTitle, 0);
                } else {
                    GTKFileChooserUI.this.setFileName(GTKFileChooserUI.this.getFileChooser().getName(file3));
                    jFileChooser.rescanCurrentDirectory();
                }
            }
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        /*
         * Unable to fully structure code
         */
        public void valueChanged(ListSelectionEvent var1_1) {
            block7: {
                block8: {
                    block9: {
                        if (var1_1.getValueIsAdjusting()) break block7;
                        var2_2 = GTKFileChooserUI.this.getFileChooser();
                        var3_3 = (JList)var1_1.getSource();
                        if (!var2_2.isMultiSelectionEnabled()) break block8;
                        var4_4 = null;
                        var5_6 = var3_3.getSelectedValues();
                        if (var5_6 == null) break block9;
                        if (var5_6.length != 1 || !((File)var5_6[0]).isDirectory() || !var2_2.isTraversable((File)var5_6[0])) ** GOTO lbl-1000
                        if (var2_2.getFileSelectionMode() != 1 || !var2_2.getFileSystemView().isFileSystem((File)var5_6[0])) {
                            GTKFileChooserUI.this.setDirectorySelected(true);
                            GTKFileChooserUI.this.setDirectory((File)var5_6[0]);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var6_7 = new ArrayList(var5_6.length);
                            for (var7_8 = 0; var7_8 < var5_6.length; ++var7_8) {
                                var8_9 = (File)var5_6[var7_8];
                                if ((!var2_2.isFileSelectionEnabled() || !var8_9.isFile()) && (!var2_2.isDirectorySelectionEnabled() || !var8_9.isDirectory())) continue;
                                var6_7.add(var8_9);
                            }
                            if (var6_7.size() > 0) {
                                var4_4 = (File[])var6_7.toArray(new File[var6_7.size()]);
                            }
                            GTKFileChooserUI.this.setDirectorySelected(false);
                        }
                    }
                    var2_2.setSelectedFiles(var4_4);
                    break block7;
                }
                var4_5 = (File)var3_3.getSelectedValue();
                if (var4_5 == null || !var4_5.isDirectory() || !var2_2.isTraversable(var4_5)) ** GOTO lbl-1000
                if (var2_2.getFileSelectionMode() != 1 || !var2_2.getFileSystemView().isFileSystem(var4_5)) {
                    GTKFileChooserUI.this.setDirectorySelected(true);
                    GTKFileChooserUI.this.setDirectory(var4_5);
                } else lbl-1000:
                // 2 sources

                {
                    GTKFileChooserUI.this.setDirectorySelected(false);
                    if (var4_5 != null) {
                        var2_2.setSelectedFile(var4_5);
                    }
                }
            }
        }
    }
}

