/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.omg.CosNaming.NameComponent;

public final class CNNameParser
implements NameParser {
    private static final Properties mySyntax = new Properties();
    private static final char kindSeparator = '.';
    private static final char compSeparator = '/';
    private static final char escapeChar = '\\';

    static {
        mySyntax.put("jndi.syntax.direction", "left_to_right");
        mySyntax.put("jndi.syntax.separator", "/");
        mySyntax.put("jndi.syntax.escape", "\\");
    }

    private static boolean isMeta(char c2) {
        switch (c2) {
            case '.': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    private static String escape(String string) {
        if (string.indexOf(46) < 0 && string.indexOf(47) < 0 && string.indexOf(92) < 0) {
            return string;
        }
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[n2 + n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (CNNameParser.isMeta(string.charAt(i2))) {
                cArray[n3++] = 92;
            }
            cArray[n3++] = string.charAt(i2);
        }
        return new String(cArray, 0, n3);
    }

    private static String stringifyComponent(NameComponent nameComponent) {
        StringBuffer stringBuffer = new StringBuffer(CNNameParser.escape(nameComponent.id));
        if (nameComponent.kind != null && !nameComponent.kind.equals("")) {
            stringBuffer.append('.' + CNNameParser.escape(nameComponent.kind));
        }
        if (stringBuffer.length() == 0) {
            return ".";
        }
        return stringBuffer.toString();
    }

    static String cosNameToInsString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < nameComponentArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(CNNameParser.stringifyComponent(nameComponentArray[i2]));
        }
        return stringBuffer.toString();
    }

    private static Vector insStringToStringifiedComps(String string) throws InvalidNameException {
        int n2 = string.length();
        Vector vector = new Vector(10);
        char[] cArray = new char[n2];
        char[] cArray2 = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            boolean bl2 = true;
            while (n3 < n2 && string.charAt(n3) != '/') {
                if (string.charAt(n3) == '\\') {
                    if (n3 + 1 >= n2) {
                        throw new InvalidNameException(string + ": unescaped \\ at end of component");
                    }
                    if (CNNameParser.isMeta(string.charAt(n3 + 1))) {
                        ++n3;
                        if (bl2) {
                            cArray[n5++] = string.charAt(n3++);
                            continue;
                        }
                        cArray2[n4++] = string.charAt(n3++);
                        continue;
                    }
                    throw new InvalidNameException(string + ": invalid character being escaped");
                }
                if (bl2 && string.charAt(n3) == '.') {
                    ++n3;
                    bl2 = false;
                    continue;
                }
                if (bl2) {
                    cArray[n5++] = string.charAt(n3++);
                    continue;
                }
                cArray2[n4++] = string.charAt(n3++);
            }
            vector.addElement(CNNameParser.stringifyComponent(new NameComponent(new String(cArray, 0, n5), new String(cArray2, 0, n4))));
            if (n3 >= n2) continue;
            ++n3;
        }
        return vector;
    }

    public Name parse(String string) throws NamingException {
        Vector vector = CNNameParser.insStringToStringifiedComps(string);
        return new CNCompoundName(vector.elements());
    }

    static Name cosNameToName(NameComponent[] nameComponentArray) {
        CompositeName compositeName = new CompositeName();
        for (int i2 = 0; nameComponentArray != null && i2 < nameComponentArray.length; ++i2) {
            try {
                compositeName.add(CNNameParser.stringifyComponent(nameComponentArray[i2]));
                continue;
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
        return compositeName;
    }

    private static NameComponent parseComponent(String string) throws InvalidNameException {
        int n2;
        NameComponent nameComponent = new NameComponent();
        int n3 = -1;
        int n4 = string.length();
        int n5 = 0;
        char[] cArray = new char[n4];
        boolean bl2 = false;
        for (n2 = 0; n2 < n4 && n3 < 0; ++n2) {
            if (bl2) {
                cArray[n5++] = string.charAt(n2);
                bl2 = false;
                continue;
            }
            if (string.charAt(n2) == '\\') {
                if (n2 + 1 >= n4) {
                    throw new InvalidNameException(string + ": unescaped \\ at end of component");
                }
                if (CNNameParser.isMeta(string.charAt(n2 + 1))) {
                    bl2 = true;
                    continue;
                }
                throw new InvalidNameException(string + ": invalid character being escaped");
            }
            if (string.charAt(n2) == '.') {
                n3 = n2;
                continue;
            }
            cArray[n5++] = string.charAt(n2);
        }
        nameComponent.id = new String(cArray, 0, n5);
        if (n3 < 0) {
            nameComponent.kind = "";
        } else {
            n5 = 0;
            bl2 = false;
            for (n2 = n3 + 1; n2 < n4; ++n2) {
                if (bl2) {
                    cArray[n5++] = string.charAt(n2);
                    bl2 = false;
                    continue;
                }
                if (string.charAt(n2) == '\\') {
                    if (n2 + 1 >= n4) {
                        throw new InvalidNameException(string + ": unescaped \\ at end of component");
                    }
                    if (CNNameParser.isMeta(string.charAt(n2 + 1))) {
                        bl2 = true;
                        continue;
                    }
                    throw new InvalidNameException(string + ": invalid character being escaped");
                }
                cArray[n5++] = string.charAt(n2);
            }
            nameComponent.kind = new String(cArray, 0, n5);
        }
        return nameComponent;
    }

    static NameComponent[] nameToCosName(Name name) throws InvalidNameException {
        int n2 = name.size();
        if (n2 == 0) {
            return new NameComponent[0];
        }
        NameComponent[] nameComponentArray = new NameComponent[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nameComponentArray[i2] = CNNameParser.parseComponent(name.get(i2));
        }
        return nameComponentArray;
    }

    static final class CNCompoundName
    extends CompoundName {
        private static final long serialVersionUID = -6599252802678482317L;

        public Object clone() {
            return new CNCompoundName(this.getAll());
        }

        public String toString() {
            try {
                return CNNameParser.cosNameToInsString(CNNameParser.nameToCosName(this));
            }
            catch (InvalidNameException invalidNameException) {
                return super.toString();
            }
        }

        CNCompoundName(Enumeration enumeration) {
            super(enumeration, mySyntax);
        }

        public Name getPrefix(int n2) {
            Enumeration enumeration = super.getPrefix(n2).getAll();
            return new CNCompoundName(enumeration);
        }

        public Name getSuffix(int n2) {
            Enumeration enumeration = super.getSuffix(n2).getAll();
            return new CNCompoundName(enumeration);
        }
    }
}

