/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintRequestAttribute;

public final class MediaPrintableArea
implements DocAttribute,
PrintRequestAttribute,
PrintJobAttribute {
    private int x;
    private int y;
    private int w;
    private int h;
    private int units;
    public static final int INCH = 25400;
    public static final int MM = 1000;

    public int hashCode() {
        return this.x + 37 * this.y + 43 * this.w + 47 * this.h;
    }

    public MediaPrintableArea(float f2, float f3, float f4, float f5, int n2) {
        if ((double)f2 < 0.0 || (double)f3 < 0.0 || (double)f4 <= 0.0 || (double)f5 <= 0.0 || n2 < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.x = (int)(f2 * (float)n2 + 0.5f);
        this.y = (int)(f3 * (float)n2 + 0.5f);
        this.w = (int)(f4 * (float)n2 + 0.5f);
        this.h = (int)(f5 * (float)n2 + 0.5f);
    }

    public float getHeight(int n2) {
        return MediaPrintableArea.convertFromMicrometers(this.h, n2);
    }

    public float getWidth(int n2) {
        return MediaPrintableArea.convertFromMicrometers(this.w, n2);
    }

    public float getX(int n2) {
        return MediaPrintableArea.convertFromMicrometers(this.x, n2);
    }

    public float getY(int n2) {
        return MediaPrintableArea.convertFromMicrometers(this.y, n2);
    }

    public float[] getPrintableArea(int n2) {
        return new float[]{this.getX(n2), this.getY(n2), this.getWidth(n2), this.getHeight(n2)};
    }

    private static float convertFromMicrometers(int n2, int n3) {
        if (n3 < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return (float)n2 / (float)n3;
    }

    public MediaPrintableArea(int n2, int n3, int n4, int n5, int n6) {
        if (n2 < 0 || n3 < 0 || n4 <= 0 || n5 <= 0 || n6 < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.x = n2 * n6;
        this.y = n3 * n6;
        this.w = n4 * n6;
        this.h = n5 * n6;
    }

    public final Class getCategory() {
        return MediaPrintableArea.class;
    }

    public boolean equals(Object object) {
        boolean bl2 = false;
        if (object instanceof MediaPrintableArea) {
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)object;
            if (this.x == mediaPrintableArea.x && this.y == mediaPrintableArea.y && this.w == mediaPrintableArea.w && this.h == mediaPrintableArea.h) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public final String getName() {
        return "media-printable-area";
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public String toString(int n2, String string) {
        if (string == null) {
            string = "";
        }
        float[] fArray = this.getPrintableArea(n2);
        String string2 = "(" + fArray[0] + "," + fArray[1] + ")->(" + fArray[2] + "," + fArray[3] + ")";
        return string2 + string;
    }
}

