/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    private RootPaneContainer floatingToolBar;
    protected DragWindow dragWindow;
    private Container dockingSource;
    private int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected String constraintBeforeFloating = "North";
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private boolean rolloverBorders = false;
    private HashMap borderTable = new HashMap();
    private Hashtable rolloverTable = new Hashtable();
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    private static String FOCUSED_COMP_INDEX;

    static {
        FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    }

    protected void installComponents() {
    }

    protected void installDefaults() {
        Object object;
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        if ((object = this.toolBar.getClientProperty(IS_ROLLOVER)) != null) {
            this.rolloverBorders = (Boolean)object;
        }
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        this.setRolloverBorders(this.isRolloverBorders());
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(this.toolBar, actionMap);
        }
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2].addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    protected void uninstallComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
        this.installNormalBorders(this.toolBar);
        rolloverBorder = null;
        nonRolloverBorder = null;
        nonRolloverToggleBorder = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2].removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
    }

    public boolean isFloating() {
        return this.floating;
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    protected void navigateFocusedComp(int n2) {
        int n3 = this.toolBar.getComponentCount();
        block0 : switch (n2) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n3) break;
                int n4 = this.focusedCompIndex + 1;
                while (n4 != this.focusedCompIndex) {
                    Component component;
                    if (n4 >= n3) {
                        n4 = 0;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n4++)) == null || !component.isFocusTraversable()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n3) break;
                int n5 = this.focusedCompIndex - 1;
                while (n5 != this.focusedCompIndex) {
                    Component component;
                    if (n5 < 0) {
                        n5 = n3 - 1;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n5--)) == null || !component.isFocusTraversable()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    public void setOrientation(int n2) {
        this.toolBar.setOrientation(n2);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(n2);
        }
    }

    public void setFloatingLocation(int n2, int n3) {
        this.floatingX = n2;
        this.floatingY = n3;
    }

    public void setRolloverBorders(boolean bl2) {
        this.rolloverBorders = bl2;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public void setDockingColor(Color color) {
        this.dockingColor = color;
    }

    public void setFloatingColor(Color color) {
        this.floatingColor = color;
    }

    protected void setBorderToNonRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.get(abstractButton);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(abstractButton, abstractButton.getBorder());
            }
            if (abstractButton.getBorder() instanceof UIResource) {
                if (abstractButton instanceof JToggleButton) {
                    ((JToggleButton)abstractButton).setBorder(nonRolloverToggleBorder);
                } else {
                    abstractButton.setBorder(nonRolloverBorder);
                }
            }
            this.rolloverTable.put(abstractButton, abstractButton.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            abstractButton.setRolloverEnabled(false);
        }
    }

    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.remove(abstractButton);
            abstractButton.setBorder(border);
            Boolean bl2 = (Boolean)this.rolloverTable.remove(abstractButton);
            if (bl2 != null) {
                abstractButton.setRolloverEnabled(bl2);
            }
        }
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.get(abstractButton);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(abstractButton, abstractButton.getBorder());
            }
            if (abstractButton.getBorder() instanceof UIResource) {
                abstractButton.setBorder(rolloverBorder);
            }
            this.rolloverTable.put(abstractButton, abstractButton.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            abstractButton.setRolloverEnabled(true);
        }
    }

    public void setFloating(boolean bl2, Point point) {
        if (this.toolBar.isFloatable()) {
            Object object;
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            this.floating = bl2;
            if (bl2) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                object = new Point();
                this.toolBar.getLocation((Point)object);
                this.constraintBeforeFloating = this.calculateConstraint(this.dockingSource, (Point)object);
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                this.setOrientation(0);
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).show();
                }
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                object = this.getDockingConstraint(this.dockingSource, point);
                int n2 = this.mapConstraintToOrientation((String)object);
                this.setOrientation(n2);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                this.dockingSource.add((String)object, this.toolBar);
            }
            this.dockingSource.invalidate();
            object = this.dockingSource.getParent();
            if (object != null) {
                ((Container)object).validate();
            }
            this.dockingSource.repaint();
        }
    }

    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener();
    }

    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener();
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    private int mapConstraintToOrientation(String string) {
        int n2 = this.toolBar.getOrientation();
        if (string != null) {
            if (string.equals("East") || string.equals("West")) {
                n2 = 1;
            } else if (string.equals("North") || string.equals("South")) {
                n2 = 0;
            }
        }
        return n2;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ToolBar.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("ToolBar.actionMap", actionMap);
        }
        return actionMap;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("ToolBar.ancestorInputMap");
        }
        return null;
    }

    protected void installNonRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (!(componentArray[i2] instanceof JComponent)) continue;
            ((JComponent)componentArray[i2]).updateUI();
            this.setBorderToNonRollover(componentArray[i2]);
        }
    }

    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            this.setBorderToNormal(componentArray[i2]);
        }
    }

    protected void installRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (!(componentArray[i2] instanceof JComponent)) continue;
            ((JComponent)componentArray[i2]).updateUI();
            this.setBorderToRollover(componentArray[i2]);
        }
    }

    public void installUI(JComponent jComponent) {
        this.toolBar = (JToolBar)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        jComponent.setOpaque(true);
        if (jComponent.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)jComponent.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        jComponent.putClientProperty(FOCUSED_COMP_INDEX, new Integer(this.focusedCompIndex));
    }

    protected Border createNonRolloverBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new BorderUIResource.CompoundBorderUIResource(new BasicBorders.ButtonBorder(uIDefaults.getColor("Button.shadow"), uIDefaults.getColor("Button.darkShadow"), uIDefaults.getColor("Button.light"), uIDefaults.getColor("Button.highlight")), new BasicBorders.RolloverMarginBorder());
    }

    private Border createNonRolloverToggleBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new BorderUIResource.CompoundBorderUIResource(new BasicBorders.RadioButtonBorder(uIDefaults.getColor("ToggleButton.shadow"), uIDefaults.getColor("ToggleButton.darkShadow"), uIDefaults.getColor("ToggleButton.light"), uIDefaults.getColor("ToggleButton.highlight")), new BasicBorders.RolloverMarginBorder());
    }

    protected Border createRolloverBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new BorderUIResource.CompoundBorderUIResource(new BasicBorders.RolloverButtonBorder(uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlDkShadow"), uIDefaults.getColor("controlHighlight"), uIDefaults.getColor("controlLtHighlight")), new BasicBorders.RolloverMarginBorder());
    }

    protected MouseInputListener createDockingListener() {
        return new DockingListener(this.toolBar);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public boolean canDock(Component component, Point point) {
        boolean bl2 = false;
        if (component.contains(point)) {
            int n2 = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y < this.dockingSensitivity) {
                bl2 = true;
            }
            if (point.y > component.getSize().height - this.dockingSensitivity) {
                bl2 = true;
            }
            if (point.x < this.dockingSensitivity) {
                bl2 = true;
            }
            if (point.x > component.getSize().width - this.dockingSensitivity) {
                bl2 = true;
            }
        }
        return bl2;
    }

    protected void dragTo(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Object object;
                Cloneable cloneable;
                Point point3;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((point3 = this.dragWindow.getOffset()) == null) {
                    cloneable = this.toolBar.getPreferredSize();
                    point3 = new Point(cloneable.width / 2, cloneable.height / 2);
                    this.dragWindow.setOffset(point3);
                }
                cloneable = new Point(point2.x + point.x, point2.y + point.y);
                Point point4 = new Point(((Point)cloneable).x - point3.x, ((Point)cloneable).y - point3.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                Point point5 = new Point(point2);
                SwingUtilities.convertPointFromScreen(point5, this.toolBar.getParent());
                this.constraintBeforeFloating = this.calculateConstraint(this.dockingSource, point5);
                Point point6 = this.dockingSource.getLocationOnScreen();
                Point point7 = new Point(((Point)cloneable).x - point6.x, ((Point)cloneable).y - point6.y);
                if (this.canDock(this.dockingSource, point7)) {
                    this.dragWindow.setBackground(this.getDockingColor());
                    object = this.getDockingConstraint(this.dockingSource, point7);
                    int n2 = this.mapConstraintToOrientation((String)object);
                    this.dragWindow.setOrientation(n2);
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                } else {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setOrientation(0);
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                }
                this.dragWindow.setLocation(point4.x, point4.y);
                if (!this.dragWindow.isVisible()) {
                    object = this.toolBar.getPreferredSize();
                    this.dragWindow.setSize(((Dimension)object).width, ((Dimension)object).height);
                    this.dragWindow.show();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void floatAt(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Point point3 = this.dragWindow.getOffset();
                if (point3 == null) {
                    point3 = point;
                    this.dragWindow.setOffset(point3);
                }
                Point point4 = new Point(point2.x + point.x, point2.y + point.y);
                this.setFloatingLocation(point4.x - point3.x, point4.y - point3.y);
                if (this.dockingSource != null) {
                    Point point5 = this.dockingSource.getLocationOnScreen();
                    Point point6 = new Point(point4.x - point5.x, point4.y - point5.y);
                    if (this.canDock(this.dockingSource, point6)) {
                        this.setFloating(false, point6);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        JFrame jFrame = new JFrame(jToolBar.getName(), window != null ? window.getGraphicsConfiguration() : null){

            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(this){
                    private boolean packing;
                    private final /* synthetic */ 1 this$1;

                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.this$1.pack();
                            this.packing = false;
                        }
                    }
                    {
                        this.this$1 = var1_1;
                        this.packing = false;
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        };
        jFrame.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        jFrame.addWindowListener(windowListener);
        return jFrame;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        class ToolBarDialog
        extends JDialog {
            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(this){
                    private boolean packing;
                    private final /* synthetic */ ToolBarDialog this$1;

                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.this$1.pack();
                            this.packing = false;
                        }
                    }
                    {
                        this.this$1 = toolBarDialog;
                        this.packing = false;
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }

            public ToolBarDialog(Dialog dialog, String string, boolean bl2) {
                super(dialog, string, bl2);
            }

            public ToolBarDialog(Frame frame, String string, boolean bl2) {
                super(frame, string, bl2);
            }
        }
        ToolBarDialog toolBarDialog = window instanceof Frame ? new ToolBarDialog((Frame)window, jToolBar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, jToolBar.getName(), false) : new ToolBarDialog((Frame)null, jToolBar.getName(), false));
        toolBarDialog.setTitle(jToolBar.getName());
        toolBarDialog.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        toolBarDialog.addWindowListener(windowListener);
        return toolBarDialog;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicToolBarUI();
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        Container container;
        Window window = null;
        if (this.toolBar != null) {
            for (container = this.toolBar.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container != null && container instanceof Window) {
                window = (Window)container;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            window = (Window)((Object)this.floatingToolBar);
        }
        container = new DragWindow(window);
        return container;
    }

    private String calculateConstraint(Component component, Point point) {
        if (point == null) {
            return this.constraintBeforeFloating;
        }
        String string = "North";
        if (component.contains(point)) {
            int n2 = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y >= this.dockingSource.getSize().height - this.dockingSensitivity) {
                string = "South";
            } else if (point.x < this.dockingSensitivity && this.toolBar.getOrientation() == 1) {
                string = "West";
            } else if (point.x >= this.dockingSource.getSize().width - this.dockingSensitivity && this.toolBar.getOrientation() == 1) {
                string = "East";
            } else if (point.y < this.dockingSensitivity) {
                string = "North";
            }
        }
        return string;
    }

    private String getDockingConstraint(Component component, Point point) {
        if (point == null) {
            return this.constraintBeforeFloating;
        }
        String string = "North";
        if (component.contains(point)) {
            int n2 = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y >= this.dockingSource.getSize().height - this.dockingSensitivity) {
                string = "South";
            }
            if (point.x < this.dockingSensitivity) {
                string = "West";
            }
            if (point.x >= this.dockingSource.getSize().width - this.dockingSensitivity) {
                string = "East";
            }
            if (point.y < this.dockingSensitivity) {
                string = "North";
            }
        }
        return string;
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point point = mouseEvent.getPoint();
            if (this.origin == null) {
                this.origin = mouseEvent.getComponent().getLocationOnScreen();
            }
            BasicToolBarUI.this.dragTo(point, this.origin);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point point = mouseEvent.getPoint();
                if (this.origin == null) {
                    this.origin = mouseEvent.getComponent().getLocationOnScreen();
                }
                BasicToolBarUI.this.floatAt(point, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        public DockingListener(JToolBar jToolBar) {
            this.toolBar = jToolBar;
        }
    }

    private static class DownAction
    extends KeyAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            BasicToolBarUI basicToolBarUI = (BasicToolBarUI)jToolBar.getUI();
            basicToolBarUI.navigateFocusedComp(5);
        }
    }

    protected class DragWindow
    extends Window {
        Color borderColor;
        int orientation;
        Point offset;

        public void setOrientation(int n2) {
            if (this.isShowing()) {
                if (n2 == this.orientation) {
                    return;
                }
                this.orientation = n2;
                Dimension dimension = this.getSize();
                this.setSize(new Dimension(dimension.height, dimension.width));
                if (this.offset != null) {
                    if (BasicGraphicsUtils.isLeftToRight(BasicToolBarUI.this.toolBar)) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (n2 == 0) {
                        this.setOffset(new Point(dimension.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, dimension.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(Color color) {
            if (this.borderColor == color) {
                return;
            }
            this.borderColor = color;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.getBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(color);
            super.paint(graphics);
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        DragWindow(Window window) {
            super(window);
            this.borderColor = Color.gray;
            this.orientation = BasicToolBarUI.this.toolBar.getOrientation();
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            if (BasicToolBarUI.this.toolBar.isFloatable()) {
                if (BasicToolBarUI.this.dragWindow != null) {
                    BasicToolBarUI.this.dragWindow.setVisible(false);
                }
                BasicToolBarUI.this.floating = false;
                if (BasicToolBarUI.this.floatingToolBar == null) {
                    BasicToolBarUI.this.floatingToolBar = BasicToolBarUI.this.createFloatingWindow(BasicToolBarUI.this.toolBar);
                }
                if (BasicToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)BasicToolBarUI.this.floatingToolBar)).setVisible(false);
                }
                BasicToolBarUI.this.floatingToolBar.getContentPane().remove(BasicToolBarUI.this.toolBar);
                String string = BasicToolBarUI.this.constraintBeforeFloating;
                int n2 = BasicToolBarUI.this.mapConstraintToOrientation(string);
                BasicToolBarUI.this.setOrientation(n2);
                if (BasicToolBarUI.this.dockingSource == null) {
                    BasicToolBarUI.this.dockingSource = BasicToolBarUI.this.toolBar.getParent();
                }
                if (BasicToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(BasicToolBarUI.this.propertyListener);
                }
                BasicToolBarUI.this.dockingSource.add(string, BasicToolBarUI.this.toolBar);
                BasicToolBarUI.this.dockingSource.invalidate();
                Container container = BasicToolBarUI.this.dockingSource.getParent();
                if (container != null) {
                    container.validate();
                }
                BasicToolBarUI.this.dockingSource.repaint();
                BasicToolBarUI.this.setFloating(false, null);
            }
        }

        protected FrameListener() {
        }
    }

    private static abstract class KeyAction
    extends AbstractAction {
        private KeyAction() {
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private static class LeftAction
    extends KeyAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            BasicToolBarUI basicToolBarUI = (BasicToolBarUI)jToolBar.getUI();
            basicToolBarUI.navigateFocusedComp(7);
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("lookAndFeel")) {
                BasicToolBarUI.this.toolBar.updateUI();
            } else if (string.equals("orientation")) {
                Component[] componentArray = BasicToolBarUI.this.toolBar.getComponents();
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                for (int i2 = 0; i2 < componentArray.length; ++i2) {
                    if (!(componentArray[i2] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)componentArray[i2];
                    if (n2 == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension dimension = separator.getSeparatorSize();
                    if (dimension == null || dimension.width == dimension.height) continue;
                    Dimension dimension2 = new Dimension(dimension.height, dimension.width);
                    separator.setSeparatorSize(dimension2);
                }
            } else if (string.equals(IS_ROLLOVER)) {
                BasicToolBarUI.this.setRolloverBorders((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        protected PropertyListener() {
        }
    }

    private static class RightAction
    extends KeyAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            BasicToolBarUI basicToolBarUI = (BasicToolBarUI)jToolBar.getUI();
            basicToolBarUI.navigateFocusedComp(3);
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                component.addFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
            if (BasicToolBarUI.this.isRolloverBorders()) {
                BasicToolBarUI.this.setBorderToRollover(component);
            } else {
                BasicToolBarUI.this.setBorderToNonRollover(component);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                component.removeFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
            BasicToolBarUI.this.setBorderToNormal(component);
        }

        protected ToolBarContListener() {
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            BasicToolBarUI.this.focusedCompIndex = BasicToolBarUI.this.toolBar.getComponentIndex(component);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        protected ToolBarFocusListener() {
        }
    }

    private static class UpAction
    extends KeyAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            BasicToolBarUI basicToolBarUI = (BasicToolBarUI)jToolBar.getUI();
            basicToolBarUI.navigateFocusedComp(1);
        }
    }
}

