/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LEDataOutputStream;
import org.eclipse.swt.internal.image.LZWNode;

final class LZWCodec {
    int bitsPerPixel;
    int blockSize;
    int blockIndex;
    int currentByte;
    int bitsLeft;
    int codeSize;
    int clearCode;
    int endCode;
    int newCodes;
    int topSlot;
    int currentSlot;
    int imageWidth;
    int imageHeight;
    int imageX;
    int imageY;
    int pass;
    int line;
    int codeMask;
    byte[] block;
    byte[] lineArray;
    int[] stack;
    int[] suffix;
    int[] prefix;
    LZWNode[] nodeStack;
    LEDataInputStream inputStream;
    LEDataOutputStream outputStream;
    ImageData image;
    ImageLoader loader;
    boolean interlaced;
    static final int[] MASK_TABLE = new int[]{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095};

    LZWCodec() {
    }

    void decode() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = new byte[this.imageWidth];
        int n5 = 0;
        int n6 = 0;
        while ((n2 = this.nextCode()) != this.endCode) {
            if (n2 == this.clearCode) {
                this.codeSize = this.bitsPerPixel + 1;
                this.codeMask = MASK_TABLE[this.bitsPerPixel];
                this.currentSlot = this.newCodes;
                this.topSlot = 1 << this.codeSize;
                while ((n2 = this.nextCode()) == this.clearCode) {
                }
                if (n2 == this.endCode) continue;
                n3 = n4 = n2;
                byArray[n6] = (byte)n2;
                if (++n6 != this.imageWidth) continue;
                this.nextPutPixels(byArray);
                n6 = 0;
                continue;
            }
            int n7 = n2;
            if (n7 >= this.currentSlot) {
                n7 = n3;
                this.stack[n5] = n4;
                ++n5;
            }
            while (n7 >= this.newCodes) {
                this.stack[n5] = this.suffix[n7];
                ++n5;
                n7 = this.prefix[n7];
            }
            this.stack[n5] = n7;
            ++n5;
            if (this.currentSlot < this.topSlot) {
                this.suffix[this.currentSlot] = n4 = n7;
                this.prefix[this.currentSlot] = n3;
                ++this.currentSlot;
                n3 = n2;
            }
            if (this.currentSlot >= this.topSlot && this.codeSize < 12) {
                this.codeMask = MASK_TABLE[this.codeSize];
                ++this.codeSize;
                this.topSlot += this.topSlot;
            }
            while (n5 > 0) {
                byArray[n6] = (byte)this.stack[--n5];
                if (++n6 != this.imageWidth) continue;
                this.nextPutPixels(byArray);
                n6 = 0;
            }
        }
        if (n6 != 0 && this.line < this.imageHeight) {
            this.nextPutPixels(byArray);
        }
    }

    public void decode(LEDataInputStream lEDataInputStream, ImageLoader imageLoader, ImageData imageData, boolean bl2, int n2) {
        this.inputStream = lEDataInputStream;
        this.loader = imageLoader;
        this.image = imageData;
        this.interlaced = bl2;
        this.bitsPerPixel = n2;
        this.initializeForDecoding();
        this.decode();
    }

    void encode() {
        this.nextPutCode(this.clearCode);
        int n2 = this.encodeLoop();
        this.nextPutCode(n2);
        this.nextPutCode(this.endCode);
        this.block[0] = this.bitsLeft == 8 ? (byte)(this.blockIndex - 1) : (byte)this.blockIndex;
        this.writeBlock();
        if (this.block[0] != 0) {
            this.block[0] = 0;
            this.writeBlock();
        }
    }

    public void encode(LEDataOutputStream lEDataOutputStream, ImageData imageData) {
        this.outputStream = lEDataOutputStream;
        this.image = imageData;
        this.initializeForEncoding();
        this.encode();
    }

    /*
     * Unable to fully structure code
     */
    int encodeLoop() {
        var1_1 = this.nextPixel();
        while (true) {
            var4_4 = var1_1;
            var3_3 = this.nodeStack[var4_4];
            var2_2 = true;
            var1_1 = this.nextPixel();
            if (var1_1 >= 0) ** GOTO lbl27
            return var4_4;
lbl-1000:
            // 1 sources

            {
                var3_3 = var3_3.children;
                while (var2_2 && var3_3.suffix != var1_1) {
                    if (var1_1 < var3_3.suffix) {
                        if (var3_3.left == null) {
                            var3_3.left = new LZWNode();
                            var2_2 = false;
                        }
                        var3_3 = var3_3.left;
                        continue;
                    }
                    if (var3_3.right == null) {
                        var3_3.right = new LZWNode();
                        var2_2 = false;
                    }
                    var3_3 = var3_3.right;
                }
                if (!var2_2) continue;
                var4_4 = var3_3.code;
                var1_1 = this.nextPixel();
                if (var1_1 >= 0) continue;
                return var4_4;
lbl27:
                // 3 sources

                ** while (var2_2 && var3_3.children != null)
            }
lbl28:
            // 1 sources

            if (var2_2) {
                var3_3 = var3_3.children = new LZWNode();
            }
            var3_3.children = null;
            var3_3.left = null;
            var3_3.right = null;
            var3_3.code = this.currentSlot++;
            var3_3.prefix = var4_4;
            var3_3.suffix = var1_1;
            this.nextPutCode(var4_4);
            if (this.currentSlot < 4096) {
                if (this.currentSlot <= this.topSlot) continue;
                ++this.codeSize;
                this.codeMask = LZWCodec.MASK_TABLE[this.codeSize - 1];
                this.topSlot *= 2;
                continue;
            }
            this.nextPutCode(this.clearCode);
            var5_5 = 0;
            while (var5_5 < this.nodeStack.length) {
                this.nodeStack[var5_5].children = null;
                ++var5_5;
            }
            this.codeSize = this.bitsPerPixel + 1;
            this.codeMask = LZWCodec.MASK_TABLE[this.codeSize - 1];
            this.currentSlot = this.newCodes;
            this.topSlot = 1 << this.codeSize;
        }
    }

    void initializeForDecoding() {
        this.pass = 1;
        this.line = 0;
        this.codeSize = this.bitsPerPixel + 1;
        this.topSlot = 1 << this.codeSize;
        this.clearCode = 1 << this.bitsPerPixel;
        this.endCode = this.clearCode + 1;
        this.newCodes = this.currentSlot = this.endCode + 1;
        this.currentByte = -1;
        this.bitsLeft = 0;
        this.blockSize = 0;
        this.blockIndex = 0;
        this.codeMask = MASK_TABLE[this.codeSize - 1];
        this.stack = new int[4096];
        this.suffix = new int[4096];
        this.prefix = new int[4096];
        this.block = new byte[256];
        this.imageWidth = this.image.width;
        this.imageHeight = this.image.height;
    }

    void initializeForEncoding() {
        this.interlaced = false;
        this.bitsPerPixel = this.image.depth;
        this.codeSize = this.bitsPerPixel + 1;
        this.topSlot = 1 << this.codeSize;
        this.clearCode = 1 << this.bitsPerPixel;
        this.endCode = this.clearCode + 1;
        this.newCodes = this.currentSlot = this.endCode + 1;
        this.bitsLeft = 8;
        this.currentByte = 0;
        this.blockIndex = 1;
        this.blockSize = 255;
        this.block = new byte[this.blockSize];
        this.block[0] = (byte)(this.blockSize - 1);
        this.nodeStack = new LZWNode[1 << this.bitsPerPixel];
        int n2 = 0;
        while (n2 < this.nodeStack.length) {
            LZWNode lZWNode = new LZWNode();
            lZWNode.code = n2 + 1;
            lZWNode.prefix = -1;
            lZWNode.suffix = n2 + 1;
            this.nodeStack[n2] = lZWNode;
            ++n2;
        }
        this.imageWidth = this.image.width;
        this.imageHeight = this.image.height;
        this.imageY = -1;
        this.lineArray = new byte[this.imageWidth];
        this.imageX = this.imageWidth + 1;
    }

    int nextCode() {
        int n2;
        if (this.bitsLeft == 0) {
            if (this.blockIndex >= this.blockSize) {
                this.blockSize = this.readBlock();
                this.blockIndex = 0;
                if (this.blockSize == 0) {
                    return this.endCode;
                }
            }
            ++this.blockIndex;
            this.currentByte = this.block[this.blockIndex] & 0xFF;
            this.bitsLeft = 8;
            n2 = this.currentByte;
        } else {
            int n3 = this.bitsLeft - 8;
            n2 = n3 < 0 ? this.currentByte >> 0 - n3 : this.currentByte << n3;
        }
        while (this.codeSize > this.bitsLeft) {
            if (this.blockIndex >= this.blockSize) {
                this.blockSize = this.readBlock();
                this.blockIndex = 0;
                if (this.blockSize == 0) {
                    return this.endCode;
                }
            }
            ++this.blockIndex;
            this.currentByte = this.block[this.blockIndex] & 0xFF;
            n2 += this.currentByte << this.bitsLeft;
            this.bitsLeft += 8;
        }
        this.bitsLeft -= this.codeSize;
        return n2 & this.codeMask;
    }

    int nextPixel() {
        ++this.imageX;
        if (this.imageX > this.imageWidth) {
            ++this.imageY;
            if (this.imageY >= this.imageHeight) {
                return -1;
            }
            this.nextPixels(this.lineArray, this.imageWidth);
            this.imageX = 1;
        }
        return this.lineArray[this.imageX - 1] & 0xFF;
    }

    void nextPixels(byte[] byArray, int n2) {
        if (this.image.depth == 8) {
            System.arraycopy(this.image.data, this.imageY * this.image.bytesPerLine, byArray, 0, n2);
        } else {
            this.image.getPixels(0, this.imageY, n2, byArray, 0);
        }
    }

    void nextPutCode(int n2) {
        int n3 = n2;
        int n4 = this.codeSize;
        int n5 = n3 & MASK_TABLE[this.bitsLeft - 1];
        this.currentByte |= n5 << 8 - this.bitsLeft;
        this.block[this.blockIndex] = (byte)this.currentByte;
        if ((n4 -= this.bitsLeft) < 1) {
            this.bitsLeft -= this.codeSize;
            if (this.bitsLeft == 0) {
                this.bitsLeft = 8;
                ++this.blockIndex;
                if (this.blockIndex >= this.blockSize) {
                    this.writeBlock();
                    this.blockIndex = 1;
                }
                this.currentByte = 0;
            }
            return;
        }
        n3 >>= this.bitsLeft;
        ++this.blockIndex;
        if (this.blockIndex >= this.blockSize) {
            this.writeBlock();
            this.blockIndex = 1;
        }
        while (n4 >= 8) {
            this.currentByte = n3 & 0xFF;
            this.block[this.blockIndex] = (byte)this.currentByte;
            n3 >>= 8;
            n4 -= 8;
            ++this.blockIndex;
            if (this.blockIndex < this.blockSize) continue;
            this.writeBlock();
            this.blockIndex = 1;
        }
        this.bitsLeft = 8 - n4;
        this.currentByte = n3;
        this.block[this.blockIndex] = (byte)this.currentByte;
    }

    void nextPutPixels(byte[] byArray) {
        if (this.image.depth == 8) {
            int n2 = this.line * this.image.bytesPerLine;
            int n3 = 0;
            while (n3 < this.imageWidth) {
                this.image.data[n2 + n3] = byArray[n3];
                ++n3;
            }
        } else {
            this.image.setPixels(0, this.line, this.imageWidth, byArray, 0);
        }
        if (this.interlaced) {
            if (this.pass == 1) {
                this.copyRow(byArray, 7);
                this.line += 8;
            } else if (this.pass == 2) {
                this.copyRow(byArray, 3);
                this.line += 8;
            } else if (this.pass == 3) {
                this.copyRow(byArray, 1);
                this.line += 4;
            } else if (this.pass == 4) {
                this.line += 2;
            } else if (this.pass == 5) {
                this.line += 0;
            }
            if (this.line >= this.imageHeight) {
                ++this.pass;
                if (this.pass == 2) {
                    this.line = 4;
                } else if (this.pass == 3) {
                    this.line = 2;
                } else if (this.pass == 4) {
                    this.line = 1;
                } else if (this.pass == 5) {
                    this.line = 0;
                }
                if (this.pass < 5 && this.loader.hasListeners()) {
                    ImageData imageData = (ImageData)this.image.clone();
                    this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, this.pass - 2, false));
                }
            }
            if (this.line >= this.imageHeight) {
                this.line = 0;
            }
        } else {
            ++this.line;
        }
    }

    void copyRow(byte[] byArray, int n2) {
        int n3 = 1;
        while (n3 <= n2) {
            if (this.line + n3 < this.imageHeight) {
                this.image.setPixels(0, this.line + n3, this.imageWidth, byArray, 0);
            }
            ++n3;
        }
    }

    int readBlock() {
        int n2 = -1;
        try {
            n2 = this.inputStream.read();
            if (n2 == -1) {
                SWT.error(40);
            }
            this.block[0] = (byte)n2;
            if ((n2 = this.inputStream.read(this.block, 1, n2)) == -1) {
                SWT.error(40);
            }
        }
        catch (Exception exception) {
            SWT.error(39, exception);
        }
        return n2;
    }

    void writeBlock() {
        try {
            this.outputStream.write(this.block, 0, (this.block[0] & 0xFF) + 1);
        }
        catch (Exception exception) {
            SWT.error(39, exception);
        }
    }
}

