/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Tray
extends Widget {
    int itemCount;
    TrayItem[] items = new TrayItem[4];

    Tray(Display display, int n2) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
    }

    void createItem(TrayItem trayItem, int n2) {
        if (n2 < 0 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TrayItem[] trayItemArray = new TrayItem[this.items.length + 4];
            System.arraycopy(this.items, 0, trayItemArray, 0, this.items.length);
            this.items = trayItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount++ - n2);
        this.items[n2] = trayItem;
    }

    void destroyItem(TrayItem trayItem) {
        int n2 = 0;
        while (n2 < this.itemCount) {
            if (this.items[n2] == trayItem) break;
            ++n2;
        }
        if (n2 == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
    }

    public TrayItem getItem(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 >= this.itemCount) {
            this.error(6);
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TrayItem[] getItems() {
        this.checkWidget();
        TrayItem[] trayItemArray = new TrayItem[this.itemCount];
        System.arraycopy(this.items, 0, trayItemArray, 0, trayItemArray.length);
        return trayItemArray;
    }

    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                TrayItem trayItem = this.items[n2];
                if (trayItem != null && !trayItem.isDisposed()) {
                    trayItem.release(false);
                }
                ++n2;
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.display.tray == this) {
            this.display.tray = null;
        }
    }
}

