/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;

public abstract class AbstractController
implements Controller {
    static final int EVENT_QUEUE_DEPTH = 32;
    private static final Event event = new Event();
    private final String name;
    private final Component[] components;
    private final Controller[] children;
    private final Rumbler[] rumblers;
    private final Map id_to_components = new HashMap();
    private EventQueue event_queue = new EventQueue(32);

    protected AbstractController(String string, Component[] componentArray, Controller[] controllerArray, Rumbler[] rumblerArray) {
        this.name = string;
        this.components = componentArray;
        this.children = controllerArray;
        this.rumblers = rumblerArray;
        for (int i2 = componentArray.length - 1; i2 >= 0; --i2) {
            this.id_to_components.put(componentArray[i2].getIdentifier(), componentArray[i2]);
        }
    }

    public final Controller[] getControllers() {
        return this.children;
    }

    public final Component[] getComponents() {
        return this.components;
    }

    public final Component getComponent(Component.Identifier identifier) {
        return (Component)this.id_to_components.get(identifier);
    }

    public final Rumbler[] getRumblers() {
        return this.rumblers;
    }

    public Controller.PortType getPortType() {
        return Controller.PortType.UNKNOWN;
    }

    public int getPortNumber() {
        return 0;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Controller.Type getType() {
        return Controller.Type.UNKNOWN;
    }

    public final void setEventQueueSize(int n2) {
        try {
            this.setDeviceEventQueueSize(n2);
            this.event_queue = new EventQueue(n2);
            return;
        }
        catch (IOException iOException) {
            ControllerEnvironment.logln("Failed to create new event queue of size " + n2 + ": " + iOException);
            return;
        }
    }

    protected void setDeviceEventQueueSize(int n2) throws IOException {
    }

    public final EventQueue getEventQueue() {
        return this.event_queue;
    }

    protected abstract boolean getNextDeviceEvent(Event var1) throws IOException;

    protected void pollDevice() throws IOException {
    }

    public synchronized boolean poll() {
        Component[] componentArray = this.getComponents();
        try {
            this.pollDevice();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                float f2;
                AbstractComponent abstractComponent;
                AbstractComponent abstractComponent2 = (AbstractComponent)componentArray[i2];
                if (abstractComponent2.isRelative()) {
                    abstractComponent = abstractComponent2;
                    f2 = 0.0f;
                } else {
                    float f3 = abstractComponent2.poll();
                    abstractComponent = abstractComponent2;
                    f2 = f3;
                }
                abstractComponent.setPollData(f2);
            }
            while (this.getNextDeviceEvent(event)) {
                AbstractComponent abstractComponent = (AbstractComponent)event.getComponent();
                float f4 = event.getValue();
                if (abstractComponent.isRelative()) {
                    if (f4 == 0.0f) continue;
                    abstractComponent.setPollData(abstractComponent.getPollData() + f4);
                } else {
                    if (f4 == abstractComponent.getEventValue()) continue;
                    abstractComponent.setEventValue(f4);
                }
                if (this.event_queue.isFull()) continue;
                this.event_queue.add(event);
            }
            return true;
        }
        catch (IOException iOException) {
            ControllerEnvironment.logln("Failed to poll device: " + iOException.getMessage());
            return false;
        }
    }
}

