/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    static final int INSET = 3;
    static final int ListProc;
    static final TCHAR ListClass;

    static {
        ListClass = new TCHAR(0, "LISTBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ListClass, wNDCLASS);
        ListProc = wNDCLASS.lpfnWndProc;
    }

    public List(Composite composite, int n2) {
        super(composite, List.checkStyle(n2));
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = OS.SendMessage(this.handle, 384, 0, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n2 == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n2) {
        TCHAR tCHAR;
        int n3;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n2 == -1) {
            this.error(6);
        }
        if ((n3 = OS.SendMessage(this.handle, 385, n2, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2) {
            this.error(14);
        }
        if (n3 == -1) {
            int n4 = OS.SendMessage(this.handle, 395, 0, 0);
            if (n2 >= 0 && n2 <= n4) {
                this.error(14);
            } else {
                this.error(6);
            }
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ListProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        return List.checkBits(n2, 4, 2, 0, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        this.checkWidget();
        int n6 = 0;
        int n7 = 0;
        if (n2 == -1) {
            if ((this.style & 0x100) != 0) {
                n6 = OS.SendMessage(this.handle, 403, 0, 0);
                n6 -= 3;
            } else {
                n5 = OS.SendMessage(this.handle, 395, 0, 0);
                int n8 = 0;
                int n9 = OS.GetDC(this.handle);
                n4 = OS.SendMessage(this.handle, 49, 0, 0);
                if (n4 != 0) {
                    n8 = OS.SelectObject(n9, n4);
                }
                RECT rECT = new RECT();
                int n10 = 3104;
                int n11 = this.getCodePage();
                TCHAR tCHAR = new TCHAR(n11, 65);
                int n12 = 0;
                while (n12 < n5) {
                    int n13 = OS.SendMessage(this.handle, 394, n12, 0);
                    if (n13 != -1) {
                        int n14;
                        if (n13 + 1 > tCHAR.length()) {
                            tCHAR = new TCHAR(n11, n13 + 1);
                        }
                        if ((n14 = OS.SendMessage(this.handle, 393, n12, tCHAR)) != -1) {
                            OS.DrawText(n9, tCHAR, n13, rECT, n10);
                            n6 = Math.max(n6, rECT.right - rECT.left);
                        }
                    }
                    ++n12;
                }
                if (n4 != 0) {
                    OS.SelectObject(n9, n8);
                }
                OS.ReleaseDC(this.handle, n9);
            }
        }
        if (n3 == -1) {
            n5 = OS.SendMessage(this.handle, 395, 0, 0);
            n4 = OS.SendMessage(this.handle, 417, 0, 0);
            n7 = n5 * n4;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        if (n3 != -1) {
            n7 = n3;
        }
        n5 = this.getBorderWidth();
        n6 += n5 * 2 + 3;
        n7 += n5 * 2;
        if ((this.style & 0x200) != 0) {
            n6 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n7 += OS.GetSystemMetrics(3);
        }
        return new Point(n6, n7);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n2 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n2 == -1) {
                return;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                if (n2 == nArray[n3]) {
                    OS.SendMessage(this.handle, 390, -1, 0);
                    return;
                }
                ++n3;
            }
            return;
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            if (n5 != -1) {
                OS.SendMessage(this.handle, 389, 0, n5);
            }
            ++n4;
        }
    }

    public void deselect(int n2) {
        this.checkWidget();
        if (n2 == -1) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n3 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n3 == -1) {
                return;
            }
            if (n3 == n2) {
                OS.SendMessage(this.handle, 390, -1, 0);
            }
            return;
        }
        OS.SendMessage(this.handle, 389, 0, n2);
    }

    public void deselect(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n4 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n4 == -1) {
                return;
            }
            if (n2 <= n4 && n4 <= n3) {
                OS.SendMessage(this.handle, 390, -1, 0);
            }
            return;
        }
        int n5 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 < 0 && n3 < 0) {
            return;
        }
        if (n2 >= n5 && n3 >= n5) {
            return;
        }
        n2 = Math.min(n5 - 1, Math.max(0, n2));
        n3 = Math.min(n5 - 1, Math.max(0, n3));
        OS.SendMessage(this.handle, 387, n3, n2);
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.SendMessage(this.handle, 390, -1, 0);
        } else {
            OS.SendMessage(this.handle, 389, 0, -1);
        }
    }

    public int getFocusIndex() {
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 415, 0, 0);
        if (n3 == 0 && (n2 = OS.SendMessage(this.handle, 395, 0, 0)) == 0) {
            return -1;
        }
        return n3;
    }

    public String getItem(int n2) {
        TCHAR tCHAR;
        int n3;
        this.checkWidget();
        int n4 = OS.SendMessage(this.handle, 394, n2, 0);
        if (n4 != -1 && (n3 = OS.SendMessage(this.handle, 393, n2, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) != -1) {
            return tCHAR.toString(0, n4);
        }
        int n5 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 >= 0 && n2 < n5) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 == -1) {
            this.error(36);
        }
        return n2;
    }

    public int getItemHeight() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 417, 0, 0);
        if (n2 == -1) {
            this.error(11);
        }
        return n2;
    }

    public String[] getItems() {
        this.checkWidget();
        int n2 = this.getItemCount();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = this.getItem(n3);
            ++n3;
        }
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = this.getSelectionIndices();
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            stringArray[n2] = this.getItem(nArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n2 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n2 == -1) {
                return 0;
            }
            return 1;
        }
        int n3 = OS.SendMessage(this.handle, 400, 0, 0);
        if (n3 == -1) {
            this.error(36);
        }
        return n3;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 392, 0, 0);
        }
        int n2 = OS.SendMessage(this.handle, 400, 0, 0);
        if (n2 == -1) {
            this.error(9);
        }
        if (n2 == 0) {
            return -1;
        }
        int n3 = OS.SendMessage(this.handle, 415, 0, 0);
        int n4 = OS.SendMessage(this.handle, 391, n3, 0);
        if (n4 == -1) {
            this.error(9);
        }
        if (n4 != 0) {
            return n3;
        }
        int[] nArray = new int[1];
        n4 = OS.SendMessage(this.handle, 401, 1, nArray);
        if (n4 != 1) {
            this.error(9);
        }
        return nArray[0];
    }

    public int[] getSelectionIndices() {
        int[] nArray;
        int n2;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n3 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n3 == -1) {
                return new int[0];
            }
            return new int[]{n3};
        }
        int n4 = OS.SendMessage(this.handle, 400, 0, 0);
        if (n4 == -1) {
            this.error(9);
        }
        if ((n2 = OS.SendMessage(this.handle, 401, n4, nArray = new int[n4])) != n4) {
            this.error(9);
        }
        return nArray;
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 398, 0, 0);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n3 = this.getItemCount();
            int n4 = n2;
            while (n4 < n3) {
                if (string.equals(this.getItem(n4))) {
                    return n4;
                }
                ++n4;
            }
            return -1;
        }
        int n5 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 < 0 || n2 >= n5) {
            return -1;
        }
        int n6 = n2 - 1;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            int n7;
            if ((n6 = OS.SendMessage(this.handle, 418, n7 = n6, tCHAR)) != -1 && n6 > n7) continue;
            return -1;
        } while (!string.equals(this.getItem(n6)));
        return n6;
    }

    public boolean isSelected(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 391, n2, 0);
        return n3 != 0 && n3 != -1;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = nArray2[nArray2.length - 1];
        int n3 = nArray2[0];
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 < 0 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        int n5 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n6 = OS.GetDC(this.handle);
            n8 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n8 != 0) {
                n7 = OS.SelectObject(n6, n8);
            }
        }
        int n10 = this.getCodePage();
        int n11 = 0;
        int n12 = 0;
        int n13 = -1;
        while (n11 < nArray2.length) {
            int n14 = nArray2[n11];
            if (n14 != n13) {
                int n15;
                int n16;
                TCHAR tCHAR = null;
                if ((this.style & 0x100) != 0 && ((n16 = OS.SendMessage(this.handle, 394, n14, 0)) == -1 || (n15 = OS.SendMessage(this.handle, 393, n14, tCHAR = new TCHAR(n10, n16 + 1))) == -1) || (n16 = OS.SendMessage(this.handle, 386, n14, 0)) == -1) break;
                if ((this.style & 0x100) != 0) {
                    n15 = 3104;
                    OS.DrawText(n6, tCHAR, -1, rECT, n15);
                    n9 = Math.max(n9, rECT.right - rECT.left);
                }
                if (n14 < n5) {
                    ++n12;
                }
                n13 = n14;
            }
            ++n11;
        }
        if ((this.style & 0x100) != 0) {
            if (n8 != 0) {
                OS.SelectObject(n6, n7);
            }
            OS.ReleaseDC(this.handle, n6);
            this.setScrollWidth(n9, false);
        }
        if (n12 > 0) {
            OS.SendMessage(this.handle, 407, n5 -= n12, 0);
        }
        if (n11 < nArray2.length) {
            this.error(15);
        }
    }

    public void remove(int n2) {
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n5 = OS.SendMessage(this.handle, 394, n2, 0);
            if (n5 == -1) {
                n4 = OS.SendMessage(this.handle, 395, 0, 0);
                if (n2 >= 0 && n2 < n4) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n4 = OS.SendMessage(this.handle, 393, n2, tCHAR = new TCHAR(this.getCodePage(), n5 + 1))) == -1) {
                n3 = OS.SendMessage(this.handle, 395, 0, 0);
                if (n2 >= 0 && n2 < n3) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n5 = OS.SendMessage(this.handle, 398, 0, 0);
        n4 = OS.SendMessage(this.handle, 386, n2, 0);
        if (n4 == -1) {
            n3 = OS.SendMessage(this.handle, 395, 0, 0);
            if (n2 >= 0 && n2 < n3) {
                this.error(15);
            }
            this.error(6);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, false);
        }
        if (n2 < n5) {
            OS.SendMessage(this.handle, 407, n5 - 1, 0);
        }
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 < 0 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        if (n2 == 0 && n3 == n4 - 1) {
            this.removeAll();
            return;
        }
        int n5 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n6 = OS.GetDC(this.handle);
            n8 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n8 != 0) {
                n7 = OS.SelectObject(n6, n8);
            }
        }
        int n10 = this.getCodePage();
        int n11 = n2;
        int n12 = 3104;
        while (n11 <= n3) {
            int n13;
            int n14;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n14 = OS.SendMessage(this.handle, 394, n2, 0)) == -1 || (n13 = OS.SendMessage(this.handle, 393, n2, tCHAR = new TCHAR(n10, n14 + 1))) == -1) || (n14 = OS.SendMessage(this.handle, 386, n2, 0)) == -1) break;
            if ((this.style & 0x100) != 0) {
                OS.DrawText(n6, tCHAR, -1, rECT, n12);
                n9 = Math.max(n9, rECT.right - rECT.left);
            }
            ++n11;
        }
        if ((this.style & 0x100) != 0) {
            if (n8 != 0) {
                OS.SelectObject(n6, n7);
            }
            OS.ReleaseDC(this.handle, n6);
            this.setScrollWidth(n9, false);
        }
        if (n3 < n5) {
            OS.SendMessage(this.handle, 407, n5 -= n3 - n2 + 1, 0);
        }
        if (n11 <= n3) {
            this.error(15);
        }
    }

    public void remove(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n2);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 388, 0, 0);
        if ((this.style & 0x100) != 0) {
            OS.SendMessage(this.handle, 404, 0, 0);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray, false);
    }

    void select(int[] nArray, boolean bl2) {
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (n3 != -1) {
                this.select(n3, false);
            }
            ++n2;
        }
        if (bl2) {
            this.showSelection();
        }
    }

    public void select(int n2) {
        this.checkWidget();
        this.select(n2, false);
    }

    void select(int n2, boolean bl2) {
        boolean bl3;
        if (n2 < 0) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 >= n3) {
            return;
        }
        if (bl2) {
            if ((this.style & 4) != 0) {
                OS.SendMessage(this.handle, 390, n2, 0);
            } else {
                OS.SendMessage(this.handle, 389, 1, n2);
            }
            return;
        }
        int n4 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = new RECT();
        RECT rECT2 = null;
        OS.SendMessage(this.handle, 408, n2, rECT);
        boolean bl4 = bl3 = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (bl3) {
            OS.UpdateWindow(this.handle);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        int n5 = -1;
        if ((this.style & 4) != 0) {
            int n6 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n6 != -1) {
                rECT2 = new RECT();
                OS.SendMessage(this.handle, 408, n6, rECT2);
            }
            OS.SendMessage(this.handle, 390, n2, 0);
        } else {
            n5 = OS.SendMessage(this.handle, 415, 0, 0);
            OS.SendMessage(this.handle, 389, 1, n2);
        }
        if ((this.style & 2) != 0 && n5 != -1) {
            OS.SendMessage(this.handle, 414, n5, 0);
        }
        OS.SendMessage(this.handle, 407, n4, 0);
        if (bl3) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.ValidateRect(this.handle, null);
            OS.InvalidateRect(this.handle, rECT, true);
            if (rECT2 != null) {
                OS.InvalidateRect(this.handle, rECT2, true);
            }
        }
    }

    public void select(int n2, int n3) {
        this.checkWidget();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        if ((this.style & 4) != 0) {
            this.select(n2, false);
        } else {
            this.select(n2, n3, false);
        }
    }

    void select(int n2, int n3, boolean bl2) {
        if (n2 == n3) {
            this.select(n2, bl2);
            return;
        }
        OS.SendMessage(this.handle, 387, n2, n3);
        if (bl2) {
            this.showSelection();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 389, 1, -1);
    }

    void setFocusIndex(int n2) {
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 < 0 || n2 >= n3) {
            return;
        }
        OS.SendMessage(this.handle, 414, n2, 0);
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getTopIndex();
        boolean bl2 = this.isSelected(n2);
        this.remove(n2);
        this.add(string, n2);
        if (bl2) {
            this.select(n2, false);
        }
        this.setTopIndex(n3);
    }

    public void setItems(String[] stringArray) {
        boolean bl2;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                this.error(5);
            }
            ++n2;
        }
        n2 = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, ListProc);
        boolean bl3 = bl2 = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (bl2) {
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        RECT rECT = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n3 = OS.GetDC(this.handle);
            n5 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n5 != 0) {
                n4 = OS.SelectObject(n3, n5);
            }
            OS.SendMessage(this.handle, 404, 0, 0);
        }
        int n7 = stringArray.length;
        OS.SendMessage(this.handle, 388, 0, 0);
        OS.SendMessage(this.handle, 424, n7, n7 * 32);
        int n8 = 0;
        int n9 = this.getCodePage();
        while (n8 < n7) {
            String string = stringArray[n8];
            TCHAR tCHAR = new TCHAR(n9, string, true);
            int n10 = OS.SendMessage(this.handle, 384, 0, tCHAR);
            if (n10 == -1 || n10 == -2) break;
            if ((this.style & 0x100) != 0) {
                int n11 = 3104;
                OS.DrawText(n3, tCHAR, -1, rECT, n11);
                n6 = Math.max(n6, rECT.right - rECT.left);
            }
            ++n8;
        }
        if ((this.style & 0x100) != 0) {
            if (n5 != 0) {
                OS.SelectObject(n3, n4);
            }
            OS.ReleaseDC(this.handle, n3);
            OS.SendMessage(this.handle, 404, n6 + 3, 0);
        }
        if (bl2) {
            OS.SendMessage(this.handle, 11, 1, 0);
        }
        OS.SetWindowLong(this.handle, -4, n2);
        if (n8 < stringArray.length) {
            this.error(14);
        }
    }

    void setScrollWidth() {
        int n2 = 0;
        RECT rECT = new RECT();
        int n3 = 0;
        int n4 = OS.GetDC(this.handle);
        int n5 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n5 != 0) {
            n3 = OS.SelectObject(n4, n5);
        }
        int n6 = this.getCodePage();
        int n7 = OS.SendMessage(this.handle, 395, 0, 0);
        int n8 = 3104;
        int n9 = 0;
        while (n9 < n7) {
            TCHAR tCHAR;
            int n10;
            int n11 = OS.SendMessage(this.handle, 394, n9, 0);
            if (n11 != -1 && (n10 = OS.SendMessage(this.handle, 393, n9, tCHAR = new TCHAR(n6, n11 + 1))) != -1) {
                OS.DrawText(n4, tCHAR, -1, rECT, n8);
                n2 = Math.max(n2, rECT.right - rECT.left);
            }
            ++n9;
        }
        if (n5 != 0) {
            OS.SelectObject(n4, n3);
        }
        OS.ReleaseDC(this.handle, n4);
        OS.SendMessage(this.handle, 404, n2 + 3, 0);
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl2) {
        RECT rECT = new RECT();
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        int n5 = 3104;
        OS.DrawText(n3, tCHAR, -1, rECT, n5);
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        this.setScrollWidth(rECT.right - rECT.left, bl2);
    }

    void setScrollWidth(int n2, boolean bl2) {
        n2 += 3;
        int n3 = OS.SendMessage(this.handle, 403, 0, 0);
        if (bl2) {
            if (n2 <= n3) {
                return;
            }
            OS.SendMessage(this.handle, 404, n2, 0);
        } else {
            if (n2 < n3) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n3 = nArray.length;
        if (n3 == 0 || (this.style & 4) != 0 && n3 > 1) {
            return;
        }
        this.select(nArray, true);
        if ((this.style & 2) != 0 && (n2 = nArray[0]) >= 0) {
            this.setFocusIndex(n2);
        }
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = stringArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int n3 = -1;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            String string = stringArray[n4];
            int n5 = 0;
            if (string != null) {
                int n6 = -1;
                while ((n5 = this.indexOf(string, n5)) != -1) {
                    if (n6 == -1) {
                        n6 = n5;
                    }
                    this.select(n5, false);
                    if ((this.style & 4) != 0 && this.isSelected(n5)) {
                        this.showSelection();
                        return;
                    }
                    ++n5;
                }
                if (n6 != -1) {
                    n3 = n6;
                }
            }
            --n4;
        }
        if ((this.style & 2) != 0 && n3 >= 0) {
            this.setFocusIndex(n3);
        }
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.deselectAll();
        this.select(n2, true);
        if ((this.style & 2) != 0 && n2 >= 0) {
            this.setFocusIndex(n2);
        }
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        this.deselectAll();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        if ((this.style & 4) != 0) {
            this.select(n2, true);
        } else {
            this.select(n2, n3, true);
            this.setFocusIndex(n2);
        }
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 407, n2, 0);
        if (n3 == -1) {
            int n4 = OS.SendMessage(this.handle, 395, 0, 0);
            n2 = Math.min(n4 - 1, Math.max(0, n2));
            OS.SendMessage(this.handle, 407, n2, 0);
        }
    }

    public void showSelection() {
        int n2;
        int n3;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            n3 = OS.SendMessage(this.handle, 392, 0, 0);
        } else {
            int[] nArray = new int[1];
            n2 = OS.SendMessage(this.handle, 401, 1, nArray);
            n3 = nArray[0];
            if (n2 != 1) {
                n3 = -1;
            }
        }
        if (n3 == -1) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n4 == 0) {
            return;
        }
        n2 = OS.SendMessage(this.handle, 417, 0, 0);
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n5 = OS.SendMessage(this.handle, 398, 0, 0);
        int n6 = Math.max(rECT.bottom / n2, 1);
        int n7 = Math.min(n5 + n6, n4) - 1;
        if (n5 <= n3 && n3 <= n7) {
            return;
        }
        int n8 = Math.min(Math.max(n3 - n6 / 2, 0), n4 - 1);
        OS.SendMessage(this.handle, 407, n8, 0);
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() | 1 | 0x100;
        if ((this.style & 4) != 0) {
            return n2;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x40) != 0) {
                return n2 | 8;
            }
            return n2 | 0x800;
        }
        return n2;
    }

    TCHAR windowClass() {
        return ListClass;
    }

    int windowProc() {
        return ListProc;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        int n4 = OS.SendMessage(this.handle, 398, 0, 0);
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (!this.isDisposed()) {
            int n5;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            if (OS.GetScrollInfo(this.handle, 0, sCROLLINFO) && sCROLLINFO.nPos != 0) {
                OS.InvalidateRect(this.handle, null, true);
            }
            if (n4 != (n5 = OS.SendMessage(this.handle, 398, 0, 0))) {
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(int n2, int n3) {
        int n4 = n2 >> 16;
        switch (n4) {
            case 1: {
                this.postEvent(13);
                break;
            }
            case 2: {
                this.postEvent(14);
            }
        }
        return super.wmCommandChild(n2, n3);
    }
}

