/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class AdobeMarkerSegment
extends MarkerSegment {
    int version;
    int flags0;
    int flags1;
    int transform;
    private static final int ID_SIZE = 5;

    void print() {
        this.printTag("Adobe APP14");
        System.out.print("Version: ");
        System.out.println(this.version);
        System.out.print("Flags0: 0x");
        System.out.println(Integer.toHexString(this.flags0));
        System.out.print("Flags1: 0x");
        System.out.println(Integer.toHexString(this.flags1));
        System.out.print("Transform: ");
        System.out.println(this.transform);
    }

    AdobeMarkerSegment(int n2) {
        super(238);
        this.version = 101;
        this.flags0 = 0;
        this.flags1 = 0;
        this.transform = n2;
    }

    AdobeMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        jPEGBuffer.bufPtr += 5;
        this.version = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.version |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.flags0 = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.flags0 |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.flags1 = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.flags1 |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.transform = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        jPEGBuffer.bufAvail -= this.length;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("app14Adobe");
        iIOMetadataNode.setAttribute("version", Integer.toString(this.version));
        iIOMetadataNode.setAttribute("flags0", Integer.toString(this.flags0));
        iIOMetadataNode.setAttribute("flags1", Integer.toString(this.flags1));
        iIOMetadataNode.setAttribute("transform", Integer.toString(this.transform));
        return iIOMetadataNode;
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
        this.length = 14;
        this.writeTag(imageOutputStream);
        byte[] byArray = new byte[]{65, 100, 111, 98, 101};
        imageOutputStream.write(byArray);
        AdobeMarkerSegment.write2bytes(imageOutputStream, this.version);
        AdobeMarkerSegment.write2bytes(imageOutputStream, this.flags0);
        AdobeMarkerSegment.write2bytes(imageOutputStream, this.flags1);
        imageOutputStream.write(this.transform);
    }

    static void writeAdobeSegment(ImageOutputStream imageOutputStream, int n2) throws IOException {
        new AdobeMarkerSegment(n2).write(imageOutputStream);
    }

    AdobeMarkerSegment(Node node) throws IIOInvalidTreeException {
        this(0);
        this.updateFromNativeNode(node, true);
    }

    void updateFromNativeNode(Node node, boolean bl2) throws IIOInvalidTreeException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.transform = AdobeMarkerSegment.getAttributeValue(node, namedNodeMap, "transform", 0, 2, true);
        int n2 = namedNodeMap.getLength();
        if (n2 > 4) {
            throw new IIOInvalidTreeException("Adobe APP14 node cannot have > 4 attributes", node);
        }
        if (n2 > 1) {
            int n3 = AdobeMarkerSegment.getAttributeValue(node, namedNodeMap, "version", 100, 255, false);
            this.version = n3 != -1 ? n3 : this.version;
            n3 = AdobeMarkerSegment.getAttributeValue(node, namedNodeMap, "flags0", 0, 65535, false);
            this.flags0 = n3 != -1 ? n3 : this.flags0;
            n3 = AdobeMarkerSegment.getAttributeValue(node, namedNodeMap, "flags1", 0, 65535, false);
            this.flags1 = n3 != -1 ? n3 : this.flags1;
        }
    }
}

