/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;

public class MidiSystem {
    private static final String defaultServicesClassName = "com.sun.media.sound.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.media.sound.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{String.class};

    private MidiSystem() {
    }

    public static int[] getMidiFileTypes() {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        int[] nArray = null;
        for (int i2 = 0; i2 < midiFileWriterArray.length; ++i2) {
            nArray = midiFileWriterArray[i2].getMidiFileTypes();
            n2 += nArray.length;
            vector.addElement(nArray);
        }
        int[] nArray2 = new int[n2];
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            nArray = (int[])vector.elementAt(i3);
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                nArray2[n3++] = nArray[i4];
            }
        }
        return nArray2;
    }

    public static boolean isFileTypeSupported(int n2) {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        for (int i2 = 0; i2 < midiFileWriterArray.length; ++i2) {
            if (!midiFileWriterArray[i2].isFileTypeSupported(n2)) continue;
            return true;
        }
        return false;
    }

    private static Vector getMidiDeviceProviders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiDeviceProvider");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiDeviceProvider");
        }
        return vector;
    }

    private static Vector getSoundbankReaders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.SoundbankReader");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.SoundbankReader");
        }
        return vector;
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        return MidiSystem.getGenericDeviceInfo(MidiDevice.class);
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        return ((MidiDevice)MidiSystem.getGenericDevice(Receiver.class, null)).getReceiver();
    }

    public static boolean isFileTypeSupported(int n2, Sequence sequence) {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        for (int i2 = 0; i2 < midiFileWriterArray.length; ++i2) {
            if (!midiFileWriterArray[i2].isFileTypeSupported(n2, sequence)) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        int n2;
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int[][] nArrayArray = new int[midiFileWriterArray.length][];
        int[] nArray = null;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < midiFileWriterArray.length; ++n2) {
            nArrayArray[n2] = midiFileWriterArray[n2].getMidiFileTypes(sequence);
            n3 += nArrayArray[n2].length;
        }
        nArray = new int[n3];
        for (n2 = 0; n2 < midiFileWriterArray.length; ++n2) {
            for (int i2 = 0; i2 < nArrayArray[n2].length; ++i2) {
                nArray[n4] = nArrayArray[n2][i2];
                ++n4;
            }
        }
        return nArray;
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        return (Sequencer)MidiSystem.getGenericDevice(Sequencer.class, null);
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        return (Synthesizer)MidiSystem.getGenericDevice(Synthesizer.class, null);
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        return ((MidiDevice)MidiSystem.getGenericDevice(Transmitter.class, null)).getTransmitter();
    }

    private static MidiFileReader[] getMidiFileReaders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiFileReader");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiFileReader");
        }
        MidiFileReader[] midiFileReaderArray = new MidiFileReader[vector.size()];
        for (int i2 = 0; i2 < midiFileReaderArray.length; ++i2) {
            midiFileReaderArray[i2] = (MidiFileReader)vector.elementAt(i2);
        }
        return midiFileReaderArray;
    }

    private static MidiFileWriter[] getMidiFileWriters() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiFileWriter");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiFileWriter");
        }
        MidiFileWriter[] midiFileWriterArray = new MidiFileWriter[vector.size()];
        for (int i2 = 0; i2 < midiFileWriterArray.length; ++i2) {
            midiFileWriterArray[i2] = (MidiFileWriter)vector.elementAt(i2);
        }
        return midiFileWriterArray;
    }

    public static int write(Sequence sequence, int n2, File file) throws IOException {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int n3 = -2;
        for (int i2 = midiFileWriterArray.length - 1; i2 >= 0; --i2) {
            if (!midiFileWriterArray[i2].isFileTypeSupported(n2, sequence)) continue;
            n3 = midiFileWriterArray[i2].write(sequence, n2, file);
            break;
        }
        if (n3 == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return n3;
    }

    public static int write(Sequence sequence, int n2, OutputStream outputStream) throws IOException {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int n3 = -2;
        for (int i2 = midiFileWriterArray.length - 1; i2 >= 0; --i2) {
            if (!midiFileWriterArray[i2].isFileTypeSupported(n2, sequence)) continue;
            n3 = midiFileWriterArray[i2].write(sequence, n2, outputStream);
            break;
        }
        if (n3 == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return n3;
    }

    private static synchronized boolean isA(Class clazz, Class clazz2) {
        return clazz2.isAssignableFrom(clazz);
    }

    private static Vector getDefaultServices(String string) {
        Vector vector = null;
        try {
            Class clazz = Class.forName(defaultServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    private static Vector getJDK13Services(String string) {
        Vector vector = null;
        try {
            Class clazz = Class.forName(jdk13ServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        return (MidiDevice)MidiSystem.getGenericDevice(null, info);
    }

    private static MidiDevice.Info[] getGenericDeviceInfo(Class clazz) {
        int n2;
        Vector vector = new Vector();
        Vector vector2 = MidiSystem.getMidiDeviceProviders();
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            MidiDevice.Info[] infoArray = ((MidiDeviceProvider)vector2.elementAt(n2)).getDeviceInfo();
            for (int i2 = 0; i2 < infoArray.length; ++i2) {
                MidiDevice midiDevice = ((MidiDeviceProvider)vector2.elementAt(n2)).getDevice(infoArray[i2]);
                if (MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver)) {
                    if (midiDevice.getMaxReceivers() == 0) continue;
                    vector.addElement(infoArray[i2]);
                    continue;
                }
                if (MidiSystem.isA(clazz, class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter)) {
                    if (midiDevice.getMaxTransmitters() == 0) continue;
                    vector.addElement(infoArray[i2]);
                    continue;
                }
                if (!clazz.isInstance(midiDevice)) continue;
                vector.addElement(infoArray[i2]);
            }
        }
        MidiDevice.Info[] infoArray = new MidiDevice.Info[vector.size()];
        for (n2 = 0; n2 < infoArray.length; ++n2) {
            infoArray[n2] = (MidiDevice.Info)vector.elementAt(n2);
        }
        return infoArray;
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i2 = midiFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                midiFileFormat = midiFileReaderArray[i2].getMidiFileFormat(file);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("file is not a supported file type");
        }
        return midiFileFormat;
    }

    public static MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i2 = midiFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                midiFileFormat = midiFileReaderArray[i2].getMidiFileFormat(inputStream);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("input stream is not a supported file type");
        }
        return midiFileFormat;
    }

    public static MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i2 = midiFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                midiFileFormat = midiFileReaderArray[i2].getMidiFileFormat(uRL);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("url is not a supported file type");
        }
        return midiFileFormat;
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i2 = midiFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                sequence = midiFileReaderArray[i2].getSequence(file);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from file");
        }
        return sequence;
    }

    public static Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i2 = midiFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                sequence = midiFileReaderArray[i2].getSequence(inputStream);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from input stream");
        }
        return sequence;
    }

    public static Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i2 = midiFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                sequence = midiFileReaderArray[i2].getSequence(uRL);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from URL");
        }
        return sequence;
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return MidiSystem.getSoundbank(fileInputStream);
    }

    public static Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        Vector vector = MidiSystem.getSoundbankReaders();
        for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
            soundbankReader = (SoundbankReader)vector.elementAt(i2);
            soundbank = soundbankReader.getSoundbank(inputStream);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        Vector vector = MidiSystem.getSoundbankReaders();
        for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
            soundbankReader = (SoundbankReader)vector.elementAt(i2);
            soundbank = soundbankReader.getSoundbank(uRL);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    private static Object getGenericDevice(Class clazz, MidiDevice.Info info) {
        Object var4_2 = null;
        MidiDevice.Info[] infoArray = null;
        Vector vector = new Vector();
        vector = MidiSystem.getMidiDeviceProviders();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            MidiDevice midiDevice;
            int n2;
            infoArray = ((MidiDeviceProvider)vector.elementAt(i2)).getDeviceInfo();
            if (info == null) {
                for (n2 = 0; n2 < infoArray.length; ++n2) {
                    midiDevice = ((MidiDeviceProvider)vector.elementAt(i2)).getDevice(infoArray[n2]);
                    if (MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver)) {
                        if (midiDevice.getMaxReceivers() == 0) continue;
                        return midiDevice;
                    }
                    Class clazz2 = class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter;
                    if (!(MidiSystem.isA(clazz, clazz2) ? midiDevice.getMaxTransmitters() != 0 : clazz.isInstance(midiDevice))) continue;
                    return midiDevice;
                }
                continue;
            }
            for (n2 = 0; n2 < infoArray.length; ++n2) {
                if (!infoArray[n2].equals(info)) continue;
                midiDevice = ((MidiDeviceProvider)vector.elementAt(i2)).getDevice(infoArray[n2]);
                if (clazz == null) {
                    return midiDevice;
                }
                if (!(MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver) ? midiDevice.getMaxReceivers() != 0 : MidiSystem.isA(clazz, class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter) && midiDevice.getMaxTransmitters() != 0)) continue;
                return midiDevice;
            }
        }
        throw new IllegalArgumentException("Requested device not installed: " + info);
    }
}

