/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.ParagraphView;

class LineView
extends ParagraphView {
    int tabBase;

    protected int getCharactersPerTab() {
        return 8;
    }

    public boolean isVisible() {
        return true;
    }

    protected float getPreTab(float f2, int n2) {
        Document document = this.getDocument();
        View view = this.getViewAtPosition(n2, null);
        if (document instanceof StyledDocument && view != null) {
            Font font = ((StyledDocument)document).getFont(view.getAttributes());
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            int n3 = this.getCharactersPerTab() * fontMetrics.charWidth('W');
            int n4 = (int)this.getTabBase();
            return (((int)f2 - n4) / n3 + 1) * n3 + n4;
        }
        return 10.0f + f2;
    }

    public float nextTabStop(float f2, int n2) {
        if (this.getTabSet() == null && StyleConstants.getAlignment(this.getAttributes()) == 0) {
            return this.getPreTab(f2, n2);
        }
        return super.nextTabStop(f2, n2);
    }

    public float getAlignment(int n2) {
        if (n2 == 0) {
            return 0.0f;
        }
        return super.getAlignment(n2);
    }

    public float getMinimumSpan(int n2) {
        return this.getPreferredSpan(n2);
    }

    public int getResizeWeight(int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    protected void layout(int n2, int n3) {
        super.layout(0x7FFFFFFE, n3);
    }

    public LineView(Element element) {
        super(element);
    }
}

